/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.MultiMap;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 52\u00020\u0001:\u000245BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u00c6\u0003J\t\u0010(\u001a\u00020\rH\u00c6\u0003J\t\u0010)\u001a\u00020\u000fH\u00c6\u0003J\t\u0010*\u001a\u00020\u0011H\u00c6\u0003Ja\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\u000e\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u000202J\t\u00103\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00066"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionResult;", "", "encryptionAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "compressionAlgorithm", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "detachedSignatures", "Lorg/pgpainless/util/MultiMap;", "Lorg/pgpainless/key/SubkeyIdentifier;", "Lorg/bouncycastle/openpgp/PGPSignature;", "recipients", "", "fileName", "", "modificationDate", "Ljava/util/Date;", "fileEncoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "(Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;Lorg/pgpainless/algorithm/CompressionAlgorithm;Lorg/pgpainless/util/MultiMap;Ljava/util/Set;Ljava/lang/String;Ljava/util/Date;Lorg/pgpainless/algorithm/StreamEncoding;)V", "getCompressionAlgorithm", "()Lorg/pgpainless/algorithm/CompressionAlgorithm;", "getDetachedSignatures", "()Lorg/pgpainless/util/MultiMap;", "getEncryptionAlgorithm", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getFileEncoding", "()Lorg/pgpainless/algorithm/StreamEncoding;", "getFileName", "()Ljava/lang/String;", "isForYourEyesOnly", "", "()Z", "getModificationDate", "()Ljava/util/Date;", "getRecipients", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "isEncryptedFor", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "toString", "Builder", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nEncryptionResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionResult.kt\norg/pgpainless/encryption_signing/EncryptionResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1747#2,3:105\n*S KotlinDebug\n*F\n+ 1 EncryptionResult.kt\norg/pgpainless/encryption_signing/EncryptionResult\n*L\n43#1:105,3\n*E\n"})
public final class EncryptionResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SymmetricKeyAlgorithm encryptionAlgorithm;
    @NotNull
    private final CompressionAlgorithm compressionAlgorithm;
    @NotNull
    private final MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures;
    @NotNull
    private final Set<SubkeyIdentifier> recipients;
    @NotNull
    private final String fileName;
    @NotNull
    private final Date modificationDate;
    @NotNull
    private final StreamEncoding fileEncoding;

    public EncryptionResult(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm, @NotNull CompressionAlgorithm compressionAlgorithm, @NotNull MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures, @NotNull Set<SubkeyIdentifier> recipients, @NotNull String fileName, @NotNull Date modificationDate, @NotNull StreamEncoding fileEncoding) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm, "encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)compressionAlgorithm, "compressionAlgorithm");
        Intrinsics.checkNotNullParameter(detachedSignatures, "detachedSignatures");
        Intrinsics.checkNotNullParameter(recipients, "recipients");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(modificationDate, "modificationDate");
        Intrinsics.checkNotNullParameter((Object)fileEncoding, "fileEncoding");
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.detachedSignatures = detachedSignatures;
        this.recipients = recipients;
        this.fileName = fileName;
        this.modificationDate = modificationDate;
        this.fileEncoding = fileEncoding;
    }

    @NotNull
    public final SymmetricKeyAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @NotNull
    public final CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @NotNull
    public final MultiMap<SubkeyIdentifier, PGPSignature> getDetachedSignatures() {
        return this.detachedSignatures;
    }

    @NotNull
    public final Set<SubkeyIdentifier> getRecipients() {
        return this.recipients;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Date getModificationDate() {
        return this.modificationDate;
    }

    @NotNull
    public final StreamEncoding getFileEncoding() {
        return this.fileEncoding;
    }

    public final boolean isForYourEyesOnly() {
        return Intrinsics.areEqual("_CONSOLE", this.fileName);
    }

    public final boolean isEncryptedFor(@NotNull PGPPublicKeyRing certificate) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            Iterable $this$any$iv = this.recipients;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SubkeyIdentifier it = (SubkeyIdentifier)element$iv;
                    boolean bl2 = false;
                    if (!PGPKeyRingExtensionsKt.matches(certificate, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final SymmetricKeyAlgorithm component1() {
        return this.encryptionAlgorithm;
    }

    @NotNull
    public final CompressionAlgorithm component2() {
        return this.compressionAlgorithm;
    }

    @NotNull
    public final MultiMap<SubkeyIdentifier, PGPSignature> component3() {
        return this.detachedSignatures;
    }

    @NotNull
    public final Set<SubkeyIdentifier> component4() {
        return this.recipients;
    }

    @NotNull
    public final String component5() {
        return this.fileName;
    }

    @NotNull
    public final Date component6() {
        return this.modificationDate;
    }

    @NotNull
    public final StreamEncoding component7() {
        return this.fileEncoding;
    }

    @NotNull
    public final EncryptionResult copy(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm, @NotNull CompressionAlgorithm compressionAlgorithm, @NotNull MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures, @NotNull Set<SubkeyIdentifier> recipients, @NotNull String fileName, @NotNull Date modificationDate, @NotNull StreamEncoding fileEncoding) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm, "encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)compressionAlgorithm, "compressionAlgorithm");
        Intrinsics.checkNotNullParameter(detachedSignatures, "detachedSignatures");
        Intrinsics.checkNotNullParameter(recipients, "recipients");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(modificationDate, "modificationDate");
        Intrinsics.checkNotNullParameter((Object)fileEncoding, "fileEncoding");
        return new EncryptionResult(encryptionAlgorithm, compressionAlgorithm, detachedSignatures, recipients, fileName, modificationDate, fileEncoding);
    }

    public static /* synthetic */ EncryptionResult copy$default(EncryptionResult encryptionResult, SymmetricKeyAlgorithm symmetricKeyAlgorithm, CompressionAlgorithm compressionAlgorithm, MultiMap multiMap, Set set, String string, Date date, StreamEncoding streamEncoding, int n, Object object) {
        if ((n & 1) != 0) {
            symmetricKeyAlgorithm = encryptionResult.encryptionAlgorithm;
        }
        if ((n & 2) != 0) {
            compressionAlgorithm = encryptionResult.compressionAlgorithm;
        }
        if ((n & 4) != 0) {
            multiMap = encryptionResult.detachedSignatures;
        }
        if ((n & 8) != 0) {
            set = encryptionResult.recipients;
        }
        if ((n & 0x10) != 0) {
            string = encryptionResult.fileName;
        }
        if ((n & 0x20) != 0) {
            date = encryptionResult.modificationDate;
        }
        if ((n & 0x40) != 0) {
            streamEncoding = encryptionResult.fileEncoding;
        }
        return encryptionResult.copy(symmetricKeyAlgorithm, compressionAlgorithm, multiMap, set, string, date, streamEncoding);
    }

    @NotNull
    public String toString() {
        return "EncryptionResult(encryptionAlgorithm=" + (Object)((Object)this.encryptionAlgorithm) + ", compressionAlgorithm=" + (Object)((Object)this.compressionAlgorithm) + ", detachedSignatures=" + this.detachedSignatures + ", recipients=" + this.recipients + ", fileName=" + this.fileName + ", modificationDate=" + this.modificationDate + ", fileEncoding=" + (Object)((Object)this.fileEncoding) + ')';
    }

    public int hashCode() {
        int result = this.encryptionAlgorithm.hashCode();
        result = result * 31 + this.compressionAlgorithm.hashCode();
        result = result * 31 + this.detachedSignatures.hashCode();
        result = result * 31 + ((Object)this.recipients).hashCode();
        result = result * 31 + this.fileName.hashCode();
        result = result * 31 + this.modificationDate.hashCode();
        result = result * 31 + this.fileEncoding.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncryptionResult)) {
            return false;
        }
        EncryptionResult encryptionResult = (EncryptionResult)other;
        if (this.encryptionAlgorithm != encryptionResult.encryptionAlgorithm) {
            return false;
        }
        if (this.compressionAlgorithm != encryptionResult.compressionAlgorithm) {
            return false;
        }
        if (!Intrinsics.areEqual(this.detachedSignatures, encryptionResult.detachedSignatures)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.recipients, encryptionResult.recipients)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fileName, encryptionResult.fileName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.modificationDate, encryptionResult.modificationDate)) {
            return false;
        }
        return this.fileEncoding == encryptionResult.fileEncoding;
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0018J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0017J\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\fJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0012J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00060"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionResult$Builder;", "", "()V", "_compressionAlgorithm", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "get_compressionAlgorithm", "()Lorg/pgpainless/algorithm/CompressionAlgorithm;", "set_compressionAlgorithm", "(Lorg/pgpainless/algorithm/CompressionAlgorithm;)V", "_encoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "_encryptionAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "get_encryptionAlgorithm", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "set_encryptionAlgorithm", "(Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;)V", "_fileName", "", "_modificationDate", "Ljava/util/Date;", "detachedSignatures", "Lorg/pgpainless/util/MultiMap;", "Lorg/pgpainless/key/SubkeyIdentifier;", "Lorg/bouncycastle/openpgp/PGPSignature;", "getDetachedSignatures", "()Lorg/pgpainless/util/MultiMap;", "recipients", "", "getRecipients", "()Ljava/util/Set;", "addDetachedSignature", "signingSubkeyIdentifier", "detachedSignature", "addRecipient", "recipient", "build", "Lorg/pgpainless/encryption_signing/EncryptionResult;", "setCompressionAlgorithm", "compressionAlgorithm", "setEncryptionAlgorithm", "encryptionAlgorithm", "setFileEncoding", "encoding", "setFileName", "fileName", "setModificationDate", "modificationDate", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nEncryptionResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionResult.kt\norg/pgpainless/encryption_signing/EncryptionResult$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
    public static final class Builder {
        @Nullable
        private SymmetricKeyAlgorithm _encryptionAlgorithm;
        @Nullable
        private CompressionAlgorithm _compressionAlgorithm;
        @NotNull
        private final MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures = new MultiMap();
        @NotNull
        private final Set<SubkeyIdentifier> recipients = new LinkedHashSet();
        @NotNull
        private String _fileName = "";
        @NotNull
        private Date _modificationDate = new Date(0L);
        @NotNull
        private StreamEncoding _encoding = StreamEncoding.BINARY;

        @Nullable
        public final SymmetricKeyAlgorithm get_encryptionAlgorithm() {
            return this._encryptionAlgorithm;
        }

        public final void set_encryptionAlgorithm(@Nullable SymmetricKeyAlgorithm symmetricKeyAlgorithm) {
            this._encryptionAlgorithm = symmetricKeyAlgorithm;
        }

        @Nullable
        public final CompressionAlgorithm get_compressionAlgorithm() {
            return this._compressionAlgorithm;
        }

        public final void set_compressionAlgorithm(@Nullable CompressionAlgorithm compressionAlgorithm) {
            this._compressionAlgorithm = compressionAlgorithm;
        }

        @NotNull
        public final MultiMap<SubkeyIdentifier, PGPSignature> getDetachedSignatures() {
            return this.detachedSignatures;
        }

        @NotNull
        public final Set<SubkeyIdentifier> getRecipients() {
            return this.recipients;
        }

        @NotNull
        public final Builder setEncryptionAlgorithm(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm, "encryptionAlgorithm");
            Builder $this$setEncryptionAlgorithm_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setEncryptionAlgorithm_u24lambda_u240._encryptionAlgorithm = encryptionAlgorithm;
            return builder;
        }

        @NotNull
        public final Builder setCompressionAlgorithm(@NotNull CompressionAlgorithm compressionAlgorithm) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)compressionAlgorithm, "compressionAlgorithm");
            Builder $this$setCompressionAlgorithm_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setCompressionAlgorithm_u24lambda_u241._compressionAlgorithm = compressionAlgorithm;
            return builder;
        }

        @NotNull
        public final Builder setFileName(@NotNull String fileName) {
            Builder builder;
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            Builder $this$setFileName_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setFileName_u24lambda_u242._fileName = fileName;
            return builder;
        }

        @NotNull
        public final Builder setModificationDate(@NotNull Date modificationDate) {
            Builder builder;
            Intrinsics.checkNotNullParameter(modificationDate, "modificationDate");
            Builder $this$setModificationDate_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$setModificationDate_u24lambda_u243._modificationDate = modificationDate;
            return builder;
        }

        @NotNull
        public final Builder setFileEncoding(@NotNull StreamEncoding encoding) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            Builder $this$setFileEncoding_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$setFileEncoding_u24lambda_u244._encoding = encoding;
            return builder;
        }

        @NotNull
        public final Builder addRecipient(@NotNull SubkeyIdentifier recipient) {
            Builder builder;
            Intrinsics.checkNotNullParameter(recipient, "recipient");
            Builder $this$addRecipient_u24lambda_u245 = builder = this;
            boolean bl = false;
            Set<SubkeyIdentifier> set = $this$addRecipient_u24lambda_u245.recipients;
            Intrinsics.checkNotNull(set, "null cannot be cast to non-null type kotlin.collections.MutableSet<org.pgpainless.key.SubkeyIdentifier>");
            TypeIntrinsics.asMutableSet(set).add(recipient);
            return builder;
        }

        @NotNull
        public final Builder addDetachedSignature(@NotNull SubkeyIdentifier signingSubkeyIdentifier, @NotNull PGPSignature detachedSignature) {
            Builder builder;
            Intrinsics.checkNotNullParameter(signingSubkeyIdentifier, "signingSubkeyIdentifier");
            Intrinsics.checkNotNullParameter(detachedSignature, "detachedSignature");
            Builder $this$addDetachedSignature_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$addDetachedSignature_u24lambda_u246.detachedSignatures.put(signingSubkeyIdentifier, detachedSignature);
            return builder;
        }

        @NotNull
        public final EncryptionResult build() {
            if (this._encryptionAlgorithm == null) {
                boolean $i$a$-checkNotNull-EncryptionResult$Builder$build$32 = false;
                String $i$a$-checkNotNull-EncryptionResult$Builder$build$32 = "Encryption algorithm not set.";
                throw new IllegalStateException($i$a$-checkNotNull-EncryptionResult$Builder$build$32.toString());
            }
            if (this._compressionAlgorithm == null) {
                boolean bl = false;
                String string = "Compression algorithm not set.";
                throw new IllegalStateException(string.toString());
            }
            SymmetricKeyAlgorithm symmetricKeyAlgorithm = this._encryptionAlgorithm;
            Intrinsics.checkNotNull((Object)symmetricKeyAlgorithm);
            CompressionAlgorithm compressionAlgorithm = this._compressionAlgorithm;
            Intrinsics.checkNotNull((Object)compressionAlgorithm);
            return new EncryptionResult(symmetricKeyAlgorithm, compressionAlgorithm, this.detachedSignatures, this.recipients, this._fileName, this._modificationDate, this._encoding);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionResult$Companion;", "", "()V", "builder", "Lorg/pgpainless/encryption_signing/EncryptionResult$Builder;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

