/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.exception;

import java.util.Map;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.SignatureType;

public class SignatureValidationException
extends PGPException {
    public SignatureValidationException(String message2) {
        super(message2);
    }

    public SignatureValidationException(String message2, Exception underlying) {
        super(message2, underlying);
    }

    public SignatureValidationException(String message2, Map<PGPSignature, Exception> rejections) {
        super(message2 + ": " + SignatureValidationException.exceptionMapToString(rejections));
    }

    private static String exceptionMapToString(Map<PGPSignature, Exception> rejections) {
        StringBuilder sb = new StringBuilder();
        sb.append(rejections.size()).append(" rejected signatures:\n");
        for (PGPSignature signature : rejections.keySet()) {
            SignatureType type = SignatureType.fromCode(signature.getSignatureType());
            String typeString = type == null ? "0x" + Long.toHexString(signature.getSignatureType()) : type.toString();
            sb.append(typeString).append(' ').append(signature.getCreationTime()).append(": ").append(rejections.get(signature).getMessage()).append('\n');
        }
        return sb.toString();
    }
}

