/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.implementation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.BcImplementationFactory;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.SessionKey;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 H2\u00020\u0001:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H&J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H&J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020$2\u0006\u0010!\u001a\u00020$H&J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020$H&J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010+\u001a\u00020\u00102\u0006\u0010!\u001a\u00020$J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H&J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H&J\u000e\u00103\u001a\u0002042\u0006\u00107\u001a\u000208J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H&J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H&J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH&J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020EJ\b\u0010F\u001a\u00020GH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006I"}, d2={"Lorg/pgpainless/implementation/ImplementationFactory;", "", "()V", "keyFingerprintCalculator", "Lorg/bouncycastle/openpgp/operator/KeyFingerPrintCalculator;", "getKeyFingerprintCalculator", "()Lorg/bouncycastle/openpgp/operator/KeyFingerPrintCalculator;", "pgpContentVerifierBuilderProvider", "Lorg/bouncycastle/openpgp/operator/PGPContentVerifierBuilderProvider;", "getPgpContentVerifierBuilderProvider", "()Lorg/bouncycastle/openpgp/operator/PGPContentVerifierBuilderProvider;", "pgpDigestCalculatorProvider", "Lorg/bouncycastle/openpgp/operator/PGPDigestCalculatorProvider;", "getPgpDigestCalculatorProvider", "()Lorg/bouncycastle/openpgp/operator/PGPDigestCalculatorProvider;", "v4FingerprintCalculator", "Lorg/bouncycastle/openpgp/operator/PGPDigestCalculator;", "getV4FingerprintCalculator", "()Lorg/bouncycastle/openpgp/operator/PGPDigestCalculator;", "getPBEDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/PBEDataDecryptorFactory;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "getPBEKeyEncryptionMethodGenerator", "Lorg/bouncycastle/openpgp/operator/PBEKeyEncryptionMethodGenerator;", "getPBESecretKeyDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "getPBESecretKeyEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "symmetricKeyAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "digestCalculator", "encryptionAlgorithm", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "s2kCount", "", "getPGPContentSignerBuilder", "Lorg/bouncycastle/openpgp/operator/PGPContentSignerBuilder;", "keyAlgorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getPGPDataEncryptorBuilder", "Lorg/bouncycastle/openpgp/operator/PGPDataEncryptorBuilder;", "getPGPDigestCalculator", "getPGPKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "publicKeyAlgorithm", "keyPair", "Ljava/security/KeyPair;", "creationDate", "Ljava/util/Date;", "getPGPObjectFactory", "Lorg/bouncycastle/openpgp/PGPObjectFactory;", "inputStream", "Ljava/io/InputStream;", "bytes", "", "getPublicKeyDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/PublicKeyDataDecryptorFactory;", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "getPublicKeyKeyEncryptionMethodGenerator", "Lorg/bouncycastle/openpgp/operator/PublicKeyKeyEncryptionMethodGenerator;", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "getSessionKeyDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/SessionKeyDataDecryptorFactory;", "sessionKey", "Lorg/bouncycastle/openpgp/PGPSessionKey;", "Lorg/pgpainless/util/SessionKey;", "toString", "", "Companion", "pgpainless-core"})
public abstract class ImplementationFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static ImplementationFactory instance = new BcImplementationFactory();

    @NotNull
    public abstract PGPDigestCalculatorProvider getPgpDigestCalculatorProvider();

    @NotNull
    public abstract PGPContentVerifierBuilderProvider getPgpContentVerifierBuilderProvider();

    @NotNull
    public abstract KeyFingerPrintCalculator getKeyFingerprintCalculator();

    @NotNull
    public final PGPDigestCalculator getV4FingerprintCalculator() {
        return this.getPGPDigestCalculator(HashAlgorithm.SHA1);
    }

    @NotNull
    public abstract PBESecretKeyEncryptor getPBESecretKeyEncryptor(@NotNull SymmetricKeyAlgorithm var1, @NotNull PGPDigestCalculator var2, @NotNull Passphrase var3) throws PGPException;

    @NotNull
    public abstract PBESecretKeyDecryptor getPBESecretKeyDecryptor(@NotNull Passphrase var1) throws PGPException;

    @NotNull
    public abstract PBESecretKeyEncryptor getPBESecretKeyEncryptor(@NotNull SymmetricKeyAlgorithm var1, @NotNull HashAlgorithm var2, int var3, @NotNull Passphrase var4) throws PGPException;

    @NotNull
    public final PGPDigestCalculator getPGPDigestCalculator(@NotNull HashAlgorithm hashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)hashAlgorithm, "hashAlgorithm");
        return this.getPGPDigestCalculator(hashAlgorithm.getAlgorithmId());
    }

    @NotNull
    public final PGPDigestCalculator getPGPDigestCalculator(int hashAlgorithm) {
        PGPDigestCalculator pGPDigestCalculator = this.getPgpDigestCalculatorProvider().get(hashAlgorithm);
        Intrinsics.checkNotNullExpressionValue(pGPDigestCalculator, "pgpDigestCalculatorProvider.get(hashAlgorithm)");
        return pGPDigestCalculator;
    }

    @NotNull
    public final PGPContentSignerBuilder getPGPContentSignerBuilder(@NotNull PublicKeyAlgorithm keyAlgorithm, @NotNull HashAlgorithm hashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)keyAlgorithm, "keyAlgorithm");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithm, "hashAlgorithm");
        return this.getPGPContentSignerBuilder(keyAlgorithm.getAlgorithmId(), hashAlgorithm.getAlgorithmId());
    }

    @NotNull
    public abstract PGPContentSignerBuilder getPGPContentSignerBuilder(int var1, int var2);

    @NotNull
    public abstract PBEDataDecryptorFactory getPBEDataDecryptorFactory(@NotNull Passphrase var1) throws PGPException;

    @NotNull
    public abstract PublicKeyDataDecryptorFactory getPublicKeyDataDecryptorFactory(@NotNull PGPPrivateKey var1);

    @NotNull
    public final SessionKeyDataDecryptorFactory getSessionKeyDataDecryptorFactory(@NotNull SessionKey sessionKey) {
        Intrinsics.checkNotNullParameter(sessionKey, "sessionKey");
        return this.getSessionKeyDataDecryptorFactory(new PGPSessionKey(sessionKey.getAlgorithm().getAlgorithmId(), sessionKey.getKey()));
    }

    @NotNull
    public abstract SessionKeyDataDecryptorFactory getSessionKeyDataDecryptorFactory(@NotNull PGPSessionKey var1);

    @NotNull
    public abstract PublicKeyKeyEncryptionMethodGenerator getPublicKeyKeyEncryptionMethodGenerator(@NotNull PGPPublicKey var1);

    @NotNull
    public abstract PBEKeyEncryptionMethodGenerator getPBEKeyEncryptionMethodGenerator(@NotNull Passphrase var1);

    @NotNull
    public final PGPDataEncryptorBuilder getPGPDataEncryptorBuilder(@NotNull SymmetricKeyAlgorithm symmetricKeyAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)symmetricKeyAlgorithm, "symmetricKeyAlgorithm");
        return this.getPGPDataEncryptorBuilder(symmetricKeyAlgorithm.getAlgorithmId());
    }

    @NotNull
    public abstract PGPDataEncryptorBuilder getPGPDataEncryptorBuilder(int var1);

    @NotNull
    public abstract PGPKeyPair getPGPKeyPair(@NotNull PublicKeyAlgorithm var1, @NotNull KeyPair var2, @NotNull Date var3) throws PGPException;

    @NotNull
    public final PGPObjectFactory getPGPObjectFactory(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        return this.getPGPObjectFactory(new ByteArrayInputStream(bytes));
    }

    @NotNull
    public abstract PGPObjectFactory getPGPObjectFactory(@NotNull InputStream var1);

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "javaClass.simpleName");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ImplementationFactory getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final Companion setFactoryImplementation(@NotNull ImplementationFactory implementation) {
        return Companion.setFactoryImplementation(implementation);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004H\u0007R\u0018\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\t"}, d2={"Lorg/pgpainless/implementation/ImplementationFactory$Companion;", "", "()V", "instance", "Lorg/pgpainless/implementation/ImplementationFactory;", "getInstance$annotations", "getInstance", "setFactoryImplementation", "implementation", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getInstance$annotations() {
        }

        @JvmStatic
        @NotNull
        public final ImplementationFactory getInstance() {
            return instance;
        }

        @JvmStatic
        @NotNull
        public final Companion setFactoryImplementation(@NotNull ImplementationFactory implementation) {
            Companion companion;
            Intrinsics.checkNotNullParameter(implementation, "implementation");
            Companion $this$setFactoryImplementation_u24lambda_u240 = companion = this;
            boolean bl = false;
            instance = implementation;
            return companion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

