/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.implementation;

import java.io.InputStream;
import java.security.KeyPair;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JceSessionKeyDataDecryptorFactoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.provider.ProviderFactory;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020!H\u0016J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006?"}, d2={"Lorg/pgpainless/implementation/JceImplementationFactory;", "Lorg/pgpainless/implementation/ImplementationFactory;", "()V", "keyFingerprintCalculator", "Lorg/bouncycastle/openpgp/operator/KeyFingerPrintCalculator;", "getKeyFingerprintCalculator", "()Lorg/bouncycastle/openpgp/operator/KeyFingerPrintCalculator;", "pgpContentVerifierBuilderProvider", "Lorg/bouncycastle/openpgp/operator/PGPContentVerifierBuilderProvider;", "getPgpContentVerifierBuilderProvider", "()Lorg/bouncycastle/openpgp/operator/PGPContentVerifierBuilderProvider;", "pgpDigestCalculatorProvider", "Lorg/bouncycastle/openpgp/operator/PGPDigestCalculatorProvider;", "getPgpDigestCalculatorProvider", "()Lorg/bouncycastle/openpgp/operator/PGPDigestCalculatorProvider;", "getPBEDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/PBEDataDecryptorFactory;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "getPBEKeyEncryptionMethodGenerator", "Lorg/bouncycastle/openpgp/operator/PBEKeyEncryptionMethodGenerator;", "getPBESecretKeyDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "getPBESecretKeyEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "symmetricKeyAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "digestCalculator", "Lorg/bouncycastle/openpgp/operator/PGPDigestCalculator;", "encryptionAlgorithm", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "s2kCount", "", "getPGPContentSignerBuilder", "Lorg/bouncycastle/openpgp/operator/PGPContentSignerBuilder;", "keyAlgorithm", "getPGPDataEncryptorBuilder", "Lorg/bouncycastle/openpgp/operator/PGPDataEncryptorBuilder;", "getPGPKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "publicKeyAlgorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "keyPair", "Ljava/security/KeyPair;", "creationDate", "Ljava/util/Date;", "getPGPObjectFactory", "Lorg/bouncycastle/openpgp/PGPObjectFactory;", "inputStream", "Ljava/io/InputStream;", "getPublicKeyDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/PublicKeyDataDecryptorFactory;", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "getPublicKeyKeyEncryptionMethodGenerator", "Lorg/bouncycastle/openpgp/operator/PublicKeyKeyEncryptionMethodGenerator;", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "getSessionKeyDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/SessionKeyDataDecryptorFactory;", "sessionKey", "Lorg/bouncycastle/openpgp/PGPSessionKey;", "pgpainless-core"})
public final class JceImplementationFactory
extends ImplementationFactory {
    @NotNull
    private final PGPDigestCalculatorProvider pgpDigestCalculatorProvider;
    @NotNull
    private final PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider;
    @NotNull
    private final KeyFingerPrintCalculator keyFingerprintCalculator;

    public JceImplementationFactory() {
        PGPDigestCalculatorProvider pGPDigestCalculatorProvider = new JcaPGPDigestCalculatorProviderBuilder().setProvider(ProviderFactory.Companion.getProvider()).build();
        Intrinsics.checkNotNullExpressionValue(pGPDigestCalculatorProvider, "JcaPGPDigestCalculatorPr\u2026Factory.provider).build()");
        this.pgpDigestCalculatorProvider = pGPDigestCalculatorProvider;
        JcaPGPContentVerifierBuilderProvider jcaPGPContentVerifierBuilderProvider = new JcaPGPContentVerifierBuilderProvider().setProvider(ProviderFactory.Companion.getProvider());
        Intrinsics.checkNotNullExpressionValue(jcaPGPContentVerifierBuilderProvider, "JcaPGPContentVerifierBui\u2026ProviderFactory.provider)");
        this.pgpContentVerifierBuilderProvider = jcaPGPContentVerifierBuilderProvider;
        JcaKeyFingerprintCalculator jcaKeyFingerprintCalculator = new JcaKeyFingerprintCalculator().setProvider(ProviderFactory.Companion.getProvider());
        Intrinsics.checkNotNullExpressionValue(jcaKeyFingerprintCalculator, "JcaKeyFingerprintCalcula\u2026ProviderFactory.provider)");
        this.keyFingerprintCalculator = jcaKeyFingerprintCalculator;
    }

    @Override
    @NotNull
    public PGPDigestCalculatorProvider getPgpDigestCalculatorProvider() {
        return this.pgpDigestCalculatorProvider;
    }

    @Override
    @NotNull
    public PGPContentVerifierBuilderProvider getPgpContentVerifierBuilderProvider() {
        return this.pgpContentVerifierBuilderProvider;
    }

    @Override
    @NotNull
    public KeyFingerPrintCalculator getKeyFingerprintCalculator() {
        return this.keyFingerprintCalculator;
    }

    @Override
    @NotNull
    public PBESecretKeyEncryptor getPBESecretKeyEncryptor(@NotNull SymmetricKeyAlgorithm symmetricKeyAlgorithm, @NotNull PGPDigestCalculator digestCalculator, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)symmetricKeyAlgorithm, "symmetricKeyAlgorithm");
        Intrinsics.checkNotNullParameter(digestCalculator, "digestCalculator");
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        PBESecretKeyEncryptor pBESecretKeyEncryptor = new JcePBESecretKeyEncryptorBuilder(symmetricKeyAlgorithm.getAlgorithmId(), digestCalculator).setProvider(ProviderFactory.Companion.getProvider()).build(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue(pBESecretKeyEncryptor, "JcePBESecretKeyEncryptor\u2026ld(passphrase.getChars())");
        return pBESecretKeyEncryptor;
    }

    @Override
    @NotNull
    public PBESecretKeyEncryptor getPBESecretKeyEncryptor(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm, @NotNull HashAlgorithm hashAlgorithm, int s2kCount, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm, "encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithm, "hashAlgorithm");
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        PBESecretKeyEncryptor pBESecretKeyEncryptor = new JcePBESecretKeyEncryptorBuilder(encryptionAlgorithm.getAlgorithmId(), this.getPGPDigestCalculator(hashAlgorithm), s2kCount).setProvider(ProviderFactory.Companion.getProvider()).build(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue(pBESecretKeyEncryptor, "JcePBESecretKeyEncryptor\u2026ld(passphrase.getChars())");
        return pBESecretKeyEncryptor;
    }

    @Override
    @NotNull
    public PBESecretKeyDecryptor getPBESecretKeyDecryptor(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        PBESecretKeyDecryptor pBESecretKeyDecryptor = new JcePBESecretKeyDecryptorBuilder(this.getPgpDigestCalculatorProvider()).setProvider(ProviderFactory.Companion.getProvider()).build(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue(pBESecretKeyDecryptor, "JcePBESecretKeyDecryptor\u2026ld(passphrase.getChars())");
        return pBESecretKeyDecryptor;
    }

    @Override
    @NotNull
    public PGPContentSignerBuilder getPGPContentSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        JcaPGPContentSignerBuilder jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(keyAlgorithm, hashAlgorithm).setProvider(ProviderFactory.Companion.getProvider());
        Intrinsics.checkNotNullExpressionValue(jcaPGPContentSignerBuilder, "JcaPGPContentSignerBuild\u2026ProviderFactory.provider)");
        return jcaPGPContentSignerBuilder;
    }

    @Override
    @NotNull
    public PBEDataDecryptorFactory getPBEDataDecryptorFactory(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        PBEDataDecryptorFactory pBEDataDecryptorFactory = new JcePBEDataDecryptorFactoryBuilder(this.getPgpDigestCalculatorProvider()).setProvider(ProviderFactory.Companion.getProvider()).build(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue(pBEDataDecryptorFactory, "JcePBEDataDecryptorFacto\u2026ld(passphrase.getChars())");
        return pBEDataDecryptorFactory;
    }

    @Override
    @NotNull
    public PublicKeyDataDecryptorFactory getPublicKeyDataDecryptorFactory(@NotNull PGPPrivateKey privateKey) {
        Intrinsics.checkNotNullParameter(privateKey, "privateKey");
        PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(ProviderFactory.Companion.getProvider()).build(privateKey);
        Intrinsics.checkNotNullExpressionValue(publicKeyDataDecryptorFactory, "JcePublicKeyDataDecrypto\u2026       .build(privateKey)");
        return publicKeyDataDecryptorFactory;
    }

    @Override
    @NotNull
    public SessionKeyDataDecryptorFactory getSessionKeyDataDecryptorFactory(@NotNull PGPSessionKey sessionKey) {
        Intrinsics.checkNotNullParameter(sessionKey, "sessionKey");
        SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory = new JceSessionKeyDataDecryptorFactoryBuilder().setProvider(ProviderFactory.Companion.getProvider()).build(sessionKey);
        Intrinsics.checkNotNullExpressionValue(sessionKeyDataDecryptorFactory, "JceSessionKeyDataDecrypt\u2026       .build(sessionKey)");
        return sessionKeyDataDecryptorFactory;
    }

    @Override
    @NotNull
    public PublicKeyKeyEncryptionMethodGenerator getPublicKeyKeyEncryptionMethodGenerator(@NotNull PGPPublicKey key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        JcePublicKeyKeyEncryptionMethodGenerator jcePublicKeyKeyEncryptionMethodGenerator = new JcePublicKeyKeyEncryptionMethodGenerator(key2).setProvider(ProviderFactory.Companion.getProvider());
        Intrinsics.checkNotNullExpressionValue(jcePublicKeyKeyEncryptionMethodGenerator, "JcePublicKeyKeyEncryptio\u2026ProviderFactory.provider)");
        return jcePublicKeyKeyEncryptionMethodGenerator;
    }

    @Override
    @NotNull
    public PBEKeyEncryptionMethodGenerator getPBEKeyEncryptionMethodGenerator(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        JcePBEKeyEncryptionMethodGenerator jcePBEKeyEncryptionMethodGenerator = new JcePBEKeyEncryptionMethodGenerator(passphrase.getChars()).setProvider(ProviderFactory.Companion.getProvider());
        Intrinsics.checkNotNullExpressionValue(jcePBEKeyEncryptionMethodGenerator, "JcePBEKeyEncryptionMetho\u2026ProviderFactory.provider)");
        return jcePBEKeyEncryptionMethodGenerator;
    }

    @Override
    @NotNull
    public PGPDataEncryptorBuilder getPGPDataEncryptorBuilder(int symmetricKeyAlgorithm) {
        JcePGPDataEncryptorBuilder jcePGPDataEncryptorBuilder = new JcePGPDataEncryptorBuilder(symmetricKeyAlgorithm).setProvider(ProviderFactory.Companion.getProvider());
        Intrinsics.checkNotNullExpressionValue(jcePGPDataEncryptorBuilder, "JcePGPDataEncryptorBuild\u2026ProviderFactory.provider)");
        return jcePGPDataEncryptorBuilder;
    }

    @Override
    @NotNull
    public PGPKeyPair getPGPKeyPair(@NotNull PublicKeyAlgorithm publicKeyAlgorithm, @NotNull KeyPair keyPair, @NotNull Date creationDate) {
        Intrinsics.checkNotNullParameter((Object)publicKeyAlgorithm, "publicKeyAlgorithm");
        Intrinsics.checkNotNullParameter(keyPair, "keyPair");
        Intrinsics.checkNotNullParameter(creationDate, "creationDate");
        return new JcaPGPKeyPair(publicKeyAlgorithm.getAlgorithmId(), keyPair, creationDate);
    }

    @Override
    @NotNull
    public PGPObjectFactory getPGPObjectFactory(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        return new PGPObjectFactory(inputStream, this.getKeyFingerprintCalculator());
    }
}

