/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.bouncycastle.extensions.PGPPublicKeyExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;

@Deprecated(message="Deprecated in favor of extension functions to PGPSecretKey and PGPPublicKey.")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u001a\u0010\t\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u00108GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\f\u001a\u0004\b\u0013\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\f\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lorg/pgpainless/key/info/KeyInfo;", "", "secretKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;)V", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "(Lorg/bouncycastle/openpgp/PGPPublicKey;)V", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/bouncycastle/openpgp/PGPPublicKey;)V", "curveName", "", "getCurveName$annotations", "()V", "getCurveName", "()Ljava/lang/String;", "hasDummyS2K", "", "hasDummyS2K$annotations", "()Z", "isDecrypted", "isDecrypted$annotations", "isEncrypted", "isEncrypted$annotations", "getPublicKey", "()Lorg/bouncycastle/openpgp/PGPPublicKey;", "getSecretKey", "()Lorg/bouncycastle/openpgp/PGPSecretKey;", "Companion", "pgpainless-core"})
public final class KeyInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PGPSecretKey secretKey;
    @NotNull
    private final PGPPublicKey publicKey;

    private KeyInfo(PGPSecretKey secretKey, PGPPublicKey publicKey) {
        this.secretKey = secretKey;
        this.publicKey = publicKey;
    }

    @Nullable
    public final PGPSecretKey getSecretKey() {
        return this.secretKey;
    }

    @NotNull
    public final PGPPublicKey getPublicKey() {
        return this.publicKey;
    }

    public KeyInfo(@NotNull PGPSecretKey secretKey) {
        Intrinsics.checkNotNullParameter(secretKey, "secretKey");
        PGPPublicKey pGPPublicKey = secretKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue(pGPPublicKey, "secretKey.publicKey");
        this(secretKey, pGPPublicKey);
    }

    public KeyInfo(@NotNull PGPPublicKey publicKey) {
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        this(null, publicKey);
    }

    @NotNull
    public final String getCurveName() {
        return PGPPublicKeyExtensionsKt.getCurveName(this.publicKey);
    }

    @Deprecated(message="Deprecated in favor of calling getCurveName() on the PGPPublicKey itself.", replaceWith=@ReplaceWith(expression="publicKey.getCurveName()", imports={}))
    public static /* synthetic */ void getCurveName$annotations() {
    }

    public final boolean isEncrypted() {
        PGPSecretKey pGPSecretKey = this.secretKey;
        return pGPSecretKey != null ? PGPSecretKeyExtensionsKt.isEncrypted(pGPSecretKey) : false;
    }

    @Deprecated(message="Deprecated in favor of calling isEncrypted() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.isEncrypted()", imports={}))
    public static /* synthetic */ void isEncrypted$annotations() {
    }

    public final boolean isDecrypted() {
        PGPSecretKey pGPSecretKey = this.secretKey;
        return pGPSecretKey != null ? PGPSecretKeyExtensionsKt.isDecrypted(pGPSecretKey) : true;
    }

    @Deprecated(message="Deprecated in favor of calling isDecrypted() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.isDecrypted()", imports={}))
    public static /* synthetic */ void isDecrypted$annotations() {
    }

    @JvmName(name="hasDummyS2K")
    public final boolean hasDummyS2K() {
        PGPSecretKey pGPSecretKey = this.secretKey;
        return pGPSecretKey != null ? PGPSecretKeyExtensionsKt.hasDummyS2K(pGPSecretKey) : false;
    }

    @Deprecated(message="Deprecated in favor of calling hasDummyS2K() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.hasDummyS2K()", imports={}))
    public static /* synthetic */ void hasDummyS2K$annotations() {
    }

    @JvmStatic
    @Deprecated(message="Deprecated in favor of calling isEncrypted() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.isEncrypted()", imports={}))
    public static final boolean isEncrypted(@Nullable PGPSecretKey secretKey) {
        return Companion.isEncrypted(secretKey);
    }

    @JvmStatic
    @Deprecated(message="Deprecated in favor of calling isDecrypted() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.isDecrypted()", imports={}))
    public static final boolean isDecrypted(@Nullable PGPSecretKey secretKey) {
        return Companion.isDecrypted(secretKey);
    }

    @JvmStatic
    @Deprecated(message="Deprecated in favor of calling hasDummyS2K() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.hasDummyS2K()", imports={}))
    public static final boolean hasDummyS2K(@Nullable PGPSecretKey secretKey) {
        return Companion.hasDummyS2K(secretKey);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/key/info/KeyInfo$Companion;", "", "()V", "hasDummyS2K", "", "secretKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "isDecrypted", "isEncrypted", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Deprecated(message="Deprecated in favor of calling isEncrypted() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.isEncrypted()", imports={}))
        public final boolean isEncrypted(@Nullable PGPSecretKey secretKey) {
            return PGPSecretKeyExtensionsKt.isEncrypted(secretKey);
        }

        @JvmStatic
        @Deprecated(message="Deprecated in favor of calling isDecrypted() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.isDecrypted()", imports={}))
        public final boolean isDecrypted(@Nullable PGPSecretKey secretKey) {
            return PGPSecretKeyExtensionsKt.isDecrypted(secretKey);
        }

        @JvmStatic
        @Deprecated(message="Deprecated in favor of calling hasDummyS2K() on the PGPSecretKey itself.", replaceWith=@ReplaceWith(expression="secretKey.hasDummyS2K()", imports={}))
        public final boolean hasDummyS2K(@Nullable PGPSecretKey secretKey) {
            return PGPSecretKeyExtensionsKt.hasDummyS2K(secretKey);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

