/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import openpgp.LongExtensionsKt;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0011\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0005B-\b\u0016\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0019\u0010\u001f\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u00020\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u0010%\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\tR\u001c\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/pgpainless/key/protection/CachingSecretKeyRingProtector;", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;", "()V", "missingPassphraseCallback", "(Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;)V", "passphrases", "", "", "Lorg/pgpainless/util/Passphrase;", "protectionSettings", "Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "(Ljava/util/Map;Lorg/pgpainless/key/protection/KeyRingProtectionSettings;Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;)V", "cache", "", "protector", "provider", "addPassphrase", "keyId", "passphrase", "keyRing", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "forgetPassphrase", "getDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "getEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "getPassphraseFor", "(Ljava/lang/Long;)Lorg/pgpainless/util/Passphrase;", "hasPassphrase", "", "(Ljava/lang/Long;)Z", "hasPassphraseFor", "replacePassphrase", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nCachingSecretKeyRingProtector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingSecretKeyRingProtector.kt\norg/pgpainless/key/protection/CachingSecretKeyRingProtector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,168:1\n1#2:169\n32#3,2:170\n32#3,2:172\n32#3,2:174\n32#3,2:176\n*S KotlinDebug\n*F\n+ 1 CachingSecretKeyRingProtector.kt\norg/pgpainless/key/protection/CachingSecretKeyRingProtector\n*L\n93#1:170,2\n101#1:172,2\n111#1:174,2\n145#1:176,2\n*E\n"})
public final class CachingSecretKeyRingProtector
implements SecretKeyRingProtector,
SecretKeyPassphraseProvider {
    @NotNull
    private final Map<Long, Passphrase> cache;
    @NotNull
    private final SecretKeyRingProtector protector;
    @Nullable
    private final SecretKeyPassphraseProvider provider;

    public CachingSecretKeyRingProtector() {
        this(null);
    }

    public CachingSecretKeyRingProtector(@Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
        this(MapsKt.emptyMap(), KeyRingProtectionSettings.Companion.secureDefaultSettings(), missingPassphraseCallback);
    }

    public CachingSecretKeyRingProtector(@NotNull Map<Long, Passphrase> passphrases, @NotNull KeyRingProtectionSettings protectionSettings, @Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
        Intrinsics.checkNotNullParameter(passphrases, "passphrases");
        Intrinsics.checkNotNullParameter(protectionSettings, "protectionSettings");
        this.cache = MapsKt.toMutableMap(passphrases);
        this.protector = new PasswordBasedSecretKeyRingProtector(protectionSettings, this);
        this.provider = missingPassphraseCallback;
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(long keyId, @NotNull Passphrase passphrase) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        CachingSecretKeyRingProtector $this$addPassphrase_u24lambda_u241 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        if (!(!$this$addPassphrase_u24lambda_u241.cache.containsKey(keyId))) {
            boolean bl2 = false;
            String string = "The cache already holds a passphrase for ID " + LongExtensionsKt.openPgpKeyId(keyId) + ".\nIf you want to replace this passphrase, use replacePassphrase(Long, Passphrase) instead.";
            throw new IllegalArgumentException(string.toString());
        }
        Long l = keyId;
        $this$addPassphrase_u24lambda_u241.cache.put(l, passphrase);
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector replacePassphrase(long keyId, @NotNull Passphrase passphrase) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        CachingSecretKeyRingProtector $this$replacePassphrase_u24lambda_u242 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        Long l = keyId;
        $this$replacePassphrase_u24lambda_u242.cache.put(l, passphrase);
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull PGPKeyRing keyRing, @NotNull Passphrase passphrase) {
        PGPPublicKey it;
        PGPPublicKey element$iv;
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter(keyRing, "keyRing");
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        CachingSecretKeyRingProtector $this$addPassphrase_u24lambda_u246 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        Iterator<PGPPublicKey> iterator2 = keyRing.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue(iterator2, "keyRing.publicKeys");
        Iterator<PGPPublicKey> $this$forEach$iv = iterator2;
        boolean $i$f$forEach = false;
        Iterator<PGPPublicKey> iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            it = element$iv = iterator3.next();
            boolean bl2 = false;
            if (!$this$addPassphrase_u24lambda_u246.cache.containsKey(it.getKeyID())) continue;
            boolean bl3 = false;
            String string = "The cache already holds a passphrase for the key with ID " + LongExtensionsKt.openPgpKeyId(it.getKeyID()) + ".\nIf you want to replace the passphrase, use replacePassphrase(PGPKeyRing, Passphrase) instead.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterator<PGPPublicKey> iterator4 = keyRing.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue(iterator4, "keyRing.publicKeys");
        $this$forEach$iv = iterator4;
        $i$f$forEach = false;
        iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            it = element$iv = iterator3.next();
            boolean bl4 = false;
            $this$addPassphrase_u24lambda_u246.cache.put(it.getKeyID(), passphrase);
        }
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector replacePassphrase(@NotNull PGPKeyRing keyRing, @NotNull Passphrase passphrase) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter(keyRing, "keyRing");
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        CachingSecretKeyRingProtector $this$replacePassphrase_u24lambda_u248 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        Iterator<PGPPublicKey> iterator2 = keyRing.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue(iterator2, "keyRing.publicKeys");
        Iterator<PGPPublicKey> $this$forEach$iv = iterator2;
        boolean $i$f$forEach = false;
        Iterator<PGPPublicKey> iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            PGPPublicKey element$iv;
            PGPPublicKey it = element$iv = iterator3.next();
            boolean bl2 = false;
            $this$replacePassphrase_u24lambda_u248.cache.put(it.getKeyID(), passphrase);
        }
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull PGPPublicKey key2, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        return this.addPassphrase(key2.getKeyID(), passphrase);
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull OpenPgpFingerprint fingerprint, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter(fingerprint, "fingerprint");
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        return this.addPassphrase(fingerprint.getKeyId(), passphrase);
    }

    @NotNull
    public final CachingSecretKeyRingProtector forgetPassphrase(long keyId) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        block0: {
            CachingSecretKeyRingProtector $this$forgetPassphrase_u24lambda_u249 = cachingSecretKeyRingProtector = this;
            boolean bl = false;
            Passphrase passphrase = $this$forgetPassphrase_u24lambda_u249.cache.remove(keyId);
            if (passphrase == null) break block0;
            passphrase.clear();
        }
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector forgetPassphrase(@NotNull PGPKeyRing keyRing) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter(keyRing, "keyRing");
        CachingSecretKeyRingProtector $this$forgetPassphrase_u24lambda_u2411 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        Iterator<PGPPublicKey> iterator2 = keyRing.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue(iterator2, "keyRing.publicKeys");
        Iterator<PGPPublicKey> $this$forEach$iv = iterator2;
        boolean $i$f$forEach = false;
        Iterator<PGPPublicKey> iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            PGPPublicKey element$iv;
            PGPPublicKey it = element$iv = iterator3.next();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            $this$forgetPassphrase_u24lambda_u2411.forgetPassphrase(it);
        }
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector forgetPassphrase(@NotNull PGPPublicKey key2) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter(key2, "key");
        CachingSecretKeyRingProtector $this$forgetPassphrase_u24lambda_u2412 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        $this$forgetPassphrase_u24lambda_u2412.forgetPassphrase(key2.getKeyID());
        return cachingSecretKeyRingProtector;
    }

    @Override
    @Nullable
    public Passphrase getPassphraseFor(@Nullable Long keyId) {
        Object object;
        if (this.hasPassphrase(keyId)) {
            object = this.cache.get(keyId);
        } else {
            Object object2 = this.provider;
            if (object2 != null && (object2 = object2.getPassphraseFor(keyId)) != null) {
                Object object3;
                Object it = object3 = object2;
                boolean bl = false;
                this.cache.put(keyId, (Passphrase)it);
                object = object3;
            } else {
                object = null;
            }
        }
        return object;
    }

    @Override
    public boolean hasPassphrase(@Nullable Long keyId) {
        Passphrase passphrase = this.cache.get(keyId);
        return passphrase != null ? passphrase.isValid() : false;
    }

    @Override
    public boolean hasPassphraseFor(long keyId) {
        return this.hasPassphrase(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(long keyId) {
        return this.protector.getDecryptor(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(long keyId) {
        return this.protector.getEncryptor(keyId);
    }
}

