/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection.fixes;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.SecretKeyRingProtector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/key/protection/fixes/S2KUsageFix;", "", "()V", "Companion", "pgpainless-core"})
public final class S2KUsageFix {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(@NotNull PGPSecretKeyRing keys2, @NotNull SecretKeyRingProtector protector, boolean skipKeysWithMissingPassphrase) {
        return Companion.replaceUsageChecksumWithUsageSha1(keys2, protector, skipKeysWithMissingPassphrase);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(@NotNull PGPSecretKeyRing keys2, @NotNull SecretKeyRingProtector protector) {
        return Companion.replaceUsageChecksumWithUsageSha1(keys2, protector);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/pgpainless/key/protection/fixes/S2KUsageFix$Companion;", "", "()V", "replaceUsageChecksumWithUsageSha1", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "keys", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "skipKeysWithMissingPassphrase", "", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(@NotNull PGPSecretKeyRing keys2, @NotNull SecretKeyRingProtector protector, boolean skipKeysWithMissingPassphrase) {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(protector, "protector");
            PGPDigestCalculator digestCalculator = ImplementationFactory.Companion.getInstance().getPGPDigestCalculator(HashAlgorithm.SHA1);
            List keyList = new ArrayList();
            for (PGPSecretKey key2 : keys2) {
                if (key2.getS2KUsage() != 255) {
                    Intrinsics.checkNotNullExpressionValue(key2, "key");
                    keyList.add(key2);
                    continue;
                }
                long keyId = key2.getKeyID();
                PBESecretKeyEncryptor encryptor = protector.getEncryptor(keyId);
                if (encryptor == null) {
                    if (skipKeysWithMissingPassphrase) {
                        Intrinsics.checkNotNullExpressionValue(key2, "key");
                        keyList.add(key2);
                        continue;
                    }
                    throw new WrongPassphraseException("Missing passphrase for key with ID " + Long.toHexString(keyId));
                }
                Intrinsics.checkNotNullExpressionValue(key2, "key");
                PGPPrivateKey privateKey = PGPSecretKeyExtensionsKt.unlock(key2, protector);
                PGPSecretKey fixedKey = new PGPSecretKey(privateKey, key2.getPublicKey(), digestCalculator, key2.isMasterKey(), protector.getEncryptor(keyId));
                keyList.add(fixedKey);
            }
            return new PGPSecretKeyRing(keyList);
        }

        public static /* synthetic */ PGPSecretKeyRing replaceUsageChecksumWithUsageSha1$default(Companion companion, PGPSecretKeyRing pGPSecretKeyRing, SecretKeyRingProtector secretKeyRingProtector, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.replaceUsageChecksumWithUsageSha1(pGPSecretKeyRing, secretKeyRingProtector, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPSecretKeyRing replaceUsageChecksumWithUsageSha1(@NotNull PGPSecretKeyRing keys2, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter(keys2, "keys");
            Intrinsics.checkNotNullParameter(protector, "protector");
            return org.pgpainless.key.protection.fixes.S2KUsageFix$Companion.replaceUsageChecksumWithUsageSha1$default(this, keys2, protector, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

