/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPPublicKeyExtensionsKt;
import org.pgpainless.exception.KeyIntegrityException;
import org.pgpainless.implementation.ImplementationFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/key/util/PublicKeyParameterValidationUtil;", "", "()V", "Companion", "pgpainless-core"})
public final class PublicKeyParameterValidationUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void verifyPublicKeyParameterIntegrity(@NotNull PGPPrivateKey privateKey, @NotNull PGPPublicKey publicKey) throws KeyIntegrityException {
        Companion.verifyPublicKeyParameterIntegrity(privateKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyRSAKeyIntegrity(RSASecretBCPGKey secretKey, RSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        return PublicKeyParameterValidationUtil.Companion.verifyRSAKeyIntegrity(secretKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyEdDsaKeyIntegrity(EdSecretBCPGKey secretKey, EdDSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        return PublicKeyParameterValidationUtil.Companion.verifyEdDsaKeyIntegrity(secretKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyDsaKeyIntegrity(DSASecretBCPGKey privateKey, DSAPublicBCPGKey publicKey) throws KeyIntegrityException {
        return PublicKeyParameterValidationUtil.Companion.verifyDsaKeyIntegrity(privateKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyElGamalKeyIntegrity(ElGamalSecretBCPGKey secretKey, ElGamalPublicBCPGKey publicKey) throws KeyIntegrityException {
        return PublicKeyParameterValidationUtil.Companion.verifyElGamalKeyIntegrity(secretKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyCanSign(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
        return PublicKeyParameterValidationUtil.Companion.verifyCanSign(privateKey, publicKey);
    }

    @JvmStatic
    private static final boolean verifyCanDecrypt(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
        return PublicKeyParameterValidationUtil.Companion.verifyCanDecrypt(privateKey, publicKey);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\fH\u0003J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0010H\u0003J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0013H\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0018H\u0003\u00a8\u0006\u0019"}, d2={"Lorg/pgpainless/key/util/PublicKeyParameterValidationUtil$Companion;", "", "()V", "verifyCanDecrypt", "", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "verifyCanSign", "verifyDsaKeyIntegrity", "Lorg/bouncycastle/bcpg/DSASecretBCPGKey;", "Lorg/bouncycastle/bcpg/DSAPublicBCPGKey;", "verifyEdDsaKeyIntegrity", "secretKey", "Lorg/bouncycastle/bcpg/EdSecretBCPGKey;", "Lorg/bouncycastle/bcpg/EdDSAPublicBCPGKey;", "verifyElGamalKeyIntegrity", "Lorg/bouncycastle/bcpg/ElGamalSecretBCPGKey;", "Lorg/bouncycastle/bcpg/ElGamalPublicBCPGKey;", "verifyPublicKeyParameterIntegrity", "", "verifyRSAKeyIntegrity", "Lorg/bouncycastle/bcpg/RSASecretBCPGKey;", "Lorg/bouncycastle/bcpg/RSAPublicBCPGKey;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nPublicKeyParameterValidationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicKeyParameterValidationUtil.kt\norg/pgpainless/key/util/PublicKeyParameterValidationUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,287:1\n1#2:288\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void verifyPublicKeyParameterIntegrity(@NotNull PGPPrivateKey privateKey, @NotNull PGPPublicKey publicKey) throws KeyIntegrityException {
            Intrinsics.checkNotNullParameter(privateKey, "privateKey");
            Intrinsics.checkNotNullParameter(publicKey, "publicKey");
            PublicKeyAlgorithm algorithm = PGPPublicKeyExtensionsKt.getPublicKeyAlgorithm(publicKey);
            boolean valid = true;
            BCPGKey key2 = privateKey.getPrivateKeyDataPacket();
            BCPGKey bCPGKey = privateKey.getPrivateKeyDataPacket();
            if (bCPGKey instanceof RSASecretBCPGKey) {
                Intrinsics.checkNotNull(key2, "null cannot be cast to non-null type org.bouncycastle.bcpg.RSASecretBCPGKey");
                RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)key2;
                BCPGKey bCPGKey2 = publicKey.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull(bCPGKey2, "null cannot be cast to non-null type org.bouncycastle.bcpg.RSAPublicBCPGKey");
                valid = this.verifyRSAKeyIntegrity(rSASecretBCPGKey, (RSAPublicBCPGKey)bCPGKey2);
            } else if (bCPGKey instanceof EdSecretBCPGKey) {
                Intrinsics.checkNotNull(key2, "null cannot be cast to non-null type org.bouncycastle.bcpg.EdSecretBCPGKey");
                EdSecretBCPGKey edSecretBCPGKey = (EdSecretBCPGKey)key2;
                BCPGKey bCPGKey3 = publicKey.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull(bCPGKey3, "null cannot be cast to non-null type org.bouncycastle.bcpg.EdDSAPublicBCPGKey");
                valid = this.verifyEdDsaKeyIntegrity(edSecretBCPGKey, (EdDSAPublicBCPGKey)bCPGKey3);
            } else if (bCPGKey instanceof DSASecretBCPGKey) {
                Intrinsics.checkNotNull(key2, "null cannot be cast to non-null type org.bouncycastle.bcpg.DSASecretBCPGKey");
                DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)key2;
                BCPGKey bCPGKey4 = publicKey.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull(bCPGKey4, "null cannot be cast to non-null type org.bouncycastle.bcpg.DSAPublicBCPGKey");
                valid = this.verifyDsaKeyIntegrity(dSASecretBCPGKey, (DSAPublicBCPGKey)bCPGKey4);
            } else if (bCPGKey instanceof ElGamalSecretBCPGKey) {
                Intrinsics.checkNotNull(key2, "null cannot be cast to non-null type org.bouncycastle.bcpg.ElGamalSecretBCPGKey");
                ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)key2;
                BCPGKey bCPGKey5 = publicKey.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull(bCPGKey5, "null cannot be cast to non-null type org.bouncycastle.bcpg.ElGamalPublicBCPGKey");
                valid = this.verifyElGamalKeyIntegrity(elGamalSecretBCPGKey, (ElGamalPublicBCPGKey)bCPGKey5);
            }
            if (!valid) {
                throw new KeyIntegrityException();
            }
            if (algorithm.isSigningCapable()) {
                valid = this.verifyCanSign(privateKey, publicKey);
            }
            if (algorithm.isEncryptionCapable()) {
                valid &= this.verifyCanDecrypt(privateKey, publicKey);
            }
            if (!valid) {
                throw new KeyIntegrityException();
            }
        }

        @JvmStatic
        private final boolean verifyRSAKeyIntegrity(RSASecretBCPGKey secretKey, RSAPublicBCPGKey publicKey) throws KeyIntegrityException {
            return publicKey.getModulus().equals(secretKey.getPrimeP().multiply(secretKey.getPrimeQ()));
        }

        @JvmStatic
        private final boolean verifyEdDsaKeyIntegrity(EdSecretBCPGKey secretKey, EdDSAPublicBCPGKey publicKey) throws KeyIntegrityException {
            return true;
        }

        @JvmStatic
        private final boolean verifyDsaKeyIntegrity(DSASecretBCPGKey privateKey, DSAPublicBCPGKey publicKey) throws KeyIntegrityException {
            boolean gInBounds;
            boolean qLarge;
            int certainty = 40;
            BigInteger pG = publicKey.getG();
            BigInteger pP = publicKey.getP();
            BigInteger pQ = publicKey.getQ();
            BigInteger pY = publicKey.getY();
            BigInteger sX = privateKey.getX();
            boolean pPrime = pP.isProbablePrime(certainty);
            if (!pPrime) {
                return false;
            }
            boolean qPrime = pQ.isProbablePrime(certainty);
            if (!qPrime) {
                return false;
            }
            boolean bl = qLarge = pQ.bitLength() > 160;
            if (!qLarge) {
                return false;
            }
            boolean qDividesPminus1 = Intrinsics.areEqual(pP.subtract(BigInteger.ONE).mod(pQ), BigInteger.ZERO);
            if (!qDividesPminus1) {
                return false;
            }
            boolean bl2 = gInBounds = Intrinsics.areEqual(BigInteger.ONE.max(pG), pG) && Intrinsics.areEqual(pG.max(pP), pP);
            if (!gInBounds) {
                return false;
            }
            boolean gPowXModPEquals1 = Intrinsics.areEqual(pG.modPow(pQ, pP), BigInteger.ONE);
            if (!gPowXModPEquals1) {
                return false;
            }
            return Intrinsics.areEqual(pY, pG.modPow(sX, pP));
        }

        @JvmStatic
        private final boolean verifyElGamalKeyIntegrity(ElGamalSecretBCPGKey secretKey, ElGamalPublicBCPGKey publicKey) throws KeyIntegrityException {
            BigInteger p = publicKey.getP();
            BigInteger g = publicKey.getG();
            BigInteger y = publicKey.getY();
            BigInteger one = BigInteger.ONE;
            if (Intrinsics.areEqual(g.min(one), g) || Intrinsics.areEqual(g.max(p), g)) {
                return false;
            }
            if (p.bitLength() < 1023) {
                return false;
            }
            if (!Intrinsics.areEqual(g.modPow(p.subtract(one), p), one)) {
                return false;
            }
            BigInteger res = g;
            int threshold = 262144;
            for (int i = 1; i < threshold; ++i) {
                if (!Intrinsics.areEqual(res = res.multiply(g).mod(p), one)) continue;
                return false;
            }
            SecureRandom random = new SecureRandom();
            BigInteger x = secretKey.getX();
            BigInteger r = new BigInteger(p.bitLength(), random);
            BigInteger rqx = p.subtract(one).multiply(r).add(x);
            return Intrinsics.areEqual(y, g.modPow(rqx, p));
        }

        @JvmStatic
        private final boolean verifyCanSign(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
            boolean bl;
            byte[] byArray;
            byte[] it = byArray = new byte[512];
            boolean bl2 = false;
            new SecureRandom().nextBytes(it);
            byte[] data2 = byArray;
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(ImplementationFactory.Companion.getInstance().getPGPContentSignerBuilder(PublicKeyAlgorithm.Companion.requireFromId(publicKey.getAlgorithm()), HashAlgorithm.SHA256));
            try {
                PGPDefaultSignatureGenerator pGPDefaultSignatureGenerator = signatureGenerator;
                PGPSignatureGenerator $this$verifyCanSign_u24lambda_u241 = pGPDefaultSignatureGenerator;
                boolean bl3 = false;
                $this$verifyCanSign_u24lambda_u241.init(SignatureType.TIMESTAMP.getCode(), privateKey);
                $this$verifyCanSign_u24lambda_u241.update(data2);
                PGPDefaultSignatureGenerator $this$verifyCanSign_u24lambda_u242 = pGPDefaultSignatureGenerator = ((PGPSignatureGenerator)pGPDefaultSignatureGenerator).generate();
                boolean bl4 = false;
                ((PGPSignature)$this$verifyCanSign_u24lambda_u242).init(ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider(), publicKey);
                ((PGPSignature)$this$verifyCanSign_u24lambda_u242).update(data2);
                bl = ((PGPSignature)pGPDefaultSignatureGenerator).verify();
            }
            catch (PGPException e) {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        private final boolean verifyCanDecrypt(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
            byte[] byArray = new byte[1024];
            Object it = byArray;
            boolean bl = false;
            new SecureRandom().nextBytes((byte[])it);
            byte[] data2 = byArray;
            Object $this$verifyCanDecrypt_u24lambda_u244 = it = (Object)new PGPEncryptedDataGenerator(ImplementationFactory.Companion.getInstance().getPGPDataEncryptorBuilder(SymmetricKeyAlgorithm.AES_256));
            boolean bl2 = false;
            ((PGPEncryptedDataGenerator)$this$verifyCanDecrypt_u24lambda_u244).addMethod(ImplementationFactory.Companion.getInstance().getPublicKeyKeyEncryptionMethodGenerator(publicKey));
            Object encryptedDataGenerator = it;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                OutputStream outputStream = ((PGPEncryptedDataGenerator)encryptedDataGenerator).open((OutputStream)out, new byte[1024]);
                outputStream.write(data2);
                ((PGPEncryptedDataGenerator)encryptedDataGenerator).close();
                PGPEncryptedDataList encryptedDataList = new PGPEncryptedDataList(out.toByteArray());
                PublicKeyDataDecryptorFactory decryptorFactory = ImplementationFactory.Companion.getInstance().getPublicKeyDataDecryptorFactory(privateKey);
                PGPEncryptedData pGPEncryptedData = encryptedDataList.getEncryptedDataObjects().next();
                Intrinsics.checkNotNull(pGPEncryptedData, "null cannot be cast to non-null type org.bouncycastle.openpgp.PGPPublicKeyEncryptedData");
                PGPPublicKeyEncryptedData encryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedData;
                InputStream decrypted = encryptedData.getDataStream(decryptorFactory);
                out = new ByteArrayOutputStream();
                Streams.pipeAll(decrypted, out);
                decrypted.close();
            }
            catch (IOException e) {
                return false;
            }
            catch (PGPException e) {
                return false;
            }
            return Arrays.constantTimeAreEqual(data2, out.toByteArray());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

