/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/pgpainless/signature/builder/SelfSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "signatureType", "Lorg/pgpainless/algorithm/SignatureType;", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "primaryKey", "primaryKeyProtector", "oldCertification", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets$Callback;", "build", "userId", "", "userAttributes", "Lorg/bouncycastle/openpgp/PGPUserAttributeSubpacketVector;", "pgpainless-core"})
public final class SelfSignatureBuilder
extends AbstractSignatureBuilder<SelfSignatureBuilder> {
    @NotNull
    private final SelfSignatureSubpackets hashedSubpackets;
    @NotNull
    private final SelfSignatureSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return SelfSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public SelfSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter(protector, "protector");
        super(SignatureType.GENERIC_CERTIFICATION, signingKey, protector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public SelfSignatureBuilder(@NotNull SignatureType signatureType, @NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signatureType, "signatureType");
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter(protector, "protector");
        super(signatureType, signingKey, protector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public SelfSignatureBuilder(@NotNull PGPSecretKey primaryKey, @NotNull SecretKeyRingProtector primaryKeyProtector, @NotNull PGPSignature oldCertification) throws PGPException {
        Intrinsics.checkNotNullParameter(primaryKey, "primaryKey");
        Intrinsics.checkNotNullParameter(primaryKeyProtector, "primaryKeyProtector");
        Intrinsics.checkNotNullParameter(oldCertification, "oldCertification");
        super(primaryKey, primaryKeyProtector, oldCertification);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    @NotNull
    public final SelfSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final SelfSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final SelfSignatureBuilder applyCallback(@Nullable SelfSignatureSubpackets.Callback callback2) {
        SelfSignatureBuilder selfSignatureBuilder;
        block0: {
            SelfSignatureBuilder $this$applyCallback_u24lambda_u242 = selfSignatureBuilder = this;
            boolean bl = false;
            SelfSignatureSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            SelfSignatureSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.unhashedSubpackets);
        }
        return selfSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull CharSequence userId) throws PGPException {
        Intrinsics.checkNotNullParameter(userId, "userId");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(((Object)userId).toString(), this.getPublicSigningKey());
        Intrinsics.checkNotNullExpressionValue(pGPSignature, "buildAndInitSignatureGen\u2026ring(), publicSigningKey)");
        return pGPSignature;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPUserAttributeSubpacketVector userAttributes) throws PGPException {
        Intrinsics.checkNotNullParameter(userAttributes, "userAttributes");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(userAttributes, this.getPublicSigningKey());
        Intrinsics.checkNotNullExpressionValue(pGPSignature, "buildAndInitSignatureGen\u2026ibutes, publicSigningKey)");
        return pGPSignature;
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.GENERIC_CERTIFICATION, SignatureType.NO_CERTIFICATION, SignatureType.CASUAL_CERTIFICATION, SignatureType.POSITIVE_CERTIFICATION};
        return CollectionsKt.listOf(signatureTypeArray).contains((Object)it);
    }
}

