/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/pgpainless/signature/builder/SubkeyBindingSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/algorithm/HashAlgorithm;)V", "oldSubkeyBinding", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "Lorg/pgpainless/algorithm/SignatureType;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets$Callback;", "build", "subkey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "pgpainless-core"})
public final class SubkeyBindingSignatureBuilder
extends AbstractSignatureBuilder<SubkeyBindingSignatureBuilder> {
    @NotNull
    private final SelfSignatureSubpackets hashedSubpackets;
    @NotNull
    private final SelfSignatureSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return SubkeyBindingSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public SubkeyBindingSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter(protector, "protector");
        super(SignatureType.SUBKEY_BINDING, signingKey, protector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public SubkeyBindingSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull HashAlgorithm hashAlgorithm) throws PGPException {
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter(protector, "protector");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithm, "hashAlgorithm");
        PGPPublicKey pGPPublicKey = signingKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue(pGPPublicKey, "signingKey.publicKey");
        super(SignatureType.SUBKEY_BINDING, signingKey, protector, hashAlgorithm, SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey), SignatureSubpackets.Companion.createEmptySubpackets());
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    /*
     * WARNING - void declaration
     */
    public SubkeyBindingSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPSignature oldSubkeyBinding) throws PGPException {
        void it;
        PGPSignature pGPSignature;
        Intrinsics.checkNotNullParameter(signingKey, "signingKey");
        Intrinsics.checkNotNullParameter(protector, "protector");
        Intrinsics.checkNotNullParameter(oldSubkeyBinding, "oldSubkeyBinding");
        PGPSignature pGPSignature2 = pGPSignature = oldSubkeyBinding;
        SecretKeyRingProtector secretKeyRingProtector = protector;
        PGPSecretKey pGPSecretKey = signingKey;
        SubkeyBindingSignatureBuilder subkeyBindingSignatureBuilder = this;
        boolean bl = false;
        if (!(it.getSignatureType() == SignatureType.SUBKEY_BINDING.getCode())) {
            boolean bl2 = false;
            String string = "Invalid signature type.";
            throw new IllegalArgumentException(string.toString());
        }
        Unit unit = Unit.INSTANCE;
        super(pGPSecretKey, secretKeyRingProtector, pGPSignature);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    @NotNull
    public final SelfSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final SelfSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final SubkeyBindingSignatureBuilder applyCallback(@Nullable SelfSignatureSubpackets.Callback callback2) {
        SubkeyBindingSignatureBuilder subkeyBindingSignatureBuilder;
        block0: {
            SubkeyBindingSignatureBuilder $this$applyCallback_u24lambda_u244 = subkeyBindingSignatureBuilder = this;
            boolean bl = false;
            SelfSignatureSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            SelfSignatureSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u244.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u244.unhashedSubpackets);
        }
        return subkeyBindingSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKey subkey) throws PGPException {
        Intrinsics.checkNotNullParameter(subkey, "subkey");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(this.getPublicSigningKey(), subkey);
        Intrinsics.checkNotNullExpressionValue(pGPSignature, "buildAndInitSignatureGen\u2026publicSigningKey, subkey)");
        return pGPSignature;
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        return it == SignatureType.SUBKEY_BINDING;
    }
}

