/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.subpackets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import openpgp.DateExtensionsKt;
import openpgp.LongExtensionsKt;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.RegularExpression;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureSubpacket;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.OpenPgpV5Fingerprint;
import org.pgpainless.key.OpenPgpV6Fingerprint;
import org.pgpainless.key.generation.type.KeyType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/signature/subpackets/SignatureSubpacketsUtil;", "", "()V", "Companion", "pgpainless-core"})
public final class SignatureSubpacketsUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final IssuerFingerprint getIssuerFingerprint(@NotNull PGPSignature signature) {
        return Companion.getIssuerFingerprint(signature);
    }

    @JvmStatic
    @Nullable
    public static final OpenPgpFingerprint getIssuerFingerprintAsOpenPgpFingerprint(@NotNull PGPSignature signature) {
        return Companion.getIssuerFingerprintAsOpenPgpFingerprint(signature);
    }

    @JvmStatic
    @Nullable
    public static final IssuerKeyID getIssuerKeyId(@NotNull PGPSignature signature) {
        return Companion.getIssuerKeyId(signature);
    }

    @JvmStatic
    @Nullable
    public static final Long getIssuerKeyIdAsLong(@NotNull PGPSignature signature) {
        return Companion.getIssuerKeyIdAsLong(signature);
    }

    @JvmStatic
    @Nullable
    public static final RevocationReason getRevocationReason(@NotNull PGPSignature signature) {
        return Companion.getRevocationReason(signature);
    }

    @JvmStatic
    @Nullable
    public static final SignatureCreationTime getSignatureCreationTime(@NotNull PGPSignature signature) {
        return Companion.getSignatureCreationTime(signature);
    }

    @JvmStatic
    @Nullable
    public static final SignatureExpirationTime getSignatureExpirationTime(@NotNull PGPSignature signature) {
        return Companion.getSignatureExpirationTime(signature);
    }

    @JvmStatic
    @Nullable
    public static final Date getSignatureExpirationTimeAsDate(@NotNull PGPSignature signature) {
        return Companion.getSignatureExpirationTimeAsDate(signature);
    }

    @JvmStatic
    @Nullable
    public static final KeyExpirationTime getKeyExpirationTime(@NotNull PGPSignature signature) {
        return Companion.getKeyExpirationTime(signature);
    }

    @JvmStatic
    @Nullable
    public static final Date getKeyExpirationTimeAsDate(@NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey) {
        return Companion.getKeyExpirationTimeAsDate(signature, signingKey);
    }

    @JvmStatic
    public static final long getKeyLifetimeInSeconds(@NotNull Date creationTime, @Nullable Date expirationTime) {
        return Companion.getKeyLifetimeInSeconds(creationTime, expirationTime);
    }

    @JvmStatic
    @Nullable
    public static final Revocable getRevocable(@NotNull PGPSignature signature) {
        return Companion.getRevocable(signature);
    }

    @JvmStatic
    @Nullable
    public static final PreferredAlgorithms getPreferredSymmetricAlgorithms(@NotNull PGPSignature signature) {
        return Companion.getPreferredSymmetricAlgorithms(signature);
    }

    @JvmStatic
    @NotNull
    public static final Set<SymmetricKeyAlgorithm> parsePreferredSymmetricKeyAlgorithms(@NotNull PGPSignature signature) {
        return Companion.parsePreferredSymmetricKeyAlgorithms(signature);
    }

    @JvmStatic
    @Nullable
    public static final PreferredAlgorithms getPreferredHashAlgorithms(@NotNull PGPSignature signature) {
        return Companion.getPreferredHashAlgorithms(signature);
    }

    @JvmStatic
    @NotNull
    public static final Set<HashAlgorithm> parsePreferredHashAlgorithms(@NotNull PGPSignature signature) {
        return Companion.parsePreferredHashAlgorithms(signature);
    }

    @JvmStatic
    @Nullable
    public static final PreferredAlgorithms getPreferredCompressionAlgorithms(@NotNull PGPSignature signature) {
        return Companion.getPreferredCompressionAlgorithms(signature);
    }

    @JvmStatic
    @NotNull
    public static final Set<CompressionAlgorithm> parsePreferredCompressionAlgorithms(@NotNull PGPSignature signature) {
        return Companion.parsePreferredCompressionAlgorithms(signature);
    }

    @JvmStatic
    @Nullable
    public static final PreferredAEADCiphersuites getPreferredAeadAlgorithms(@NotNull PGPSignature signature) {
        return Companion.getPreferredAeadAlgorithms(signature);
    }

    @JvmStatic
    @Nullable
    public static final PrimaryUserID getPrimaryUserId(@NotNull PGPSignature signature) {
        return Companion.getPrimaryUserId(signature);
    }

    @JvmStatic
    @Nullable
    public static final KeyFlags getKeyFlags(@NotNull PGPSignature signature) {
        return Companion.getKeyFlags(signature);
    }

    @JvmStatic
    @Nullable
    public static final List<KeyFlag> parseKeyFlags(@Nullable PGPSignature signature) {
        return Companion.parseKeyFlags(signature);
    }

    @JvmStatic
    @Nullable
    public static final Features getFeatures(@NotNull PGPSignature signature) {
        return Companion.getFeatures(signature);
    }

    @JvmStatic
    @Nullable
    public static final Set<Feature> parseFeatures(@NotNull PGPSignature signature) {
        return Companion.parseFeatures(signature);
    }

    @JvmStatic
    @Nullable
    public static final SignatureTarget getSignatureTarget(@NotNull PGPSignature signature) {
        return Companion.getSignatureTarget(signature);
    }

    @JvmStatic
    @NotNull
    public static final List<NotationData> getHashedNotationData(@NotNull PGPSignature signature) {
        return Companion.getHashedNotationData(signature);
    }

    @JvmStatic
    @NotNull
    public static final List<NotationData> getHashedNotationData(@NotNull PGPSignature signature, @NotNull String notationName) {
        return Companion.getHashedNotationData(signature, notationName);
    }

    @JvmStatic
    @NotNull
    public static final List<NotationData> getUnhashedNotationData(@NotNull PGPSignature signature) {
        return Companion.getUnhashedNotationData(signature);
    }

    @JvmStatic
    @NotNull
    public static final List<NotationData> getUnhashedNotationData(@NotNull PGPSignature signature, @NotNull String notationName) {
        return Companion.getUnhashedNotationData(signature, notationName);
    }

    @JvmStatic
    @Nullable
    public static final RevocationKey getRevocationKey(@NotNull PGPSignature signature) {
        return Companion.getRevocationKey(signature);
    }

    @JvmStatic
    @Nullable
    public static final SignerUserID getSignerUserID(@NotNull PGPSignature signature) {
        return Companion.getSignerUserID(signature);
    }

    @JvmStatic
    @NotNull
    public static final List<IntendedRecipientFingerprint> getIntendedRecipientFingerprints(@NotNull PGPSignature signature) {
        return Companion.getIntendedRecipientFingerprints(signature);
    }

    @JvmStatic
    @NotNull
    public static final PGPSignatureList getEmbeddedSignature(@NotNull PGPSignature signature) {
        return Companion.getEmbeddedSignature(signature);
    }

    @JvmStatic
    @Nullable
    public static final Exportable getExportableCertification(@NotNull PGPSignature signature) {
        return Companion.getExportableCertification(signature);
    }

    @JvmStatic
    public static final boolean isExportable(@NotNull PGPSignature signature) {
        return Companion.isExportable(signature);
    }

    @JvmStatic
    @Nullable
    public static final TrustSignature getTrustSignature(@NotNull PGPSignature signature) {
        return Companion.getTrustSignature(signature);
    }

    @JvmStatic
    public static final int getTrustDepthOr(@NotNull PGPSignature signature, int defaultDepth) {
        return Companion.getTrustDepthOr(signature, defaultDepth);
    }

    @JvmStatic
    public static final int getTrustAmountOr(@NotNull PGPSignature signature, int defaultAmount) {
        return Companion.getTrustAmountOr(signature, defaultAmount);
    }

    @JvmStatic
    @NotNull
    public static final List<RegularExpression> getRegularExpressions(@NotNull PGPSignature signature) {
        return Companion.getRegularExpressions(signature);
    }

    @JvmStatic
    @Nullable
    public static final <P extends org.bouncycastle.bcpg.SignatureSubpacket> P hashedOrUnhashed(@NotNull PGPSignature signature, @NotNull SignatureSubpacket type) {
        return Companion.hashedOrUnhashed(signature, type);
    }

    @JvmStatic
    @Nullable
    public static final <P extends org.bouncycastle.bcpg.SignatureSubpacket> P hashed(@NotNull PGPSignature signature, @NotNull SignatureSubpacket type) {
        return Companion.hashed(signature, type);
    }

    @JvmStatic
    @Nullable
    public static final <P extends org.bouncycastle.bcpg.SignatureSubpacket> P unhashed(@NotNull PGPSignature signature, @NotNull SignatureSubpacket type) {
        return Companion.unhashed(signature, type);
    }

    @JvmStatic
    @Nullable
    public static final <P extends org.bouncycastle.bcpg.SignatureSubpacket> P getSignatureSubpacket(@Nullable PGPSignatureSubpacketVector vector, @NotNull SignatureSubpacket type) {
        return Companion.getSignatureSubpacket(vector, type);
    }

    @JvmStatic
    public static final void assureKeyCanCarryFlags(@NotNull KeyType type, KeyFlag ... flags) {
        Companion.assureKeyCanCarryFlags(type, flags);
    }

    @JvmStatic
    public static final void assureKeyCanCarryFlags(@NotNull PublicKeyAlgorithm algorithm, KeyFlag ... flags) {
        Companion.assureKeyCanCarryFlags(algorithm, flags);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0007\u00a2\u0006\u0002\u0010\nJ)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0017\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010%J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+H\u0007J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020)2\b\u00100\u001a\u0004\u0018\u00010)H\u0007J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u00105\u001a\u0004\u0018\u0001042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u00106\u001a\u0004\u0018\u0001042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010E\u001a\u0004\u0018\u00010)2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J+\u0010F\u001a\u0004\u0018\u0001HG\"\b\b\u0000\u0010G*\u00020H2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010\u000b\u001a\u00020KH\u0007\u00a2\u0006\u0002\u0010LJ\u0012\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010Q\u001a\u00020R2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010S\u001a\u00020RH\u0007J\u0018\u0010T\u001a\u00020R2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010U\u001a\u00020RH\u0007J\u0012\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J)\u0010Y\u001a\u0004\u0018\u0001HG\"\b\b\u0000\u0010G*\u00020H2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020KH\u0007\u00a2\u0006\u0002\u0010ZJ)\u0010[\u001a\u0004\u0018\u0001HG\"\b\b\u0000\u0010G*\u00020H2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020KH\u0007\u00a2\u0006\u0002\u0010ZJ\u0010\u0010\\\u001a\u00020]2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010^\u001a\n\u0012\u0004\u0012\u00020`\u0018\u00010_2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010a\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00020c0_2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010d\u001a\b\u0012\u0004\u0012\u00020e0_2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020g0_2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J)\u0010h\u001a\u0004\u0018\u0001HG\"\b\b\u0000\u0010G*\u00020H2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020KH\u0007\u00a2\u0006\u0002\u0010Z\u00a8\u0006i"}, d2={"Lorg/pgpainless/signature/subpackets/SignatureSubpacketsUtil$Companion;", "", "()V", "assureKeyCanCarryFlags", "", "algorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "flags", "", "Lorg/pgpainless/algorithm/KeyFlag;", "(Lorg/pgpainless/algorithm/PublicKeyAlgorithm;[Lorg/pgpainless/algorithm/KeyFlag;)V", "type", "Lorg/pgpainless/key/generation/type/KeyType;", "(Lorg/pgpainless/key/generation/type/KeyType;[Lorg/pgpainless/algorithm/KeyFlag;)V", "getEmbeddedSignature", "Lorg/bouncycastle/openpgp/PGPSignatureList;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "getExportableCertification", "Lorg/bouncycastle/bcpg/sig/Exportable;", "getFeatures", "Lorg/bouncycastle/bcpg/sig/Features;", "getHashedNotationData", "", "Lorg/bouncycastle/bcpg/sig/NotationData;", "notationName", "", "getIntendedRecipientFingerprints", "Lorg/bouncycastle/bcpg/sig/IntendedRecipientFingerprint;", "getIssuerFingerprint", "Lorg/bouncycastle/bcpg/sig/IssuerFingerprint;", "getIssuerFingerprintAsOpenPgpFingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "getIssuerKeyId", "Lorg/bouncycastle/bcpg/sig/IssuerKeyID;", "getIssuerKeyIdAsLong", "", "(Lorg/bouncycastle/openpgp/PGPSignature;)Ljava/lang/Long;", "getKeyExpirationTime", "Lorg/bouncycastle/bcpg/sig/KeyExpirationTime;", "getKeyExpirationTimeAsDate", "Ljava/util/Date;", "signingKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "getKeyFlags", "Lorg/bouncycastle/bcpg/sig/KeyFlags;", "getKeyLifetimeInSeconds", "creationTime", "expirationTime", "getPreferredAeadAlgorithms", "Lorg/bouncycastle/bcpg/sig/PreferredAEADCiphersuites;", "getPreferredCompressionAlgorithms", "Lorg/bouncycastle/bcpg/sig/PreferredAlgorithms;", "getPreferredHashAlgorithms", "getPreferredSymmetricAlgorithms", "getPrimaryUserId", "Lorg/bouncycastle/bcpg/sig/PrimaryUserID;", "getRegularExpressions", "Lorg/bouncycastle/bcpg/sig/RegularExpression;", "getRevocable", "Lorg/bouncycastle/bcpg/sig/Revocable;", "getRevocationKey", "Lorg/bouncycastle/bcpg/sig/RevocationKey;", "getRevocationReason", "Lorg/bouncycastle/bcpg/sig/RevocationReason;", "getSignatureCreationTime", "Lorg/bouncycastle/bcpg/sig/SignatureCreationTime;", "getSignatureExpirationTime", "Lorg/bouncycastle/bcpg/sig/SignatureExpirationTime;", "getSignatureExpirationTimeAsDate", "getSignatureSubpacket", "P", "Lorg/bouncycastle/bcpg/SignatureSubpacket;", "vector", "Lorg/bouncycastle/openpgp/PGPSignatureSubpacketVector;", "Lorg/pgpainless/algorithm/SignatureSubpacket;", "(Lorg/bouncycastle/openpgp/PGPSignatureSubpacketVector;Lorg/pgpainless/algorithm/SignatureSubpacket;)Lorg/bouncycastle/bcpg/SignatureSubpacket;", "getSignatureTarget", "Lorg/bouncycastle/bcpg/sig/SignatureTarget;", "getSignerUserID", "Lorg/bouncycastle/bcpg/sig/SignerUserID;", "getTrustAmountOr", "", "defaultAmount", "getTrustDepthOr", "defaultDepth", "getTrustSignature", "Lorg/bouncycastle/bcpg/sig/TrustSignature;", "getUnhashedNotationData", "hashed", "(Lorg/bouncycastle/openpgp/PGPSignature;Lorg/pgpainless/algorithm/SignatureSubpacket;)Lorg/bouncycastle/bcpg/SignatureSubpacket;", "hashedOrUnhashed", "isExportable", "", "parseFeatures", "", "Lorg/pgpainless/algorithm/Feature;", "parseKeyFlags", "parsePreferredCompressionAlgorithms", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "parsePreferredHashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "parsePreferredSymmetricKeyAlgorithms", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "unhashed", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nSignatureSubpacketsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureSubpacketsUtil.kt\norg/pgpainless/signature/subpackets/SignatureSubpacketsUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,597:1\n1#2:598\n11365#3:599\n11700#3,3:600\n11365#3:603\n11700#3,3:604\n11365#3:607\n11700#3,3:608\n766#4:611\n857#4,2:612\n766#4:614\n857#4,2:615\n*S KotlinDebug\n*F\n+ 1 SignatureSubpacketsUtil.kt\norg/pgpainless/signature/subpackets/SignatureSubpacketsUtil$Companion\n*L\n208#1:599\n208#1:600,3\n236#1:603\n236#1:604,3\n267#1:607\n267#1:608,3\n362#1:611\n362#1:612,2\n384#1:614\n384#1:615,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final IssuerFingerprint getIssuerFingerprint(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (IssuerFingerprint)this.hashedOrUnhashed(signature, SignatureSubpacket.issuerFingerprint);
        }

        @JvmStatic
        @Nullable
        public final OpenPgpFingerprint getIssuerFingerprintAsOpenPgpFingerprint(@NotNull PGPSignature signature) {
            OpenPgpFingerprint openPgpFingerprint;
            Intrinsics.checkNotNullParameter(signature, "signature");
            IssuerFingerprint issuerFingerprint = this.getIssuerFingerprint(signature);
            if (issuerFingerprint == null) {
                return null;
            }
            IssuerFingerprint subpacket = issuerFingerprint;
            switch (subpacket.getKeyVersion()) {
                case 4: {
                    byte[] byArray = subpacket.getFingerprint();
                    Intrinsics.checkNotNullExpressionValue(byArray, "subpacket.fingerprint");
                    openPgpFingerprint = new OpenPgpV4Fingerprint(byArray);
                    break;
                }
                case 5: {
                    byte[] byArray = subpacket.getFingerprint();
                    Intrinsics.checkNotNullExpressionValue(byArray, "subpacket.fingerprint");
                    openPgpFingerprint = new OpenPgpV5Fingerprint(byArray);
                    break;
                }
                case 6: {
                    byte[] byArray = subpacket.getFingerprint();
                    Intrinsics.checkNotNullExpressionValue(byArray, "subpacket.fingerprint");
                    openPgpFingerprint = new OpenPgpV6Fingerprint(byArray);
                    break;
                }
                default: {
                    openPgpFingerprint = null;
                }
            }
            return openPgpFingerprint;
        }

        @JvmStatic
        @Nullable
        public final IssuerKeyID getIssuerKeyId(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (IssuerKeyID)this.hashedOrUnhashed(signature, SignatureSubpacket.issuerKeyId);
        }

        @JvmStatic
        @Nullable
        public final Long getIssuerKeyIdAsLong(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            IssuerKeyID issuerKeyID = this.getIssuerKeyId(signature);
            return issuerKeyID != null ? Long.valueOf(issuerKeyID.getKeyID()) : null;
        }

        @JvmStatic
        @Nullable
        public final RevocationReason getRevocationReason(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (RevocationReason)this.hashed(signature, SignatureSubpacket.revocationReason);
        }

        @JvmStatic
        @Nullable
        public final SignatureCreationTime getSignatureCreationTime(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return signature.getVersion() == 3 ? new SignatureCreationTime(false, signature.getCreationTime()) : (SignatureCreationTime)this.hashed(signature, SignatureSubpacket.signatureCreationTime);
        }

        @JvmStatic
        @Nullable
        public final SignatureExpirationTime getSignatureExpirationTime(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (SignatureExpirationTime)this.hashed(signature, SignatureSubpacket.signatureExpirationTime);
        }

        @JvmStatic
        @Nullable
        public final Date getSignatureExpirationTimeAsDate(@NotNull PGPSignature signature) {
            Date date;
            Intrinsics.checkNotNullParameter(signature, "signature");
            SignatureExpirationTime signatureExpirationTime = this.getSignatureExpirationTime(signature);
            if (signatureExpirationTime != null) {
                SignatureExpirationTime it = signatureExpirationTime;
                boolean bl = false;
                Date date2 = signature.getCreationTime();
                Intrinsics.checkNotNullExpressionValue(date2, "signature.creationTime");
                date = DateExtensionsKt.plusSeconds(date2, it.getTime());
            } else {
                date = null;
            }
            return date;
        }

        @JvmStatic
        @Nullable
        public final KeyExpirationTime getKeyExpirationTime(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (KeyExpirationTime)this.hashed(signature, SignatureSubpacket.keyExpirationTime);
        }

        @JvmStatic
        @Nullable
        public final Date getKeyExpirationTimeAsDate(@NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey) {
            Date date;
            Intrinsics.checkNotNullParameter(signature, "signature");
            Intrinsics.checkNotNullParameter(signingKey, "signingKey");
            if (!(signature.getKeyID() == signingKey.getKeyID())) {
                boolean $i$a$-require-SignatureSubpacketsUtil$Companion$getKeyExpirationTimeAsDate$22 = false;
                String $i$a$-require-SignatureSubpacketsUtil$Companion$getKeyExpirationTimeAsDate$22 = "Provided key (" + LongExtensionsKt.openPgpKeyId(signingKey.getKeyID()) + ") did not create the signature (" + LongExtensionsKt.openPgpKeyId(signature.getKeyID()) + ')';
                throw new IllegalArgumentException($i$a$-require-SignatureSubpacketsUtil$Companion$getKeyExpirationTimeAsDate$22.toString());
            }
            Unit $this$getKeyExpirationTimeAsDate_u24lambda_u243 = Unit.INSTANCE;
            boolean bl = false;
            KeyExpirationTime keyExpirationTime = Companion.getKeyExpirationTime(signature);
            if (keyExpirationTime != null) {
                KeyExpirationTime it = keyExpirationTime;
                boolean bl2 = false;
                Date date2 = signingKey.getCreationTime();
                Intrinsics.checkNotNullExpressionValue(date2, "signingKey.creationTime");
                date = DateExtensionsKt.plusSeconds(date2, it.getTime());
            } else {
                date = null;
            }
            return date;
        }

        @JvmStatic
        public final long getKeyLifetimeInSeconds(@NotNull Date creationTime, @Nullable Date expirationTime) {
            long l;
            Intrinsics.checkNotNullParameter(creationTime, "creationTime");
            Date date = expirationTime;
            if (date != null) {
                Date it = date;
                boolean bl = false;
                if (!(creationTime.compareTo(it) <= 0)) {
                    boolean $i$a$-require-SignatureSubpacketsUtil$Companion$getKeyLifetimeInSeconds$1$22 = false;
                    String $i$a$-require-SignatureSubpacketsUtil$Companion$getKeyLifetimeInSeconds$1$22 = "Key MUST NOT expire before being created.\n(creation: " + creationTime + ", expiration: " + it + ')';
                    throw new IllegalArgumentException($i$a$-require-SignatureSubpacketsUtil$Companion$getKeyLifetimeInSeconds$1$22.toString());
                }
                Unit $this$getKeyLifetimeInSeconds_u24lambda_u246_u24lambda_u245 = Unit.INSTANCE;
                boolean bl2 = false;
                l = (it.getTime() - creationTime.getTime()) / (long)1000;
            } else {
                l = 0L;
            }
            return l;
        }

        @JvmStatic
        @Nullable
        public final Revocable getRevocable(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (Revocable)this.hashed(signature, SignatureSubpacket.revocable);
        }

        @JvmStatic
        @Nullable
        public final PreferredAlgorithms getPreferredSymmetricAlgorithms(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (PreferredAlgorithms)this.hashed(signature, SignatureSubpacket.preferredSymmetricAlgorithms);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final Set<SymmetricKeyAlgorithm> parsePreferredSymmetricKeyAlgorithms(@NotNull PGPSignature signature) {
            Set<SymmetricKeyAlgorithm> set;
            int[] nArray;
            Intrinsics.checkNotNullParameter(signature, "signature");
            PreferredAlgorithms preferredAlgorithms = this.getPreferredSymmetricAlgorithms(signature);
            if (preferredAlgorithms != null && (nArray = preferredAlgorithms.getPreferences()) != null) {
                Set set2;
                void $this$mapTo$iv$iv;
                int[] nArray2 = nArray;
                boolean $i$f$map = false;
                int[] nArray3 = nArray2;
                Collection destination$iv$iv = new ArrayList(nArray2.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(SymmetricKeyAlgorithm.Companion.fromId((int)it));
                }
                List list = CollectionsKt.filterNotNull((List)destination$iv$iv);
                if (list != null && (set2 = CollectionsKt.toSet(list)) != null) {
                    set = set2;
                    return set;
                }
            }
            set = SetsKt.emptySet();
            return set;
        }

        @JvmStatic
        @Nullable
        public final PreferredAlgorithms getPreferredHashAlgorithms(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (PreferredAlgorithms)this.hashed(signature, SignatureSubpacket.preferredHashAlgorithms);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final Set<HashAlgorithm> parsePreferredHashAlgorithms(@NotNull PGPSignature signature) {
            Set<HashAlgorithm> set;
            int[] nArray;
            Intrinsics.checkNotNullParameter(signature, "signature");
            PreferredAlgorithms preferredAlgorithms = this.getPreferredHashAlgorithms(signature);
            if (preferredAlgorithms != null && (nArray = preferredAlgorithms.getPreferences()) != null) {
                Set set2;
                void $this$mapTo$iv$iv;
                int[] nArray2 = nArray;
                boolean $i$f$map = false;
                int[] nArray3 = nArray2;
                Collection destination$iv$iv = new ArrayList(nArray2.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(HashAlgorithm.Companion.fromId((int)it));
                }
                List list = CollectionsKt.filterNotNull((List)destination$iv$iv);
                if (list != null && (set2 = CollectionsKt.toSet(list)) != null) {
                    set = set2;
                    return set;
                }
            }
            set = SetsKt.emptySet();
            return set;
        }

        @JvmStatic
        @Nullable
        public final PreferredAlgorithms getPreferredCompressionAlgorithms(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (PreferredAlgorithms)this.hashed(signature, SignatureSubpacket.preferredCompressionAlgorithms);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final Set<CompressionAlgorithm> parsePreferredCompressionAlgorithms(@NotNull PGPSignature signature) {
            Set<CompressionAlgorithm> set;
            int[] nArray;
            Intrinsics.checkNotNullParameter(signature, "signature");
            PreferredAlgorithms preferredAlgorithms = this.getPreferredCompressionAlgorithms(signature);
            if (preferredAlgorithms != null && (nArray = preferredAlgorithms.getPreferences()) != null) {
                Set set2;
                void $this$mapTo$iv$iv;
                int[] nArray2 = nArray;
                boolean $i$f$map = false;
                int[] nArray3 = nArray2;
                Collection destination$iv$iv = new ArrayList(nArray2.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CompressionAlgorithm.Companion.fromId((int)it));
                }
                List list = CollectionsKt.filterNotNull((List)destination$iv$iv);
                if (list != null && (set2 = CollectionsKt.toSet(list)) != null) {
                    set = set2;
                    return set;
                }
            }
            set = SetsKt.emptySet();
            return set;
        }

        @JvmStatic
        @Nullable
        public final PreferredAEADCiphersuites getPreferredAeadAlgorithms(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (PreferredAEADCiphersuites)this.hashed(signature, SignatureSubpacket.preferredAEADAlgorithms);
        }

        @JvmStatic
        @Nullable
        public final PrimaryUserID getPrimaryUserId(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (PrimaryUserID)this.hashed(signature, SignatureSubpacket.primaryUserId);
        }

        @JvmStatic
        @Nullable
        public final KeyFlags getKeyFlags(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (KeyFlags)this.hashed(signature, SignatureSubpacket.keyFlags);
        }

        @JvmStatic
        @Nullable
        public final List<KeyFlag> parseKeyFlags(@Nullable PGPSignature signature) {
            List<KeyFlag> list;
            PGPSignature pGPSignature = signature;
            if (pGPSignature != null) {
                PGPSignature sig = pGPSignature;
                boolean bl = false;
                KeyFlags keyFlags = Companion.getKeyFlags(sig);
                if (keyFlags != null) {
                    KeyFlags it = keyFlags;
                    boolean bl2 = false;
                    list = KeyFlag.Companion.fromBitmask(it.getFlags());
                } else {
                    list = null;
                }
            } else {
                list = null;
            }
            return list;
        }

        @JvmStatic
        @Nullable
        public final Features getFeatures(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (Features)this.hashed(signature, SignatureSubpacket.features);
        }

        @JvmStatic
        @Nullable
        public final Set<Feature> parseFeatures(@NotNull PGPSignature signature) {
            Set set;
            Intrinsics.checkNotNullParameter(signature, "signature");
            Features features = this.getFeatures(signature);
            if (features != null) {
                Features it = features;
                boolean bl = false;
                set = CollectionsKt.toSet((Iterable)Feature.Companion.fromBitmask(it.getFeatures()));
            } else {
                set = null;
            }
            return set;
        }

        @JvmStatic
        @Nullable
        public final SignatureTarget getSignatureTarget(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (SignatureTarget)this.hashedOrUnhashed(signature, SignatureSubpacket.signatureTarget);
        }

        @JvmStatic
        @NotNull
        public final List<NotationData> getHashedNotationData(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            NotationData[] notationDataArray = signature.getHashedSubPackets().getNotationDataOccurrences();
            Intrinsics.checkNotNullExpressionValue(notationDataArray, "signature.hashedSubPackets.notationDataOccurrences");
            return ArraysKt.toList((Object[])notationDataArray);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<NotationData> getHashedNotationData(@NotNull PGPSignature signature, @NotNull String notationName) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(signature, "signature");
            Intrinsics.checkNotNullParameter(notationName, "notationName");
            Iterable $this$filter$iv = this.getHashedNotationData(signature);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                NotationData it = (NotationData)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getNotationName(), notationName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final List<NotationData> getUnhashedNotationData(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            NotationData[] notationDataArray = signature.getUnhashedSubPackets().getNotationDataOccurrences();
            Intrinsics.checkNotNullExpressionValue(notationDataArray, "signature.unhashedSubPac\u2026s.notationDataOccurrences");
            return ArraysKt.toList((Object[])notationDataArray);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<NotationData> getUnhashedNotationData(@NotNull PGPSignature signature, @NotNull String notationName) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(signature, "signature");
            Intrinsics.checkNotNullParameter(notationName, "notationName");
            Iterable $this$filter$iv = this.getUnhashedNotationData(signature);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                NotationData it = (NotationData)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getNotationName(), notationName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @Nullable
        public final RevocationKey getRevocationKey(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (RevocationKey)this.hashed(signature, SignatureSubpacket.revocationKey);
        }

        @JvmStatic
        @Nullable
        public final SignerUserID getSignerUserID(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (SignerUserID)this.hashed(signature, SignatureSubpacket.signerUserId);
        }

        @JvmStatic
        @NotNull
        public final List<IntendedRecipientFingerprint> getIntendedRecipientFingerprints(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            IntendedRecipientFingerprint[] intendedRecipientFingerprintArray = signature.getHashedSubPackets().getIntendedRecipientFingerprints();
            Intrinsics.checkNotNullExpressionValue(intendedRecipientFingerprintArray, "signature.hashedSubPacke\u2026ndedRecipientFingerprints");
            return ArraysKt.toList((Object[])intendedRecipientFingerprintArray);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final PGPSignatureList getEmbeddedSignature(@NotNull PGPSignature signature) {
            void var2_2;
            Intrinsics.checkNotNullParameter(signature, "signature");
            PGPSignatureList it = signature.getHashedSubPackets().getEmbeddedSignatures();
            boolean bl = false;
            Object object = it.isEmpty() ? signature.getUnhashedSubPackets().getEmbeddedSignatures() : var2_2;
            Intrinsics.checkNotNullExpressionValue(object, "signature.hashedSubPacke\u2026res else it\n            }");
            return object;
        }

        @JvmStatic
        @Nullable
        public final Exportable getExportableCertification(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (Exportable)this.hashed(signature, SignatureSubpacket.exportableCertification);
        }

        @JvmStatic
        public final boolean isExportable(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            Exportable exportable = this.getExportableCertification(signature);
            return exportable != null ? exportable.isExportable() : true;
        }

        @JvmStatic
        @Nullable
        public final TrustSignature getTrustSignature(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            return (TrustSignature)this.hashed(signature, SignatureSubpacket.trustSignature);
        }

        @JvmStatic
        public final int getTrustDepthOr(@NotNull PGPSignature signature, int defaultDepth) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            TrustSignature trustSignature = this.getTrustSignature(signature);
            return trustSignature != null ? trustSignature.getDepth() : defaultDepth;
        }

        @JvmStatic
        public final int getTrustAmountOr(@NotNull PGPSignature signature, int defaultAmount) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            TrustSignature trustSignature = this.getTrustSignature(signature);
            return trustSignature != null ? trustSignature.getTrustAmount() : defaultAmount;
        }

        @JvmStatic
        @NotNull
        public final List<RegularExpression> getRegularExpressions(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            RegularExpression[] regularExpressionArray = signature.getHashedSubPackets().getRegularExpressions();
            Intrinsics.checkNotNullExpressionValue(regularExpressionArray, "signature.hashedSubPackets.regularExpressions");
            return ArraysKt.toList((Object[])regularExpressionArray);
        }

        @JvmStatic
        @Nullable
        public final <P extends org.bouncycastle.bcpg.SignatureSubpacket> P hashedOrUnhashed(@NotNull PGPSignature signature, @NotNull SignatureSubpacket type) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            P p = this.hashed(signature, type);
            if (p == null) {
                p = this.unhashed(signature, type);
            }
            return p;
        }

        @JvmStatic
        @Nullable
        public final <P extends org.bouncycastle.bcpg.SignatureSubpacket> P hashed(@NotNull PGPSignature signature, @NotNull SignatureSubpacket type) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            return this.getSignatureSubpacket(signature.getHashedSubPackets(), type);
        }

        @JvmStatic
        @Nullable
        public final <P extends org.bouncycastle.bcpg.SignatureSubpacket> P unhashed(@NotNull PGPSignature signature, @NotNull SignatureSubpacket type) {
            Intrinsics.checkNotNullParameter(signature, "signature");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            return this.getSignatureSubpacket(signature.getUnhashedSubPackets(), type);
        }

        @JvmStatic
        @Nullable
        public final <P extends org.bouncycastle.bcpg.SignatureSubpacket> P getSignatureSubpacket(@Nullable PGPSignatureSubpacketVector vector, @NotNull SignatureSubpacket type) {
            org.bouncycastle.bcpg.SignatureSubpacket signatureSubpacket;
            Intrinsics.checkNotNullParameter((Object)type, "type");
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector = vector;
            org.bouncycastle.bcpg.SignatureSubpacket[] signatureSubpacketArray = pGPSignatureSubpacketVector != null ? pGPSignatureSubpacketVector.getSubpackets(type.getCode()) : null;
            if (signatureSubpacketArray == null) {
                return null;
            }
            org.bouncycastle.bcpg.SignatureSubpacket[] allPackets = signatureSubpacketArray;
            if (allPackets.length == 0) {
                signatureSubpacket = null;
            } else {
                org.bouncycastle.bcpg.SignatureSubpacket signatureSubpacket2 = ArraysKt.last(allPackets);
                Intrinsics.checkNotNull(signatureSubpacket2, "null cannot be cast to non-null type P of org.pgpainless.signature.subpackets.SignatureSubpacketsUtil.Companion.getSignatureSubpacket");
                signatureSubpacket = signatureSubpacket2;
            }
            return (P)signatureSubpacket;
        }

        @JvmStatic
        public final void assureKeyCanCarryFlags(@NotNull KeyType type, KeyFlag ... flags) {
            Intrinsics.checkNotNullParameter(type, "type");
            Intrinsics.checkNotNullParameter(flags, "flags");
            this.assureKeyCanCarryFlags(type.getAlgorithm(), Arrays.copyOf(flags, flags.length));
        }

        @JvmStatic
        public final void assureKeyCanCarryFlags(@NotNull PublicKeyAlgorithm algorithm, KeyFlag ... flags) {
            Intrinsics.checkNotNullParameter((Object)algorithm, "algorithm");
            Intrinsics.checkNotNullParameter(flags, "flags");
            int mask = KeyFlag.Companion.toBitmask(Arrays.copyOf(flags, flags.length));
            if (!algorithm.isSigningCapable() && KeyFlag.Companion.hasKeyFlag(mask, KeyFlag.CERTIFY_OTHER)) {
                throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag CERTIFY_OTHER.");
            }
            if (!algorithm.isSigningCapable() && KeyFlag.Companion.hasKeyFlag(mask, KeyFlag.SIGN_DATA)) {
                throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag SIGN_DATA.");
            }
            if (!algorithm.isEncryptionCapable() && KeyFlag.Companion.hasKeyFlag(mask, KeyFlag.ENCRYPT_COMMS)) {
                throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag ENCRYPT_COMMS.");
            }
            if (!algorithm.isEncryptionCapable() && KeyFlag.Companion.hasKeyFlag(mask, KeyFlag.ENCRYPT_STORAGE)) {
                throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag ENCRYPT_STORAGE.");
            }
            if (!algorithm.isSigningCapable() && KeyFlag.Companion.hasKeyFlag(mask, KeyFlag.AUTHENTICATION)) {
                throw new IllegalArgumentException("Algorithm " + (Object)((Object)algorithm) + " cannot be used with key flag AUTHENTICATION.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

