/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "()V", "keys", "", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "passphrases", "Lorg/pgpainless/util/Passphrase;", "protector", "Lorg/pgpainless/key/protection/CachingSecretKeyRingProtector;", "addPassphrase", "passphrase", "addSecretKey", "key", "clear", "", "getDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "keyId", "", "getEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "hasPassphraseFor", "", "testPassphrase", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nMatchMakingSecretKeyRingProtector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchMakingSecretKeyRingProtector.kt\norg/pgpainless/sop/MatchMakingSecretKeyRingProtector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1855#2,2:90\n1855#2:92\n1855#2,2:93\n1856#2:95\n1855#2,2:96\n1855#2,2:98\n*S KotlinDebug\n*F\n+ 1 MatchMakingSecretKeyRingProtector.kt\norg/pgpainless/sop/MatchMakingSecretKeyRingProtector\n*L\n37#1:90,2\n55#1:92\n59#1:93,2\n55#1:95\n85#1:96,2\n86#1:98,2\n*E\n"})
public final class MatchMakingSecretKeyRingProtector
implements SecretKeyRingProtector {
    @NotNull
    private final Set<Passphrase> passphrases = new LinkedHashSet();
    @NotNull
    private final Set<PGPSecretKeyRing> keys = new LinkedHashSet();
    @NotNull
    private final CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector();

    @NotNull
    public final MatchMakingSecretKeyRingProtector addPassphrase(@NotNull Passphrase passphrase) {
        MatchMakingSecretKeyRingProtector matchMakingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter(passphrase, "passphrase");
        MatchMakingSecretKeyRingProtector $this$addPassphrase_u24lambda_u241 = matchMakingSecretKeyRingProtector = this;
        boolean bl = false;
        if (!passphrase.isEmpty() && $this$addPassphrase_u24lambda_u241.passphrases.add(passphrase)) {
            Iterable $this$forEach$iv = $this$addPassphrase_u24lambda_u241.keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PGPSecretKeyRing key2 = (PGPSecretKeyRing)element$iv;
                boolean bl2 = false;
                for (PGPSecretKey subkey : key2) {
                    if ($this$addPassphrase_u24lambda_u241.protector.hasPassphrase(subkey.getKeyID())) continue;
                    Intrinsics.checkNotNullExpressionValue(subkey, "subkey");
                    if (!$this$addPassphrase_u24lambda_u241.testPassphrase(passphrase, subkey)) continue;
                    $this$addPassphrase_u24lambda_u241.protector.addPassphrase(subkey.getKeyID(), passphrase);
                }
            }
        }
        return matchMakingSecretKeyRingProtector;
    }

    @NotNull
    public final MatchMakingSecretKeyRingProtector addSecretKey(@NotNull PGPSecretKeyRing key2) {
        MatchMakingSecretKeyRingProtector matchMakingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter(key2, "key");
        MatchMakingSecretKeyRingProtector $this$addSecretKey_u24lambda_u244 = matchMakingSecretKeyRingProtector = this;
        boolean bl = false;
        if ($this$addSecretKey_u24lambda_u244.keys.add(key2)) {
            Iterable $this$forEach$iv = key2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PGPSecretKey subkey = (PGPSecretKey)element$iv;
                boolean bl2 = false;
                if (PGPSecretKeyExtensionsKt.isDecrypted(subkey)) {
                    $this$addSecretKey_u24lambda_u244.protector.addPassphrase(subkey.getKeyID(), Passphrase.Companion.emptyPassphrase());
                    continue;
                }
                Iterable $this$forEach$iv2 = $this$addSecretKey_u24lambda_u244.passphrases;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Passphrase passphrase = (Passphrase)element$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(subkey, "subkey");
                    if (!$this$addSecretKey_u24lambda_u244.testPassphrase(passphrase, subkey)) continue;
                    $this$addSecretKey_u24lambda_u244.protector.addPassphrase(subkey.getKeyID(), passphrase);
                }
            }
        }
        return matchMakingSecretKeyRingProtector;
    }

    private final boolean testPassphrase(Passphrase passphrase, PGPSecretKey key2) {
        boolean bl;
        try {
            PGPSecretKeyExtensionsKt.unlock(key2, passphrase);
            bl = true;
        }
        catch (PGPException e) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean hasPassphraseFor(long keyId) {
        return this.protector.hasPassphrase(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(long keyId) {
        return this.protector.getDecryptor(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(long keyId) {
        return this.protector.getEncryptor(keyId);
    }

    public final void clear() {
        Object it;
        Iterable $this$forEach$iv = this.passphrases;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Passphrase)element$iv;
            boolean bl = false;
            ((Passphrase)it).clear();
        }
        $this$forEach$iv = this.keys;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PGPSecretKeyRing)element$iv;
            boolean bl = false;
            this.protector.forgetPassphrase((PGPKeyRing)it);
        }
    }
}

