/*
 * Decompiled with CFR 0.152.
 */
package sop.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lsop/util/UTCUtil;", "", "()V", "Companion", "sop-java"})
@SourceDebugExtension(value={"SMAP\nUTCUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTCUtil.kt\nsop/util/UTCUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class UTCUtil {
    @NotNull
    public static final Companion Companion;
    @JvmField
    @NotNull
    public static final SimpleDateFormat UTC_FORMATTER;
    @JvmField
    @NotNull
    public static final SimpleDateFormat[] UTC_PARSERS;

    @JvmStatic
    @NotNull
    public static final Date parseUTCDate(@NotNull String dateString) throws ParseException {
        return Companion.parseUTCDate(dateString);
    }

    @JvmStatic
    @NotNull
    public static final String formatUTCDate(@NotNull Date date) {
        return Companion.formatUTCDate(date);
    }

    static {
        SimpleDateFormat[] simpleDateFormatArray;
        Companion = new Companion(null);
        UTC_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        SimpleDateFormat[] simpleDateFormatArray2 = new SimpleDateFormat[]{UTC_FORMATTER, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"), new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'")};
        for (SimpleDateFormat fmt : simpleDateFormatArray = simpleDateFormatArray2) {
            boolean bl = false;
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        UTC_PARSERS = simpleDateFormatArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00068\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lsop/util/UTCUtil$Companion;", "", "()V", "UTC_FORMATTER", "Ljava/text/SimpleDateFormat;", "UTC_PARSERS", "", "[Ljava/text/SimpleDateFormat;", "formatUTCDate", "", "date", "Ljava/util/Date;", "parseUTCDate", "dateString", "sop-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Date parseUTCDate(@NotNull String dateString) throws ParseException {
            Intrinsics.checkNotNullParameter(dateString, "dateString");
            ParseException exception = null;
            for (SimpleDateFormat parser : UTC_PARSERS) {
                try {
                    Date date = parser.parse(dateString);
                    Intrinsics.checkNotNullExpressionValue(date, "parser.parse(dateString)");
                    return date;
                }
                catch (ParseException e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
            ParseException parseException = exception;
            Intrinsics.checkNotNull(parseException);
            throw parseException;
        }

        @JvmStatic
        @NotNull
        public final String formatUTCDate(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            String string = UTC_FORMATTER.format(date);
            Intrinsics.checkNotNullExpressionValue(string, "UTC_FORMATTER.format(date)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

