/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.cli.commands.CLITest;
import org.slf4j.LoggerFactory;

public class RoundTripInlineSignVerifyCmdTest
extends CLITest {
    public RoundTripInlineSignVerifyCmdTest() {
        super(LoggerFactory.getLogger(RoundTripInlineSignVerifyCmdTest.class));
    }

    @Test
    public void encryptAndDecryptAMessage() throws IOException {
        File password = this.writeFile("password", "sw0rdf1sh");
        File sigmundKey = this.pipeStdoutToFile("sigmund.key");
        this.assertSuccess(this.executeCommand("generate-key", "--with-key-password=" + password.getAbsolutePath(), "Sigmund Freud <sigmund@pgpainless.org>"));
        File sigmundCert = this.pipeStdoutToFile("sigmund.cert");
        this.pipeFileToStdin(sigmundKey);
        this.assertSuccess(this.executeCommand("extract-cert"));
        this.pipeBytesToStdin("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        File signedMsg = this.pipeStdoutToFile("signed.asc");
        this.assertSuccess(this.executeCommand("inline-sign", "--with-key-password=" + password.getAbsolutePath(), sigmundKey.getAbsolutePath()));
        File verifyFile = this.nonExistentFile("verify.txt");
        this.pipeFileToStdin(signedMsg);
        this.assertSuccess(this.executeCommand("inline-verify", "--verifications-out", verifyFile.getAbsolutePath(), sigmundCert.getAbsolutePath()));
        String verifications = this.readStringFromFile(verifyFile);
        Assertions.assertFalse((boolean)verifications.trim().isEmpty());
    }
}

