/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.cli.commands.CLITest;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.key.info.KeyRingInfo;
import org.slf4j.LoggerFactory;
import sop.util.UTCUtil;

public class RoundTripSignVerifyCmdTest
extends CLITest {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 9DA0 9423 C9F9 4BA4 CCA3  0951 099B 11BF 296A 373E\nComment: Sigmund <sigmund@pgpainless.org>\n\nlFgEY2vzkhYJKwYBBAHaRw8BAQdA+Z2OAFQf0k64Au7hIZfXh/ijclabddvwh7Nh\nkedJ3ZUAAQCZy5p1cvQvRIWUopHwhnrD/oVAa1dNT/nA3cihQ5gkZBHPtCBTaWdt\ndW5kIDxzaWdtdW5kQHBncGFpbmxlc3Mub3JnPoiPBBMWCgBBBQJja/OSCRAJmxG/\nKWo3PhYhBJ2glCPJ+UukzKMJUQmbEb8pajc+Ap4BApsBBRYCAwEABAsJCAcFFQoJ\nCAsCmQEAACM9AP9APloI2waD5gXsJqzenRVU4n/VmZUvcdUyhlbpab/0HQEAlaTw\nZvxVyaf8EMFSJOY+LcgacHaZDHRPA1nS3bIfKwycXQRja/OSEgorBgEEAZdVAQUB\nAQdA1WL4QKgRxbvzW91ICM6PoICSNh2QHK6j0pIdN/cqXz0DAQgHAAD/bOk3WqbF\nQAE8xxm0w/KDZzL1N0yPcBQ5z4XKmu77FCgQ04h1BBgWCgAdBQJja/OSAp4BApsM\nBRYCAwEABAsJCAcFFQoJCAsACgkQCZsRvylqNz6rgQEAzoG6HnPCYi2i2c6/ufuy\npBkLby2u1JjD0CWSbrM4dZ0A/j/pI4a9b8LcrZcuY2QwHqsXPAJp8QtOOQN6gTvN\nWcQNnFgEY2vzkhYJKwYBBAHaRw8BAQdAsxcDCvst/GbWxQvvOpChSvmbqWeuBgm3\n1vRoujFVFcYAAP9Ww46yfWipb8OivTSX+PvgdUhEeVgxENpsyOQLLhQP/RFziNUE\nGBYKAH0FAmNr85ICngECmwIFFgIDAQAECwkIBwUVCgkIC18gBBkWCgAGBQJja/OS\nAAoJENqfQTmGIR3GtsMBAL+b1Zo5giQKJGEyx5aGwAz3AwtGiT6QDS9FH6HyM855\nAP4uAXDiaNxYTugqnG471jYX/hhJqIROeDGrEIkkAp+qDwAKCRAJmxG/KWo3PhOX\nAP45LPV6I4+D3h8etdiEA2DVvNcpRA8l4WkNcq4q8H1SjwD/c/rX3FCUIWLlAHoR\nWxCFj+gDgqDNLzwoA4iNo1VMtQc=\n=/Np6\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final String CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: 9DA0 9423 C9F9 4BA4 CCA3  0951 099B 11BF 296A 373E\nComment: Sigmund <sigmund@pgpainless.org>\n\nmDMEY2vzkhYJKwYBBAHaRw8BAQdA+Z2OAFQf0k64Au7hIZfXh/ijclabddvwh7Nh\nkedJ3ZW0IFNpZ211bmQgPHNpZ211bmRAcGdwYWlubGVzcy5vcmc+iI8EExYKAEEF\nAmNr85IJEAmbEb8pajc+FiEEnaCUI8n5S6TMowlRCZsRvylqNz4CngECmwEFFgID\nAQAECwkIBwUVCgkICwKZAQAAIz0A/0A+WgjbBoPmBewmrN6dFVTif9WZlS9x1TKG\nVulpv/QdAQCVpPBm/FXJp/wQwVIk5j4tyBpwdpkMdE8DWdLdsh8rDLg4BGNr85IS\nCisGAQQBl1UBBQEBB0DVYvhAqBHFu/Nb3UgIzo+ggJI2HZAcrqPSkh039ypfPQMB\nCAeIdQQYFgoAHQUCY2vzkgKeAQKbDAUWAgMBAAQLCQgHBRUKCQgLAAoJEAmbEb8p\najc+q4EBAM6Buh5zwmItotnOv7n7sqQZC28trtSYw9Alkm6zOHWdAP4/6SOGvW/C\n3K2XLmNkMB6rFzwCafELTjkDeoE7zVnEDbgzBGNr85IWCSsGAQQB2kcPAQEHQLMX\nAwr7Lfxm1sUL7zqQoUr5m6lnrgYJt9b0aLoxVRXGiNUEGBYKAH0FAmNr85ICngEC\nmwIFFgIDAQAECwkIBwUVCgkIC18gBBkWCgAGBQJja/OSAAoJENqfQTmGIR3GtsMB\nAL+b1Zo5giQKJGEyx5aGwAz3AwtGiT6QDS9FH6HyM855AP4uAXDiaNxYTugqnG47\n1jYX/hhJqIROeDGrEIkkAp+qDwAKCRAJmxG/KWo3PhOXAP45LPV6I4+D3h8etdiE\nA2DVvNcpRA8l4WkNcq4q8H1SjwD/c/rX3FCUIWLlAHoRWxCFj+gDgqDNLzwoA4iN\no1VMtQc=\n=KuJ4\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String PLAINTEXT = "Hello, World!\n";
    private static final String BINARY_SIG = "-----BEGIN PGP SIGNATURE-----\nVersion: PGPainless\n\niHUEABYKACcFAmNr9BgJENqfQTmGIR3GFiEEREwQqwEe+EJMg/Cp2p9BOYYhHcYA\nAKocAP48P2C3TU33T3Zy73clw0eBa1oW9pwxTGuFxhgOBzmoSwEArj0781GlpTB0\nVnr2PjPYEqzB+ZuOzOnGhsVGob4c3Ao=\n=VWAZ\n-----END PGP SIGNATURE-----";
    private static final String BINARY_SIG_VERIFICATION = "2022-11-09T18:40:24Z 444C10AB011EF8424C83F0A9DA9F413986211DC6 9DA09423C9F94BA4CCA30951099B11BF296A373E mode:binary\n";
    private static final String TEXT_SIG = "-----BEGIN PGP SIGNATURE-----\nVersion: PGPainless\n\niHUEARYKACcFAmNr9E4JENqfQTmGIR3GFiEEREwQqwEe+EJMg/Cp2p9BOYYhHcYA\nAG+CAQD1B3GAAlyxahSiGhvJv7YAI1m6qGcI7dIXcV7FkAFPSgEAlZ0UpCC8oGR+\nhi/mQlex4z0hDWSA4abAjclPTJ+qkAI=\n=s5xn\n-----END PGP SIGNATURE-----";
    private static final String TEXT_SIG_VERIFICATION = "2022-11-09T18:41:18Z 444C10AB011EF8424C83F0A9DA9F413986211DC6 9DA09423C9F94BA4CCA30951099B11BF296A373E mode:text\n";
    private static final Date TEXT_SIG_CREATION;
    private static final String PROTECTED_KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 738E EAB2 503D 322D 613A  C42A B18E 8BF8 884F C050\nComment: Axel <axel@pgpainless.org>\n\nlIYEY2v6aRYJKwYBBAHaRw8BAQdA3PXtH19zYpVQ9zTU3zlY+iXUptelAO3z4vK/\nM2FkmrP+CQMCYgVa6K+InVJguITSDIA+HQ6vhOZ5Dbanqx7GFbJbJLD2fWrxhTSr\nBUWGaUWTqN647auD/kUI8phH1cedVL6CzVR+YWvaWj9zZHr/CYXLobQaQXhlbCA8\nYXhlbEBwZ3BhaW5sZXNzLm9yZz6IjwQTFgoAQQUCY2v6aQkQsY6L+IhPwFAWIQRz\njuqyUD0yLWE6xCqxjov4iE/AUAKeAQKbAQUWAgMBAAQLCQgHBRUKCQgLApkBAACq\nzgEAkxB+dUI7Jjcg5zRvT1EfE9DKCI1qTsxOAU/ZXLcSXLkBAJtWRsyptetZvjzB\nZe2A7ArOl4q+IvKvun/d783YyRMInIsEY2v6aRIKKwYBBAGXVQEFAQEHQPFmlZ+o\njCGEo2X0474vJfRG7blctuZXmCbC0sLO7MgzAwEIB/4JAwJiBVror4idUmDFhBq4\nlEhJxjCVc6aSD6+EWRT3YdplqCmNdynnrPombUFst6LfJFzns3H3d0rCeXHfQr93\nGrHTLkHfW8G3x0PJJPiqFkBviHUEGBYKAB0FAmNr+mkCngECmwwFFgIDAQAECwkI\nBwUVCgkICwAKCRCxjov4iE/AUNC2AP9WDx4lHt9oYFLSrM8vMLRFI31U8TkYrtCe\npYICE76cIAEA5+wEbtE5vQrLxOqIRueVVdzwK9kTeMvSIQfc9PNoyQKchgRja/pp\nFgkrBgEEAdpHDwEBB0CyAEVlCUbFr3dBBG3MQ84hjCPfYqSx9kYsTN8j5Og6uP4J\nAwJiBVror4idUmCIFuAYXia0YpEhEpB/Lrn/D6/WAUPEgZjNLMvJzL//EmhkWfEa\nOfQz/fslj1erWNjLKNiW5C/TvGapDfjbn596AkNlcd1JiNUEGBYKAH0FAmNr+mkC\nngECmwIFFgIDAQAECwkIBwUVCgkIC18gBBkWCgAGBQJja/ppAAoJELRgil1uCuQj\nVUYBAJecbedwwqWQITVqucEBIraTRoc6ZGkN8jytDp8z9CsBAQDrb/W/J/kze6ln\nnRyJSriWF3SjcKOGIRkUslmdJEPPCQAKCRCxjov4iE/AUAvbAQDBBgQFG8acTT5L\ncyIi1Ix9/XBG7G23SSs6l7Beap8M+wEAmK13NYuq7Mv/mct8iIKZbBFH9aAiY+nX\n3Uct4Q5f0w0=\n=K65R\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final String PASSPHRASE = "orange";
    private static final String SIGNING_KEY = "9846F3606EE875FB77EC8808B4608A5D6E0AE423 738EEAB2503D322D613AC42AB18E8BF8884FC050";

    public RoundTripSignVerifyCmdTest() {
        super(LoggerFactory.getLogger(RoundTripSignVerifyCmdTest.class));
    }

    @Test
    public void createArmoredSignature() throws IOException {
        File keyFile = this.writeFile("key.asc", KEY);
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("sign", "--as", "text", keyFile.getAbsolutePath()));
        Assertions.assertTrue((boolean)out.toString().startsWith("-----BEGIN PGP SIGNATURE-----\n"));
    }

    @Test
    public void createUnarmoredSignature() throws IOException {
        File keyFile = this.writeFile("key.asc", KEY);
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("sign", "--no-armor", keyFile.getAbsolutePath()));
        Assertions.assertFalse((boolean)out.toString().startsWith("-----BEGIN PGP SIGNATURE-----\n"));
    }

    @Test
    public void unarmorArmoredSigAndVerify() throws IOException {
        File certFile = this.writeFile("cert.asc", CERT);
        this.pipeStringToStdin(BINARY_SIG);
        File unarmoredSigFile = this.pipeStdoutToFile("sig.pgp");
        this.assertSuccess(this.executeCommand("dearmor"));
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("verify", unarmoredSigFile.getAbsolutePath(), certFile.getAbsolutePath()));
        Assertions.assertEquals((Object)BINARY_SIG_VERIFICATION, (Object)out.toString());
    }

    @Test
    public void testNotBefore() throws IOException {
        File cert = this.writeFile("cert.asc", CERT);
        File sigFile = this.writeFile("sig.asc", TEXT_SIG);
        Date plus1Minute = new Date(TEXT_SIG_CREATION.getTime() + 60000L);
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("verify", sigFile.getAbsolutePath(), cert.getAbsolutePath(), "--not-before", UTCUtil.formatUTCDate((Date)plus1Minute));
        Assertions.assertEquals((int)3, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
        Date minus1Minute = new Date(TEXT_SIG_CREATION.getTime() - 60000L);
        this.pipeStringToStdin(PLAINTEXT);
        out = this.pipeStdoutToStream();
        exitCode = this.executeCommand("verify", sigFile.getAbsolutePath(), cert.getAbsolutePath(), "--not-before", UTCUtil.formatUTCDate((Date)minus1Minute));
        this.assertSuccess(exitCode);
        Assertions.assertEquals((Object)TEXT_SIG_VERIFICATION, (Object)out.toString());
    }

    @Test
    public void testNotAfter() throws IOException {
        File cert = this.writeFile("cert.asc", CERT);
        File sigFile = this.writeFile("sig.asc", TEXT_SIG);
        Date minus1Minute = new Date(TEXT_SIG_CREATION.getTime() - 60000L);
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("verify", sigFile.getAbsolutePath(), cert.getAbsolutePath(), "--not-after", UTCUtil.formatUTCDate((Date)minus1Minute));
        Assertions.assertEquals((int)3, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
        Date plus1Minute = new Date(TEXT_SIG_CREATION.getTime() + 60000L);
        this.pipeStringToStdin(PLAINTEXT);
        out = this.pipeStdoutToStream();
        exitCode = this.executeCommand("verify", sigFile.getAbsolutePath(), cert.getAbsolutePath(), "--not-after", UTCUtil.formatUTCDate((Date)plus1Minute));
        this.assertSuccess(exitCode);
        Assertions.assertEquals((Object)TEXT_SIG_VERIFICATION, (Object)out.toString());
    }

    @Test
    public void testSignWithIncapableKey() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().addUserId((CharSequence)"Cannot Sign <cannot@sign.key>").setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE}))).build();
        File keyFile = this.writeFile("key.pgp", secretKeys.getEncoded());
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("sign", keyFile.getAbsolutePath());
        Assertions.assertEquals((int)79, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void testSignatureCreationAndVerification() throws IOException {
        File aliceKeyFile = this.pipeStdoutToFile("alice.key");
        this.assertSuccess(this.executeCommand("generate-key", "Alice <alice@pgpainless.org>"));
        File aliceCertFile = this.pipeStdoutToFile("alice.cert");
        this.pipeFileToStdin(aliceKeyFile);
        this.assertSuccess(this.executeCommand("extract-cert"));
        File micalgOut = this.nonExistentFile("micalg");
        String msg = "If privacy is outlawed, only outlaws will have privacy.\n";
        File dataFile = this.writeFile("data", msg);
        File sigFile = this.pipeStdoutToFile("sig.asc");
        this.pipeFileToStdin(dataFile);
        this.assertSuccess(this.executeCommand("sign", "--armor", "--as", "binary", "--micalg-out", micalgOut.getAbsolutePath(), aliceKeyFile.getAbsolutePath()));
        this.pipeFileToStdin(dataFile);
        ByteArrayOutputStream verificationsOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("verify", sigFile.getAbsolutePath(), aliceCertFile.getAbsolutePath()));
        PGPPublicKeyRing cert = PGPainless.readKeyRing().publicKeyRing(this.readBytesFromFile(aliceCertFile));
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)cert);
        String verification = verificationsOut.toString();
        String[] split = verification.split(" ");
        OpenPgpV4Fingerprint primaryKeyFingerprint = new OpenPgpV4Fingerprint((PGPKeyRing)cert);
        OpenPgpV4Fingerprint signingKeyFingerprint = new OpenPgpV4Fingerprint((PGPPublicKey)info.getSigningSubkeys().get(0));
        Assertions.assertEquals((Object)signingKeyFingerprint.toString(), (Object)split[1].trim(), (String)verification);
        Assertions.assertEquals((Object)primaryKeyFingerprint.toString(), (Object)split[2].trim());
        String content = this.readStringFromFile(micalgOut);
        Assertions.assertEquals((Object)"pgp-sha512", (Object)content);
    }

    @Test
    public void signWithProtectedKey_missingPassphraseFails() throws IOException {
        File key = this.writeFile("key.asc", PROTECTED_KEY);
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("sign", key.getAbsolutePath());
        Assertions.assertEquals((int)67, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void signWithProtectedKey_wrongPassphraseFails() throws IOException {
        File password = this.writeFile("password", "blue");
        File key = this.writeFile("key.asc", PROTECTED_KEY);
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("sign", key.getAbsolutePath(), "--with-key-password", password.getAbsolutePath());
        Assertions.assertEquals((int)67, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void signWithProtectedKey() throws IOException {
        File password = this.writeFile("password", PASSPHRASE);
        File key = this.writeFile("key.asc", PROTECTED_KEY);
        this.pipeStringToStdin(PROTECTED_KEY);
        File cert = this.pipeStdoutToFile("cert.asc");
        this.assertSuccess(this.executeCommand("extract-cert"));
        this.pipeStringToStdin(PLAINTEXT);
        File sigFile = this.pipeStdoutToFile("sig.asc");
        this.assertSuccess(this.executeCommand("sign", key.getAbsolutePath(), "--with-key-password", password.getAbsolutePath()));
        this.pipeStringToStdin(PLAINTEXT);
        ByteArrayOutputStream verificationOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("verify", sigFile.getAbsolutePath(), cert.getAbsolutePath()));
        Assertions.assertTrue((boolean)verificationOut.toString().contains(SIGNING_KEY));
    }

    static {
        try {
            TEXT_SIG_CREATION = UTCUtil.parseUTCDate((String)"2022-11-09T18:41:18Z");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

