/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class DecryptAndVerifyMessageTest {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private PGPSecretKeyRing juliet;
    private PGPSecretKeyRing romeo;

    @Before
    public void loadKeys() throws IOException, PGPException {
        this.juliet = TestKeys.getJulietSecretKeyRing();
        this.romeo = TestKeys.getRomeoSecretKeyRing();
    }

    @Test
    public void decryptMessageAndVerifySignatureTest() throws Exception {
        String encryptedMessage = "-----BEGIN PGP MESSAGE-----\n\nhQEMA7S1CctZNuA+AQf/SMX7NTOaAynogTVKE9BMWSj5fgK+7sFrCKiLYbungJEu\nRA/fYqaJNfZN3GARqsHcGaGihQDXr0thnx71+37NhV2cHVeFkeMsHmJf/74lRrHk\nQBXDv2ez0LxUwhkE15/d/NTlT/fm8Vzce6rsm7/ZvzQIaWYyDCnpHXyftJplKd+Y\nPW0PaoFRq1wlZKcNUp/1a3xxpbSpvsYkiAxpdGIwvgUIb85KpFN0EWD3aH8C65it\nIphuv8CEaKqcO0hchQr7kYclEM0qcmm1ukw8+niTV8TFqAzNZh7DF/IWaMeamgfA\nP6pAB1oy7YoWUPQgy7mczD76WzPgJjy8y0hxFd9/f9LA2gEZZ/ClAiX0gHglc4oa\nj5iKIICvtTQzKYL29mW66BUistqMavz6eqHRggoADCBzfgOwuoAQxZMyj33bmrWm\n831LMu+4sZyx6ihLvZ0YcDKMd7C7pQJ3Ucxt+DJUlTmo6KxzGdwGhq7cUcXwCuer\n3MoPIV5YQwXBMbYN9fXV+yQagquz0z7r5igE7AQ1d9SyLJoQ3IHXnsa0xcUVZrIs\nA59LdIXEeRk/Ctjqp34UdTsuUPzervPexY+kNQVSQ2VODhwM5IowzPZFGviPNJYa\nnGt27c4rsQ3sSC/WkdUxdaVY2+m7JktfnklUyVyC5wE1Nw+bO3sni6FeoP/fVSVi\nHmPy7vMj23cQcvcAnuUEd4Qua0lwVrN1MTUggfZOzcH4+9rgMn/uYRAwPH9hdLWQ\nvziQMH5qtJMyWy08m9hIxleoI3+zIGSbra15R+hdWwEaD9+Pak//0Q0thFMeNww7\nY8gK8CSbUHbUjefUIx0s+JjrDGtXG8xfl63MLBbU7yLLB4Vcx77Sxxi3yt5DTi0n\nGmPGRU4LsOYbpPFy\n=caif\n-----END PGP MESSAGE-----";
        DecryptionStream decryptor = PGPainless.createDecryptor().onInputStream((InputStream)new ByteArrayInputStream(encryptedMessage.getBytes())).decryptWith((SecretKeyRingProtector)new UnprotectedKeysProtector(), new PGPSecretKeyRingCollection(Collections.singleton(this.juliet))).verifyWith(Collections.singleton(new PGPPublicKeyRing(Collections.singletonList(this.juliet.getPublicKey())))).ignoreMissingPublicKeys().build();
        ByteArrayOutputStream toPlain = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)toPlain);
        decryptor.close();
        toPlain.close();
        OpenPgpMetadata metadata = decryptor.getResult();
        byte[] expected = "This message is encrypted\n".getBytes(UTF8);
        byte[] actual = toPlain.toByteArray();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        TestCase.assertTrue((boolean)metadata.isIntegrityProtected());
        TestCase.assertTrue((boolean)metadata.isEncrypted());
        TestCase.assertTrue((boolean)metadata.isSigned());
        TestCase.assertTrue((boolean)metadata.isVerified());
        TestCase.assertEquals((Object)CompressionAlgorithm.ZLIB, (Object)metadata.getCompressionAlgorithm());
        TestCase.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)metadata.getSymmetricKeyAlgorithm());
        TestCase.assertEquals((int)1, (int)metadata.getSignatures().size());
        TestCase.assertEquals((int)1, (int)metadata.getVerifiedSignatureKeyFingerprints().size());
        TestCase.assertTrue((boolean)metadata.containsVerifiedSignatureFrom(TestKeys.JULIET_FINGERPRINT));
        TestCase.assertEquals((Object)TestKeys.JULIET_FINGERPRINT, (Object)metadata.getDecryptionFingerprint());
    }
}

