/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.Assert;
import org.junit.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.collection.PGPKeyRing;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.ElGamal_GENERAL;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.RSA_GENERAL;
import org.pgpainless.key.generation.type.length.ElGamalLength;
import org.pgpainless.key.generation.type.length.RsaLength;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.BCUtil;

public class EncryptDecryptTest {
    private static final Logger LOGGER = Logger.getLogger(EncryptDecryptTest.class.getName());
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String testMessage = "Ah, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.";

    @Test
    public void freshKeysRsaToElGamalTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPKeyRing recipient = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)ElGamal_GENERAL.withLength((ElGamalLength)ElGamalLength._3072)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()).withMasterKey(KeySpec.getBuilder((KeyType)RSA_GENERAL.withLength((RsaLength)RsaLength._4096)).withKeyFlags(new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}).withDefaultAlgorithms()).withPrimaryUserId("juliet@capulet.lit").withoutPassphrase().build();
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void freshKeysRsaToRsaTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPKeyRing recipient = PGPainless.generateKeyRing().simpleRsaKeyRing("juliet@capulet.lit", RsaLength._3072);
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void freshKeysEcToEcTest() throws IOException, PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        PGPKeyRing sender = PGPainless.generateKeyRing().simpleEcKeyRing("romeo@montague.lit");
        PGPKeyRing recipient = PGPainless.generateKeyRing().simpleEcKeyRing("juliet@capulet.lit");
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void freshKeysEcToRsaTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPKeyRing sender = PGPainless.generateKeyRing().simpleEcKeyRing("romeo@montague.lit");
        PGPKeyRing recipient = PGPainless.generateKeyRing().simpleRsaKeyRing("juliet@capulet.lit", RsaLength._3072);
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void freshKeysRsaToEcTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPKeyRing recipient = PGPainless.generateKeyRing().simpleEcKeyRing("juliet@capulet.lit");
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void existingRsaKeysTest() throws IOException, PGPException {
        PGPKeyRing sender = new PGPKeyRing(TestKeys.getJulietPublicKeyRing(), TestKeys.getJulietSecretKeyRing());
        PGPKeyRing recipient = new PGPKeyRing(TestKeys.getRomeoPublicKeyRing(), TestKeys.getRomeoSecretKeyRing());
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    private void encryptDecryptForSecretKeyRings(PGPKeyRing sender, PGPKeyRing recipient) throws PGPException, IOException {
        PGPSecretKeyRing recipientSec = recipient.getSecretKeys();
        PGPSecretKeyRing senderSec = sender.getSecretKeys();
        PGPPublicKeyRing recipientPub = recipient.getPublicKeys();
        PGPPublicKeyRing senderPub = sender.getPublicKeys();
        UnprotectedKeysProtector keyDecryptor = new UnprotectedKeysProtector();
        byte[] secretMessage = testMessage.getBytes(UTF8);
        ByteArrayOutputStream envelope = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.createEncryptor().onOutputStream((OutputStream)envelope).toRecipients(new PGPPublicKeyRing[]{recipientPub}).usingSecureAlgorithms().signWith((SecretKeyRingProtector)keyDecryptor, new PGPSecretKeyRing[]{senderSec}).noArmor();
        Streams.pipeAll((InputStream)new ByteArrayInputStream(secretMessage), (OutputStream)encryptor);
        encryptor.close();
        byte[] encryptedSecretMessage = envelope.toByteArray();
        OpenPgpMetadata encryptionResult = encryptor.getResult();
        TestCase.assertFalse((boolean)encryptionResult.getSignatures().isEmpty());
        for (OpenPgpV4Fingerprint fingerprint : encryptionResult.getVerifiedSignatures().keySet()) {
            TestCase.assertTrue((boolean)BCUtil.keyRingContainsKeyWithId((PGPPublicKeyRing)senderPub, (long)fingerprint.getKeyId()));
        }
        TestCase.assertFalse((boolean)encryptionResult.getRecipientKeyIds().isEmpty());
        Iterator<Object> iterator = encryptionResult.getRecipientKeyIds().iterator();
        while (iterator.hasNext()) {
            long keyId = (Long)iterator.next();
            TestCase.assertTrue((boolean)BCUtil.keyRingContainsKeyWithId((PGPPublicKeyRing)recipientPub, (long)keyId));
        }
        TestCase.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)encryptionResult.getSymmetricKeyAlgorithm());
        ByteArrayInputStream envelopeIn = new ByteArrayInputStream(encryptedSecretMessage);
        DecryptionStream decryptor = PGPainless.createDecryptor().onInputStream((InputStream)envelopeIn).decryptWith((SecretKeyRingProtector)keyDecryptor, BCUtil.keyRingsToKeyRingCollection((PGPSecretKeyRing[])new PGPSecretKeyRing[]{recipientSec})).verifyWith(BCUtil.keyRingsToKeyRingCollection((PGPPublicKeyRing[])new PGPPublicKeyRing[]{senderPub})).ignoreMissingPublicKeys().build();
        ByteArrayOutputStream decryptedSecretMessage = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)decryptedSecretMessage);
        decryptor.close();
        Assert.assertArrayEquals((byte[])secretMessage, (byte[])decryptedSecretMessage.toByteArray());
        OpenPgpMetadata result = decryptor.getResult();
        TestCase.assertTrue((boolean)result.containsVerifiedSignatureFrom(senderPub));
        TestCase.assertTrue((boolean)result.isIntegrityProtected());
        TestCase.assertTrue((boolean)result.isSigned());
        TestCase.assertTrue((boolean)result.isEncrypted());
        TestCase.assertTrue((boolean)result.isVerified());
    }

    @Test
    public void testDetachedSignatureCreationAndVerification() throws IOException, PGPException {
        PGPKeyRing signingKeys = new PGPKeyRing(TestKeys.getJulietPublicKeyRing(), TestKeys.getJulietSecretKeyRing());
        UnprotectedKeysProtector keyRingProtector = new UnprotectedKeysProtector();
        byte[] data = testMessage.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream dummyOut = new ByteArrayOutputStream();
        EncryptionStream signer = PGPainless.createEncryptor().onOutputStream((OutputStream)dummyOut).doNotEncrypt().createDetachedSignature().signWith((SecretKeyRingProtector)keyRingProtector, new PGPSecretKeyRing[]{signingKeys.getSecretKeys()}).noArmor();
        Streams.pipeAll((InputStream)inputStream, (OutputStream)signer);
        signer.close();
        OpenPgpMetadata metadata = signer.getResult();
        Set signatureSet = metadata.getSignatures();
        ByteArrayOutputStream sigOut = new ByteArrayOutputStream();
        ArmoredOutputStream armorOut = new ArmoredOutputStream((OutputStream)sigOut);
        ((PGPSignature)signatureSet.iterator().next()).encode((OutputStream)armorOut);
        armorOut.close();
        String armorSig = sigOut.toString();
        System.out.println(armorSig);
        inputStream = new ByteArrayInputStream(testMessage.getBytes());
        DecryptionStream verifier = PGPainless.createDecryptor().onInputStream((InputStream)inputStream).doNotDecrypt().verifyDetachedSignature((InputStream)new ByteArrayInputStream(armorSig.getBytes())).verifyWith(Collections.singleton(signingKeys.getPublicKeys())).ignoreMissingPublicKeys().build();
        dummyOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verifier, (OutputStream)dummyOut);
        verifier.close();
        metadata = verifier.getResult();
        TestCase.assertFalse((boolean)metadata.getVerifiedSignatures().isEmpty());
    }

    @Test
    public void testOnePassSignatureCreationAndVerification() throws IOException, PGPException {
        PGPKeyRing signingKeys = new PGPKeyRing(TestKeys.getJulietPublicKeyRing(), TestKeys.getJulietSecretKeyRing());
        UnprotectedKeysProtector keyRingProtector = new UnprotectedKeysProtector();
        byte[] data = testMessage.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream signOut = new ByteArrayOutputStream();
        EncryptionStream signer = PGPainless.createEncryptor().onOutputStream((OutputStream)signOut).doNotEncrypt().signWith((SecretKeyRingProtector)keyRingProtector, new PGPSecretKeyRing[]{signingKeys.getSecretKeys()}).asciiArmor();
        Streams.pipeAll((InputStream)inputStream, (OutputStream)signer);
        signer.close();
        System.out.println(signOut.toString());
        inputStream = new ByteArrayInputStream(signOut.toByteArray());
        DecryptionStream verifier = PGPainless.createDecryptor().onInputStream((InputStream)inputStream).doNotDecrypt().verifyWith(Collections.singleton(signingKeys.getPublicKeys())).ignoreMissingPublicKeys().build();
        signOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verifier, (OutputStream)signOut);
        verifier.close();
        OpenPgpMetadata metadata = verifier.getResult();
        TestCase.assertFalse((boolean)metadata.getVerifiedSignatures().isEmpty());
    }
}

