/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.junit.Assert;
import org.junit.Test;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;

public class OpenPgpV4FingerprintTest {
    @Test(expected=IllegalArgumentException.class)
    public void fpTooShort() {
        String fp = "484f57414c495645";
        new OpenPgpV4Fingerprint(fp);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidHexTest() {
        String fp = "UNFORTUNATELYTHISISNOVALIDHEXADECIMALDOH";
        new OpenPgpV4Fingerprint(fp);
    }

    @Test
    public void validFingerprintTest() {
        String fp = "4A4F48414E4E53454E2049532041204E45524421";
        OpenPgpV4Fingerprint finger = new OpenPgpV4Fingerprint(fp);
        TestCase.assertEquals((String)fp, (String)finger.toString());
        TestCase.assertEquals((int)fp.length(), (int)finger.length());
        for (int i = 0; i < finger.length(); ++i) {
            TestCase.assertEquals((char)fp.charAt(i), (char)finger.charAt(i));
        }
        TestCase.assertEquals((Object)"4A4F", (Object)finger.subSequence(0, 4));
    }

    @Test
    public void convertsToUpperCaseTest() {
        String fp = "444f4e5420552048415645204120484f4242593f";
        OpenPgpV4Fingerprint finger = new OpenPgpV4Fingerprint(fp);
        TestCase.assertEquals((String)"444F4E5420552048415645204120484F4242593F", (String)finger.toString());
    }

    @Test
    public void equalsOtherFingerprintTest() {
        OpenPgpV4Fingerprint finger = new OpenPgpV4Fingerprint("5448452043414b452049532041204c4945212121");
        TestCase.assertEquals((Object)finger, (Object)new OpenPgpV4Fingerprint("5448452043414B452049532041204C4945212121"));
        TestCase.assertEquals((int)0, (int)finger.compareTo(new OpenPgpV4Fingerprint("5448452043414B452049532041204C4945212121")));
        Assert.assertNotEquals((Object)finger, (Object)new OpenPgpV4Fingerprint("0000000000000000000000000000000000000000"));
        Assert.assertNotEquals((Object)finger, null);
        Assert.assertNotEquals((Object)finger, (Object)new Object());
    }

    @Test
    public void assertFingerprintGetKeyIdEqualsKeyId() throws IOException {
        PGPPublicKey key = TestKeys.getJulietPublicKeyRing().getPublicKey();
        long keyId = key.getKeyID();
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(key);
        TestCase.assertEquals((long)keyId, (long)fingerprint.getKeyId());
    }

    @Test
    public void testToUri() {
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint("5448452043414B452049532041204C4945212121");
        URI uri = fingerprint.toUri();
        TestCase.assertEquals((String)"openpgp4fpr:5448452043414B452049532041204C4945212121", (String)uri.toString());
        OpenPgpV4Fingerprint parsed = OpenPgpV4Fingerprint.fromUri((URI)uri);
        TestCase.assertEquals((Object)fingerprint, (Object)parsed);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromUriThrowsIfWrongScheme() throws URISyntaxException {
        URI uri = new URI(null, "5448452043414B452049532041204C4945212121", null);
        OpenPgpV4Fingerprint.fromUri((URI)uri);
    }
}

