/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.Assert;
import org.junit.Test;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.TestUtils;

public class TestKeysTest {
    private final PGPSecretKeyRing julietSecRing = TestKeys.getJulietSecretKeyRing();
    private final PGPSecretKeyRing romeoSecRing = TestKeys.getRomeoSecretKeyRing();
    private final PGPSecretKeyRing emilSecRing = TestKeys.getEmilSecretKeyRing();
    private final PGPPublicKeyRing julietPubRing = TestKeys.getJulietPublicKeyRing();
    private final PGPPublicKeyRing romeoPubRing = TestKeys.getRomeoPublicKeyRing();
    private final PGPPublicKeyRing emilPubRing = TestKeys.getEmilPublicKeyRing();

    @Test
    public void assertJulietsPublicKeyIsSameInPubRingAndSecRing() throws IOException {
        Assert.assertArrayEquals((byte[])this.julietSecRing.getPublicKey().getEncoded(), (byte[])this.julietPubRing.getPublicKey().getEncoded());
    }

    @Test
    public void assertJulietsKeysIdEquals() {
        TestCase.assertEquals((long)-5425419407118114754L, (long)this.julietSecRing.getSecretKey().getKeyID());
        TestCase.assertEquals((long)-5425419407118114754L, (long)this.julietSecRing.getPublicKey().getKeyID());
        TestCase.assertEquals((long)-5425419407118114754L, (long)this.julietPubRing.getPublicKey().getKeyID());
    }

    @Test
    public void assertJulietsKeyUIDEquals() {
        TestCase.assertEquals((String)"xmpp:juliet@capulet.lit", (String)((String)this.julietSecRing.getPublicKey().getUserIDs().next()));
        TestCase.assertEquals((int)1, (int)TestUtils.getNumberOfItemsInIterator(this.julietSecRing.getPublicKey().getUserIDs()));
    }

    @Test
    public void assertJulietsKeyRingFingerprintMatches() {
        TestCase.assertEquals((Object)TestKeys.JULIET_FINGERPRINT, (Object)new OpenPgpV4Fingerprint(this.julietSecRing));
    }

    @Test
    public void assertJulietsPublicKeyFingerprintMatchesHerSecretKeyFingerprint() {
        TestCase.assertEquals((Object)new OpenPgpV4Fingerprint(this.julietSecRing.getPublicKey()), (Object)new OpenPgpV4Fingerprint(this.julietSecRing.getSecretKey()));
    }

    @Test
    public void assertJulietsFingerprintGetKeyIdMatches() {
        TestCase.assertEquals((String)"calling getKeyId() on juliet's fingerprint must return her key id.", (long)-5425419407118114754L, (long)TestKeys.JULIET_FINGERPRINT.getKeyId());
    }

    @Test
    public void assertRomeosPublicKeyIsSameInPubRingAndSecRing() throws IOException {
        Assert.assertArrayEquals((byte[])this.romeoSecRing.getPublicKey().getEncoded(), (byte[])this.romeoPubRing.getPublicKey().getEncoded());
    }

    @Test
    public void assertRomeosKeyIdEquals() {
        TestCase.assertEquals((String)"Key ID of Romeo's secret key must match his key id.", (long)334147643349279223L, (long)this.romeoSecRing.getSecretKey().getKeyID());
    }

    @Test
    public void assertRomeosKeyUIDMatches() {
        TestCase.assertEquals((String)"xmpp:romeo@montague.lit", (String)((String)this.romeoSecRing.getPublicKey().getUserIDs().next()));
    }

    @Test
    public void assertRomeosKeyRingFingerprintMatches() {
        TestCase.assertEquals((Object)TestKeys.ROMEO_FINGERPRINT, (Object)new OpenPgpV4Fingerprint(this.romeoSecRing));
    }

    @Test
    public void assertRomeosPublicKeyFingerprintMatchesHisSecretKeyFingerprint() {
        TestCase.assertEquals((Object)new OpenPgpV4Fingerprint(this.romeoSecRing.getPublicKey()), (Object)new OpenPgpV4Fingerprint(this.romeoSecRing.getSecretKey()));
    }

    @Test
    public void assertRomesKeysFingerprintMatches() {
        TestCase.assertEquals((long)334147643349279223L, (long)TestKeys.ROMEO_FINGERPRINT.getKeyId());
    }

    @Test
    public void assertRomeosSecretKeyRingHasSamePublicKeyId() throws IOException {
        PGPPublicKeyRing julietsPublicKeys = TestKeys.getJulietPublicKeyRing();
        TestCase.assertEquals((long)this.julietSecRing.getPublicKey().getKeyID(), (long)julietsPublicKeys.getPublicKey().getKeyID());
    }

    @Test
    public void assertEmilsPublicKeyIsSameInPubRingAndSecRing() throws IOException {
        Assert.assertArrayEquals((byte[])this.emilSecRing.getPublicKey().getEncoded(), (byte[])this.emilPubRing.getPublicKey().getEncoded());
    }

    @Test
    public void assertEmilsKeysIdEquals() {
        TestCase.assertEquals((long)6284463849526474508L, (long)this.emilSecRing.getSecretKey().getKeyID());
        TestCase.assertEquals((long)6284463849526474508L, (long)this.emilSecRing.getPublicKey().getKeyID());
        TestCase.assertEquals((long)6284463849526474508L, (long)this.emilPubRing.getPublicKey().getKeyID());
    }

    @Test
    public void assertEmilsKeyUIDEquals() {
        TestCase.assertEquals((String)"<emil@email.user>", (String)((String)this.emilSecRing.getPublicKey().getUserIDs().next()));
        TestCase.assertEquals((int)1, (int)TestUtils.getNumberOfItemsInIterator(this.emilSecRing.getPublicKey().getUserIDs()));
    }

    @Test
    public void assertEmilsKeyRingFingerprintMatches() {
        TestCase.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)new OpenPgpV4Fingerprint(this.emilSecRing));
    }

    @Test
    public void assertEmilsPublicKeyFingerprintMatchesHerSecretKeyFingerprint() {
        TestCase.assertEquals((Object)new OpenPgpV4Fingerprint(this.emilSecRing.getPublicKey()), (Object)new OpenPgpV4Fingerprint(this.emilSecRing.getSecretKey()));
    }

    @Test
    public void assertEmilsFingerprintGetKeyIdMatches() {
        TestCase.assertEquals((String)"calling getKeyId() on emil's fingerprint must return her key id.", (long)6284463849526474508L, (long)TestKeys.EMIL_FINGERPRINT.getKeyId());
    }
}

