/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.junit.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.collection.PGPKeyRing;

public class GenerateKeyTest {
    private static final Logger LOGGER = Logger.getLogger(GenerateKeyTest.class.getName());

    @Test
    public void generateKey() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPKeyRing keyRing = PGPainless.generateKeyRing().simpleEcKeyRing("fresh@encrypted.key", "password123");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ArmoredOutputStream armor = new ArmoredOutputStream((OutputStream)bytes);
        keyRing.getPublicKeys().encode((OutputStream)armor);
        armor.close();
        String publicKey = new String(bytes.toByteArray());
        bytes = new ByteArrayOutputStream();
        armor = new ArmoredOutputStream((OutputStream)bytes);
        keyRing.getSecretKeys().encode((OutputStream)armor);
        armor.close();
        String privateKey = new String(bytes.toByteArray());
        LOGGER.log(Level.INFO, String.format("Generated random fresh EC key ring.\nUser-ID: %s\nFingerprint: %s\nKey-ID: %s\n%s\n%s\n", keyRing.getPublicKeys().getPublicKey().getUserIDs().next(), new OpenPgpV4Fingerprint(keyRing.getPublicKeys()), keyRing.getPublicKeys().getPublicKey().getKeyID(), publicKey, privateKey));
    }
}

