/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.junit.Assert;
import org.junit.Test;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class PassphraseProtectedKeyTest {
    private final PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(new KeyRingProtectionSettings(SymmetricKeyAlgorithm.AES_256), new SecretKeyPassphraseProvider(){

        @Nullable
        public Passphrase getPassphraseFor(Long keyId) {
            if (keyId == -821156605394703576L) {
                return new Passphrase("password123".toCharArray());
            }
            return null;
        }
    });

    @Test
    public void testReturnsNonNullDecryptorEncryptorForPassword() throws PGPException {
        Assert.assertNotNull((Object)this.protector.getEncryptor(Long.valueOf(-821156605394703576L)));
        Assert.assertNotNull((Object)this.protector.getDecryptor(Long.valueOf(-821156605394703576L)));
    }

    @Test
    public void testReturnsNullDecryptorEncryptorForNoPassword() throws PGPException {
        Assert.assertNull((Object)this.protector.getEncryptor(Long.valueOf(-5425419407118114754L)));
        Assert.assertNull((Object)this.protector.getDecryptor(Long.valueOf(-5425419407118114754L)));
    }
}

