/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.keyring;

import java.io.IOException;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.junit.Test;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.selection.keyring.impl.Email;

public class EmailKeyRingSelectionStrategyTest {
    Email.PubRingSelectionStrategy pubKeySelectionStrategy = new Email.PubRingSelectionStrategy();
    Email.SecRingSelectionStrategy secKeySelectionStrategy = new Email.SecRingSelectionStrategy();

    @Test
    public void testMatchingEmailUIDAcceptedOnPubKey() throws IOException {
        String uid = "<emil@email.user>";
        PGPPublicKey key = TestKeys.getEmilPublicKeyRing().getPublicKey();
        TestCase.assertTrue((boolean)this.pubKeySelectionStrategy.accept(uid, key));
    }

    @Test
    public void testAddressIsFormattedToMatchOnPubKey() throws IOException {
        String uid = "emil@email.user";
        PGPPublicKey key = TestKeys.getEmilPublicKeyRing().getPublicKey();
        TestCase.assertTrue((boolean)this.pubKeySelectionStrategy.accept(uid, key));
    }

    @Test
    public void testPubKeyWithDifferentUIDIsRejected() throws IOException {
        String wrongUid = "emilia@email.user";
        PGPPublicKey key = TestKeys.getEmilPublicKeyRing().getPublicKey();
        TestCase.assertFalse((boolean)this.pubKeySelectionStrategy.accept(wrongUid, key));
    }

    @Test
    public void testMatchingEmailUIDAcceptedOnSecKey() throws IOException, PGPException {
        String uid = "<emil@email.user>";
        PGPSecretKey key = TestKeys.getEmilSecretKeyRing().getSecretKey();
        TestCase.assertTrue((boolean)this.secKeySelectionStrategy.accept(uid, key));
    }

    @Test
    public void testAddressIsFormattedToMatchOnSecKey() throws IOException, PGPException {
        String uid = "emil@email.user";
        PGPSecretKey key = TestKeys.getEmilSecretKeyRing().getSecretKey();
        TestCase.assertTrue((boolean)this.secKeySelectionStrategy.accept(uid, key));
    }

    @Test
    public void testSecKeyWithDifferentUIDIsRejected() throws IOException, PGPException {
        String wrongUid = "emilia@email.user";
        PGPSecretKey key = TestKeys.getEmilSecretKeyRing().getSecretKey();
        TestCase.assertFalse((boolean)this.secKeySelectionStrategy.accept(wrongUid, key));
    }
}

