/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.keyring;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.Test;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.selection.keyring.impl.Whitelist;

public class WhitelistKeyRingSelectionStrategyTest {
    @Test
    public void testWithPublicKeys() throws IOException {
        ConcurrentHashMap<String, Set<Long>> ids = new ConcurrentHashMap<String, Set<Long>>();
        ids.put("xmpp:juliet@capulet.lit", Collections.singleton(-5425419407118114754L));
        Whitelist.PubRingSelectionStrategy selectionStrategy = new Whitelist.PubRingSelectionStrategy(ids);
        PGPPublicKeyRing julietsKeys = TestKeys.getJulietPublicKeyRing();
        PGPPublicKeyRing romeosKeys = TestKeys.getRomeoPublicKeyRing();
        TestCase.assertTrue((boolean)selectionStrategy.accept((Object)"xmpp:juliet@capulet.lit", julietsKeys));
        TestCase.assertFalse((boolean)selectionStrategy.accept((Object)"xmpp:juliet@capulet.lit", romeosKeys));
        TestCase.assertFalse((boolean)selectionStrategy.accept((Object)"xmpp:romeo@montague.lit", julietsKeys));
    }

    @Test
    public void testWithSecretKeys() throws IOException, PGPException {
        ConcurrentHashMap<String, Set<Long>> ids = new ConcurrentHashMap<String, Set<Long>>();
        ids.put("xmpp:juliet@capulet.lit", Collections.singleton(-5425419407118114754L));
        Whitelist.SecRingSelectionStrategy selectionStrategy = new Whitelist.SecRingSelectionStrategy(ids);
        PGPSecretKeyRing julietsKeys = TestKeys.getJulietSecretKeyRing();
        PGPSecretKeyRing romeosKeys = TestKeys.getRomeoSecretKeyRing();
        TestCase.assertTrue((boolean)selectionStrategy.accept((Object)"xmpp:juliet@capulet.lit", julietsKeys));
        TestCase.assertFalse((boolean)selectionStrategy.accept((Object)"xmpp:juliet@capulet.lit", romeosKeys));
        TestCase.assertFalse((boolean)selectionStrategy.accept((Object)"xmpp:romeo@montague.lit", julietsKeys));
    }
}

