/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.keyring;

import java.io.IOException;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.Test;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.selection.keyring.impl.Wildcard;

public class WildcardKeyRingSelectionStrategyTest {
    Wildcard.PubRingSelectionStrategy<String> pubKeySelectionStrategy = new Wildcard.PubRingSelectionStrategy();
    Wildcard.SecRingSelectionStrategy<String> secKeySelectionStrategy = new Wildcard.SecRingSelectionStrategy();

    @Test
    public void testStratAcceptsMatchingUIDsOnPubKey() throws IOException {
        String uid = "<emil@email.user>";
        PGPPublicKeyRing key = TestKeys.getEmilPublicKeyRing();
        TestCase.assertTrue((boolean)this.pubKeySelectionStrategy.accept((Object)uid, key));
    }

    @Test
    public void testStratAcceptsMismatchingUIDsOnPubKey() throws IOException {
        String uid = "blabla@bla.bla";
        PGPPublicKeyRing key = TestKeys.getEmilPublicKeyRing();
        TestCase.assertTrue((boolean)this.pubKeySelectionStrategy.accept((Object)uid, key));
    }

    @Test
    public void testStratAcceptsMatchingUIDsOnSecKey() throws IOException, PGPException {
        String uid = "<emil@email.user>";
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        TestCase.assertTrue((boolean)this.secKeySelectionStrategy.accept((Object)uid, key));
    }

    @Test
    public void testStratAcceptsMismatchingUIDsOnSecKey() throws IOException, PGPException {
        String uid = "blabla@bla.bla";
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        TestCase.assertTrue((boolean)this.secKeySelectionStrategy.accept((Object)uid, key));
    }
}

