/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.keyring;

import java.io.IOException;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.Test;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.selection.keyring.impl.XMPP;

public class XmppKeyRingSelectionStrategyTest {
    XMPP.PubRingSelectionStrategy pubKeySelectionStrategy = new XMPP.PubRingSelectionStrategy();
    XMPP.SecRingSelectionStrategy secKeySelectionStrategy = new XMPP.SecRingSelectionStrategy();

    @Test
    public void testMatchingXmppUIDAcceptedOnPubKey() throws IOException {
        String uid = "xmpp:juliet@capulet.lit";
        PGPPublicKeyRing key = TestKeys.getJulietPublicKeyRing();
        TestCase.assertTrue((boolean)this.pubKeySelectionStrategy.accept(uid, key));
    }

    @Test
    public void testAddressIsFormattedToMatchOnPubKey() throws IOException {
        String uid = "juliet@capulet.lit";
        PGPPublicKeyRing key = TestKeys.getJulietPublicKeyRing();
        TestCase.assertTrue((boolean)this.pubKeySelectionStrategy.accept(uid, key));
    }

    @Test
    public void testPubKeyWithDifferentUIDIsRejected() throws IOException {
        String wrongUid = "romeo@montague.lit";
        PGPPublicKeyRing key = TestKeys.getJulietPublicKeyRing();
        TestCase.assertFalse((boolean)this.pubKeySelectionStrategy.accept(wrongUid, key));
    }

    @Test
    public void testMatchingEmailUIDAcceptedOnSecKey() throws IOException, PGPException {
        String uid = "xmpp:juliet@capulet.lit";
        PGPSecretKeyRing key = TestKeys.getJulietSecretKeyRing();
        TestCase.assertTrue((boolean)this.secKeySelectionStrategy.accept(uid, key));
    }

    @Test
    public void testAddressIsFormattedToMatchOnSecKey() throws IOException, PGPException {
        String uid = "juliet@capulet.lit";
        PGPSecretKeyRing key = TestKeys.getJulietSecretKeyRing();
        TestCase.assertTrue((boolean)this.secKeySelectionStrategy.accept(uid, key));
    }

    @Test
    public void testSecKeyWithDifferentUIDIsRejected() throws IOException, PGPException {
        String wrongUid = "romeo@montague.lit";
        PGPSecretKeyRing key = TestKeys.getJulietSecretKeyRing();
        TestCase.assertFalse((boolean)this.secKeySelectionStrategy.accept(wrongUid, key));
    }
}

