/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.junit.Assert;
import org.junit.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.collection.PGPKeyRing;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.RSA_GENERAL;
import org.pgpainless.key.generation.type.length.RsaLength;
import org.pgpainless.util.BCUtil;

public class BCUtilTest {
    private static final Logger LOGGER = Logger.getLogger(BCUtil.class.getName());

    @Test
    public void keyRingToCollectionTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPKeyRing ring = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)RSA_GENERAL.withLength((RsaLength)RsaLength._3072)).withDefaultKeyFlags().withDefaultAlgorithms()).withMasterKey(KeySpec.getBuilder((KeyType)RSA_GENERAL.withLength((RsaLength)RsaLength._3072)).withDefaultKeyFlags().withDefaultAlgorithms()).withPrimaryUserId("donald@duck.tails").withoutPassphrase().build();
        PGPSecretKeyRing sec = ring.getSecretKeys();
        PGPPublicKeyRing pub = ring.getPublicKeys();
        LOGGER.log(Level.FINER, "Main ID: " + sec.getPublicKey().getKeyID() + " " + pub.getPublicKey().getKeyID());
        int secSize = 1;
        Iterator secPubIt = sec.getPublicKeys();
        while (secPubIt.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)secPubIt.next();
            LOGGER.log(Level.FINER, secSize + " " + k.getKeyID() + " " + k.isEncryptionKey() + " " + k.isMasterKey());
            ++secSize;
        }
        LOGGER.log(Level.FINER, "After BCUtil.publicKeyRingFromSecretKeyRing()");
        int pubSize = 1;
        Iterator pubPubIt = pub.getPublicKeys();
        while (pubPubIt.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)pubPubIt.next();
            LOGGER.log(Level.FINER, pubSize + " " + k.getKeyID() + " " + k.isEncryptionKey() + " " + k.isMasterKey());
            ++pubSize;
        }
        TestCase.assertEquals((int)secSize, (int)pubSize);
        PGPSecretKeyRingCollection secCol = BCUtil.keyRingsToKeyRingCollection((PGPSecretKeyRing[])new PGPSecretKeyRing[]{sec});
        int secColSize = 0;
        Iterator secColIt = secCol.getKeyRings();
        while (secColIt.hasNext()) {
            PGPSecretKeyRing r = (PGPSecretKeyRing)secColIt.next();
            LOGGER.log(Level.FINER, "" + r.getPublicKey().getKeyID());
            ++secColSize;
        }
        LOGGER.log(Level.FINER, "SecCol: " + secColSize);
        PGPPublicKeyRingCollection pubCol = BCUtil.keyRingsToKeyRingCollection((PGPPublicKeyRing[])new PGPPublicKeyRing[]{pub});
        int pubColSize = 0;
        Iterator pubColIt = pubCol.getKeyRings();
        while (pubColIt.hasNext()) {
            PGPPublicKeyRing r = (PGPPublicKeyRing)pubColIt.next();
            LOGGER.log(Level.FINER, "" + r.getPublicKey().getKeyID());
            ++pubColSize;
        }
        LOGGER.log(Level.FINER, "PubCol: " + pubColSize);
    }

    @Test
    public void removeUnsignedKeysTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        PGPKeyRing alice = PGPainless.generateKeyRing().simpleRsaKeyRing("alice@wonderland.lit", RsaLength._1024);
        PGPKeyRing mallory = PGPainless.generateKeyRing().simpleEcKeyRing("mallory@mall.ory");
        PGPSecretKey subKey = null;
        Iterator sit = mallory.getSecretKeys().getSecretKeys();
        while (sit.hasNext()) {
            PGPSecretKey s = (PGPSecretKey)sit.next();
            if (s.isMasterKey()) continue;
            subKey = s;
            break;
        }
        TestCase.assertNotNull(subKey);
        PGPSecretKeyRing alice_mallory = PGPSecretKeyRing.insertSecretKey((PGPSecretKeyRing)alice.getSecretKeys(), subKey);
        TestCase.assertNotNull((Object)alice_mallory.getSecretKey(subKey.getKeyID()));
        PGPSecretKeyRing cleaned = BCUtil.removeUnassociatedKeysFromKeyRing((PGPSecretKeyRing)alice_mallory, (PGPPublicKey)alice.getPublicKeys().getPublicKey());
        TestCase.assertNull((Object)cleaned.getSecretKey(subKey.getKeyID()));
    }

    @Test
    public void removeUnsignedKeysECTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException {
        PGPKeyRing ring = PGPainless.generateKeyRing().simpleEcKeyRing("alice@wonderland.lit");
        PGPPublicKeyRing publicKeys = ring.getPublicKeys();
        PGPSecretKeyRing secretKeys = ring.getSecretKeys();
        PGPSecretKeyRing secCleaned = ring.getSecretKeys();
        Assert.assertArrayEquals((byte[])secretKeys.getEncoded(), (byte[])secCleaned.getEncoded());
        PGPPublicKeyRing pubCleaned = BCUtil.removeUnassociatedKeysFromKeyRing((PGPPublicKeyRing)publicKeys, (PGPPublicKey)publicKeys.getPublicKey());
        Assert.assertArrayEquals((byte[])publicKeys.getEncoded(), (byte[])pubCleaned.getEncoded());
    }
}

