/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.pgpainless.util.MultiMap;

public class MultiMapTest {
    @Test
    public void test() {
        MultiMap multiMap = new MultiMap();
        TestCase.assertTrue((boolean)multiMap.isEmpty());
        TestCase.assertNull((Object)multiMap.get((Object)"alice"));
        TestCase.assertFalse((boolean)multiMap.containsKey((Object)"alice"));
        TestCase.assertFalse((boolean)multiMap.containsValue((Object)"wonderland"));
        TestCase.assertEquals((int)0, (int)multiMap.size());
        multiMap.put((Object)"alice", (Object)"wonderland");
        TestCase.assertFalse((boolean)multiMap.isEmpty());
        TestCase.assertEquals((int)1, (int)multiMap.size());
        TestCase.assertTrue((boolean)multiMap.containsKey((Object)"alice"));
        TestCase.assertTrue((boolean)multiMap.containsValue((Object)"wonderland"));
        TestCase.assertNotNull((Object)multiMap.get((Object)"alice"));
        TestCase.assertTrue((boolean)multiMap.get((Object)"alice").contains("wonderland"));
        multiMap.put((Object)"mad", new HashSet<String>(Arrays.asList("hatter", "max")));
        TestCase.assertEquals(new HashSet<String>(Arrays.asList("hatter", "max")), (Object)multiMap.get((Object)"mad"));
        TestCase.assertEquals(new HashSet<String>(Arrays.asList("mad", "alice")), (Object)multiMap.keySet());
        TestCase.assertEquals(new HashSet<Set>(Arrays.asList(Collections.singleton("wonderland"), new HashSet<String>(Arrays.asList("hatter", "max")))), new HashSet(multiMap.values()));
        Set entries = multiMap.entrySet();
        TestCase.assertEquals((int)2, (int)entries.size());
        block8: for (Map.Entry e : entries) {
            switch ((String)e.getKey()) {
                case "alice": {
                    TestCase.assertEquals((int)1, (int)((Set)e.getValue()).size());
                    TestCase.assertTrue((boolean)((Set)e.getValue()).contains("wonderland"));
                    continue block8;
                }
                case "mad": {
                    TestCase.assertEquals((int)2, (int)((Set)e.getValue()).size());
                    TestCase.assertTrue((boolean)((Set)e.getValue()).contains("hatter"));
                    TestCase.assertTrue((boolean)((Set)e.getValue()).contains("max"));
                    continue block8;
                }
            }
            TestCase.fail((String)"Illegal key.");
        }
        MultiMap empty = new MultiMap();
        Assert.assertNotEquals((Object)multiMap, (Object)empty);
        TestCase.assertEquals((Object)multiMap, (Object)multiMap);
        Assert.assertNotEquals(null, (Object)multiMap);
        MultiMap map2 = new MultiMap();
        map2.put((Object)"alice", (Object)"schwarzer");
        map2.put((Object)"dr", (Object)"strange");
        multiMap.putAll(map2);
        TestCase.assertTrue((boolean)multiMap.containsKey((Object)"dr"));
        TestCase.assertEquals((int)1, (int)multiMap.get((Object)"dr").size());
        TestCase.assertTrue((boolean)multiMap.get((Object)"dr").contains("strange"));
        TestCase.assertTrue((boolean)multiMap.containsKey((Object)"mad"));
        TestCase.assertEquals((int)2, (int)multiMap.get((Object)"alice").size());
        TestCase.assertTrue((boolean)multiMap.get((Object)"alice").contains("wonderland"));
        TestCase.assertTrue((boolean)multiMap.get((Object)"alice").contains("schwarzer"));
        multiMap.removeAll((Object)"mad");
        TestCase.assertFalse((boolean)multiMap.containsKey((Object)"mad"));
        TestCase.assertNull((Object)multiMap.get((Object)"mad"));
        multiMap.remove((Object)"alice", (Object)"wonderland");
        TestCase.assertFalse((boolean)multiMap.containsValue((Object)"wonderland"));
        TestCase.assertTrue((boolean)multiMap.containsKey((Object)"alice"));
        TestCase.assertEquals((int)1, (int)multiMap.get((Object)"alice").size());
        TestCase.assertTrue((boolean)multiMap.get((Object)"alice").contains("schwarzer"));
        MultiMap copy = new MultiMap(multiMap);
        TestCase.assertEquals((Object)multiMap, (Object)copy);
        copy.removeAll((Object)"inexistent");
        TestCase.assertEquals((Object)multiMap, (Object)copy);
        copy.remove((Object)"inexistent", (Object)"schwarzer");
        TestCase.assertEquals((Object)multiMap, (Object)copy);
        TestCase.assertEquals((int)multiMap.hashCode(), (int)copy.hashCode());
        copy.clear();
        TestCase.assertTrue((boolean)copy.isEmpty());
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("key", Collections.singleton("value"));
        MultiMap fromMap = new MultiMap(map);
        TestCase.assertFalse((boolean)fromMap.isEmpty());
        TestCase.assertEquals((Object)fromMap.get((Object)"key"), Collections.singleton("value"));
        Assert.assertNotEquals((Object)fromMap, map);
    }
}

