/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

public class AlgorithmSuite {
    private static AlgorithmSuite defaultAlgorithmSuite = new AlgorithmSuite(Arrays.asList(SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128), Arrays.asList(HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224), Arrays.asList(CompressionAlgorithm.ZLIB, CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZIP, CompressionAlgorithm.UNCOMPRESSED));
    private List<SymmetricKeyAlgorithm> symmetricKeyAlgorithms;
    private List<HashAlgorithm> hashAlgorithms;
    private List<CompressionAlgorithm> compressionAlgorithms;

    public AlgorithmSuite(List<SymmetricKeyAlgorithm> symmetricKeyAlgorithms, List<HashAlgorithm> hashAlgorithms, List<CompressionAlgorithm> compressionAlgorithms) {
        this.symmetricKeyAlgorithms = Collections.unmodifiableList(symmetricKeyAlgorithms);
        this.hashAlgorithms = Collections.unmodifiableList(hashAlgorithms);
        this.compressionAlgorithms = Collections.unmodifiableList(compressionAlgorithms);
    }

    public void setSymmetricKeyAlgorithms(List<SymmetricKeyAlgorithm> symmetricKeyAlgorithms) {
        this.symmetricKeyAlgorithms = symmetricKeyAlgorithms;
    }

    public List<SymmetricKeyAlgorithm> getSymmetricKeyAlgorithms() {
        return new ArrayList<SymmetricKeyAlgorithm>(this.symmetricKeyAlgorithms);
    }

    public int[] getSymmetricKeyAlgorithmIds() {
        int[] array = new int[this.symmetricKeyAlgorithms.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.symmetricKeyAlgorithms.get(i).getAlgorithmId();
        }
        return array;
    }

    public void setHashAlgorithms(List<HashAlgorithm> hashAlgorithms) {
        this.hashAlgorithms = hashAlgorithms;
    }

    public List<HashAlgorithm> getHashAlgorithms() {
        return this.hashAlgorithms;
    }

    public int[] getHashAlgorithmIds() {
        int[] array = new int[this.hashAlgorithms.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.hashAlgorithms.get(i).getAlgorithmId();
        }
        return array;
    }

    public void setCompressionAlgorithms(List<CompressionAlgorithm> compressionAlgorithms) {
        this.compressionAlgorithms = compressionAlgorithms;
    }

    public List<CompressionAlgorithm> getCompressionAlgorithms() {
        return this.compressionAlgorithms;
    }

    public int[] getCompressionAlgorithmIds() {
        int[] array = new int[this.compressionAlgorithms.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.compressionAlgorithms.get(i).getAlgorithmId();
        }
        return array;
    }

    public static AlgorithmSuite getDefaultAlgorithmSuite() {
        return defaultAlgorithmSuite;
    }
}

