/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public interface DecryptionBuilderInterface {
    public DecryptWith onInputStream(@Nonnull InputStream var1);

    public static interface Build {
        public DecryptionStream build() throws IOException, PGPException;
    }

    public static interface HandleMissingPublicKeys {
        public Build handleMissingPublicKeysWith(@Nonnull MissingPublicKeyCallback var1);

        public Build ignoreMissingPublicKeys();
    }

    public static interface VerifyWith {
        public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRingCollection var1);

        default public HandleMissingPublicKeys verifyWith(@Nonnull OpenPgpV4Fingerprint trustedFingerprint, @Nonnull PGPPublicKeyRingCollection publicKeyRings) {
            return this.verifyWith(Collections.singleton(trustedFingerprint), publicKeyRings);
        }

        public HandleMissingPublicKeys verifyWith(@Nonnull Set<OpenPgpV4Fingerprint> var1, @Nonnull PGPPublicKeyRingCollection var2);

        default public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRing publicKeyRing) {
            return this.verifyWith(Collections.singleton(publicKeyRing));
        }

        public HandleMissingPublicKeys verifyWith(@Nonnull Set<PGPPublicKeyRing> var1);
    }

    public static interface Verify
    extends VerifyWith {
        @Override
        public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRingCollection var1);

        @Override
        default public HandleMissingPublicKeys verifyWith(@Nonnull OpenPgpV4Fingerprint trustedFingerprint, @Nonnull PGPPublicKeyRingCollection publicKeyRings) {
            return this.verifyWith(Collections.singleton(trustedFingerprint), publicKeyRings);
        }

        @Override
        public HandleMissingPublicKeys verifyWith(@Nonnull Set<OpenPgpV4Fingerprint> var1, @Nonnull PGPPublicKeyRingCollection var2);

        @Override
        default public HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRing publicKeyRing) {
            return this.verifyWith(Collections.singleton(publicKeyRing));
        }

        @Override
        public HandleMissingPublicKeys verifyWith(@Nonnull Set<PGPPublicKeyRing> var1);

        default public VerifyWith verifyDetachedSignature(@Nonnull byte[] bytes) throws IOException, PGPException {
            return this.verifyDetachedSignature(new ByteArrayInputStream(bytes));
        }

        public VerifyWith verifyDetachedSignature(@Nonnull InputStream var1) throws IOException, PGPException;

        default public VerifyWith verifyDetachedSignature(@Nonnull PGPSignature signature) {
            return this.verifyDetachedSignatures(Collections.singletonList(signature));
        }

        public VerifyWith verifyDetachedSignatures(@Nonnull List<PGPSignature> var1);

        public Build doNotVerify();
    }

    public static interface DecryptWith {
        default public Verify decryptWith(@Nonnull PGPSecretKeyRingCollection secretKeyRings) {
            return this.decryptWith(new UnprotectedKeysProtector(), secretKeyRings);
        }

        public Verify decryptWith(@Nonnull SecretKeyRingProtector var1, @Nonnull PGPSecretKeyRingCollection var2);

        public Verify doNotDecrypt();
    }
}

