/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.exception.SecretKeyNotFoundException;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.selection.key.PublicKeySelectionStrategy;
import org.pgpainless.key.selection.key.SecretKeySelectionStrategy;
import org.pgpainless.key.selection.key.impl.EncryptionKeySelectionStrategy;
import org.pgpainless.key.selection.key.impl.NoRevocation;
import org.pgpainless.key.selection.key.impl.SignatureKeySelectionStrategy;
import org.pgpainless.key.selection.key.util.And;
import org.pgpainless.key.selection.keyring.PublicKeyRingSelectionStrategy;
import org.pgpainless.key.selection.keyring.SecretKeyRingSelectionStrategy;
import org.pgpainless.util.MultiMap;

public class EncryptionBuilder
implements EncryptionBuilderInterface {
    private OutputStream outputStream;
    private final Set<PGPPublicKey> encryptionKeys = new HashSet<PGPPublicKey>();
    private boolean detachedSignature = false;
    private final Set<PGPSecretKey> signingKeys = new HashSet<PGPSecretKey>();
    private SecretKeyRingProtector signingKeysDecryptor;
    private SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.AES_128;
    private HashAlgorithm hashAlgorithm = HashAlgorithm.SHA256;
    private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
    private boolean asciiArmor = false;

    @Override
    public EncryptionBuilderInterface.ToRecipients onOutputStream(@Nonnull OutputStream outputStream) {
        this.outputStream = outputStream;
        return new ToRecipientsImpl();
    }

    <O> PublicKeySelectionStrategy<O> encryptionKeySelector() {
        return new And.PubKeySelectionStrategy(new NoRevocation.PubKeySelectionStrategy(), new EncryptionKeySelectionStrategy());
    }

    <O> SecretKeySelectionStrategy<O> signingKeySelector() {
        return new And.SecKeySelectionStrategy(new NoRevocation.SecKeySelectionStrategy(), new SignatureKeySelectionStrategy());
    }

    class ArmorImpl
    implements EncryptionBuilderInterface.Armor {
        ArmorImpl() {
        }

        @Override
        public EncryptionStream asciiArmor() throws IOException, PGPException {
            EncryptionBuilder.this.asciiArmor = true;
            return this.build();
        }

        @Override
        public EncryptionStream noArmor() throws IOException, PGPException {
            EncryptionBuilder.this.asciiArmor = false;
            return this.build();
        }

        private EncryptionStream build() throws IOException, PGPException {
            ConcurrentHashMap<OpenPgpV4Fingerprint, PGPPrivateKey> privateKeys = new ConcurrentHashMap<OpenPgpV4Fingerprint, PGPPrivateKey>();
            for (PGPSecretKey secretKey : EncryptionBuilder.this.signingKeys) {
                PBESecretKeyDecryptor decryptor = EncryptionBuilder.this.signingKeysDecryptor.getDecryptor(secretKey.getKeyID());
                PGPPrivateKey privateKey = secretKey.extractPrivateKey(decryptor);
                privateKeys.put(new OpenPgpV4Fingerprint(secretKey), privateKey);
            }
            return new EncryptionStream(EncryptionBuilder.this.outputStream, EncryptionBuilder.this.encryptionKeys, EncryptionBuilder.this.detachedSignature, privateKeys, EncryptionBuilder.this.symmetricKeyAlgorithm, EncryptionBuilder.this.hashAlgorithm, EncryptionBuilder.this.compressionAlgorithm, EncryptionBuilder.this.asciiArmor);
        }
    }

    class SignWithImpl
    implements EncryptionBuilderInterface.SignWith {
        SignWithImpl() {
        }

        @Override
        public EncryptionBuilderInterface.Armor signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKey ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPSecretKey s : keys) {
                if (!EncryptionBuilder.this.signingKeySelector().accept(null, s)) {
                    throw new IllegalArgumentException("Key " + s.getKeyID() + " is not a valid signing key.");
                }
                EncryptionBuilder.this.signingKeys.add(s);
            }
            EncryptionBuilder.this.signingKeysDecryptor = decryptor;
            return new ArmorImpl();
        }

        @Override
        public EncryptionBuilderInterface.Armor signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKeyRing ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPSecretKeyRing key : keys) {
                Iterator i = key.getSecretKeys();
                while (i.hasNext()) {
                    PGPSecretKey s = (PGPSecretKey)i.next();
                    if (!EncryptionBuilder.this.signingKeySelector().accept(null, s)) continue;
                    EncryptionBuilder.this.signingKeys.add(s);
                }
            }
            EncryptionBuilder.this.signingKeysDecryptor = decryptor;
            return new ArmorImpl();
        }

        @Override
        public <O> EncryptionBuilderInterface.Armor signWith(@Nonnull SecretKeyRingSelectionStrategy<O> ringSelectionStrategy, @Nonnull SecretKeyRingProtector decryptor, @Nonnull MultiMap<O, PGPSecretKeyRingCollection> keys) {
            if (keys.isEmpty()) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            MultiMap<O, PGPSecretKeyRing> acceptedKeyRings = ringSelectionStrategy.selectKeyRingsFromCollections(keys);
            for (O identifier : acceptedKeyRings.keySet()) {
                Set<PGPSecretKeyRing> acceptedSet = acceptedKeyRings.get(identifier);
                for (PGPSecretKeyRing k : acceptedSet) {
                    Iterator i = k.getSecretKeys();
                    while (i.hasNext()) {
                        PGPSecretKey s = (PGPSecretKey)i.next();
                        if (!EncryptionBuilder.this.signingKeySelector().accept(null, s)) continue;
                        EncryptionBuilder.this.signingKeys.add(s);
                    }
                }
            }
            return new ArmorImpl();
        }
    }

    class DetachedSignImpl
    implements EncryptionBuilderInterface.DetachedSign {
        DetachedSignImpl() {
        }

        @Override
        public EncryptionBuilderInterface.SignWith createDetachedSignature() {
            EncryptionBuilder.this.detachedSignature = true;
            return new SignWithImpl();
        }

        @Override
        public EncryptionBuilderInterface.Armor doNotSign() {
            return new ArmorImpl();
        }

        @Override
        public EncryptionBuilderInterface.Armor signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKey ... keys) {
            return new SignWithImpl().signWith(decryptor, keys);
        }

        @Override
        public EncryptionBuilderInterface.Armor signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKeyRing ... keyRings) {
            return new SignWithImpl().signWith(decryptor, keyRings);
        }

        @Override
        public <O> EncryptionBuilderInterface.Armor signWith(@Nonnull SecretKeyRingSelectionStrategy<O> selectionStrategy, @Nonnull SecretKeyRingProtector decryptor, @Nonnull MultiMap<O, PGPSecretKeyRingCollection> keys) throws SecretKeyNotFoundException {
            return new SignWithImpl().signWith(selectionStrategy, decryptor, keys);
        }
    }

    class WithAlgorithmsImpl
    implements EncryptionBuilderInterface.WithAlgorithms {
        WithAlgorithmsImpl() {
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms andToSelf(PGPPublicKey ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPPublicKey k : keys) {
                if (!EncryptionBuilder.this.encryptionKeySelector().accept(null, k)) {
                    throw new IllegalArgumentException("Key " + k.getKeyID() + " is not a valid encryption key.");
                }
                EncryptionBuilder.this.encryptionKeys.add(k);
            }
            return this;
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms andToSelf(PGPPublicKeyRing ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPPublicKeyRing ring : keys) {
                Iterator i = ring.getPublicKeys();
                while (i.hasNext()) {
                    PGPPublicKey key = (PGPPublicKey)i.next();
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(null, key)) continue;
                    EncryptionBuilder.this.encryptionKeys.add(key);
                }
            }
            return this;
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms andToSelf(@Nonnull PGPPublicKeyRingCollection keys) {
            for (PGPPublicKeyRing ring : keys) {
                Iterator i = ring.getPublicKeys();
                while (i.hasNext()) {
                    PGPPublicKey key = (PGPPublicKey)i.next();
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(null, key)) continue;
                    EncryptionBuilder.this.encryptionKeys.add(key);
                }
            }
            return this;
        }

        @Override
        public <O> EncryptionBuilderInterface.WithAlgorithms andToSelf(@Nonnull PublicKeyRingSelectionStrategy<O> ringSelectionStrategy, @Nonnull MultiMap<O, PGPPublicKeyRingCollection> keys) {
            if (keys.isEmpty()) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            MultiMap<O, PGPPublicKeyRing> acceptedKeyRings = ringSelectionStrategy.selectKeyRingsFromCollections(keys);
            for (O identifier : acceptedKeyRings.keySet()) {
                Set<PGPPublicKeyRing> acceptedSet = acceptedKeyRings.get(identifier);
                for (PGPPublicKeyRing k : acceptedSet) {
                    Iterator i = k.getPublicKeys();
                    while (i.hasNext()) {
                        PGPPublicKey key = (PGPPublicKey)i.next();
                        if (!EncryptionBuilder.this.encryptionKeySelector().accept(null, key)) continue;
                        EncryptionBuilder.this.encryptionKeys.add(key);
                    }
                }
            }
            return this;
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign usingAlgorithms(@Nonnull SymmetricKeyAlgorithm symmetricKeyAlgorithm, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull CompressionAlgorithm compressionAlgorithm) {
            EncryptionBuilder.this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
            EncryptionBuilder.this.hashAlgorithm = hashAlgorithm;
            EncryptionBuilder.this.compressionAlgorithm = compressionAlgorithm;
            return new DetachedSignImpl();
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign usingSecureAlgorithms() {
            EncryptionBuilder.this.symmetricKeyAlgorithm = SymmetricKeyAlgorithm.AES_256;
            EncryptionBuilder.this.hashAlgorithm = HashAlgorithm.SHA512;
            EncryptionBuilder.this.compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
            return new DetachedSignImpl();
        }
    }

    class ToRecipientsImpl
    implements EncryptionBuilderInterface.ToRecipients {
        ToRecipientsImpl() {
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms toRecipients(PGPPublicKey ... keys) {
            for (PGPPublicKey k : keys) {
                if (!EncryptionBuilder.this.encryptionKeySelector().accept(null, k)) {
                    throw new IllegalArgumentException("Key " + k.getKeyID() + " is not a valid encryption key.");
                }
                EncryptionBuilder.this.encryptionKeys.add(k);
            }
            if (EncryptionBuilder.this.encryptionKeys.isEmpty()) {
                throw new IllegalStateException("No valid encryption keys found!");
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms toRecipients(PGPPublicKeyRing ... keys) {
            for (PGPPublicKeyRing ring : keys) {
                for (PGPPublicKey k : ring) {
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(null, k)) continue;
                    EncryptionBuilder.this.encryptionKeys.add(k);
                }
            }
            if (EncryptionBuilder.this.encryptionKeys.isEmpty()) {
                throw new IllegalStateException("No valid encryption keys found!");
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms toRecipients(PGPPublicKeyRingCollection ... keys) {
            for (PGPPublicKeyRingCollection collection : keys) {
                for (PGPPublicKeyRing ring : collection) {
                    for (PGPPublicKey k : ring) {
                        if (!EncryptionBuilder.this.encryptionKeySelector().accept(null, k)) continue;
                        EncryptionBuilder.this.encryptionKeys.add(k);
                    }
                }
            }
            if (EncryptionBuilder.this.encryptionKeys.isEmpty()) {
                throw new IllegalStateException("No valid encryption keys found!");
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public <O> EncryptionBuilderInterface.WithAlgorithms toRecipients(@Nonnull PublicKeyRingSelectionStrategy<O> ringSelectionStrategy, @Nonnull MultiMap<O, PGPPublicKeyRingCollection> keys) {
            if (keys.isEmpty()) {
                throw new IllegalArgumentException("Recipient map MUST NOT be empty.");
            }
            MultiMap<O, PGPPublicKeyRing> acceptedKeyRings = ringSelectionStrategy.selectKeyRingsFromCollections(keys);
            for (O identifier : acceptedKeyRings.keySet()) {
                Set<PGPPublicKeyRing> acceptedSet = acceptedKeyRings.get(identifier);
                for (PGPPublicKeyRing ring : acceptedSet) {
                    for (PGPPublicKey k : ring) {
                        if (!EncryptionBuilder.this.encryptionKeySelector().accept(null, k)) continue;
                        EncryptionBuilder.this.encryptionKeys.add(k);
                    }
                }
            }
            if (EncryptionBuilder.this.encryptionKeys.isEmpty()) {
                throw new IllegalStateException("No valid encryption keys found!");
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign doNotEncrypt() {
            return new DetachedSignImpl();
        }
    }
}

