/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.pgpainless.key.generation.KeySpecBuilder;
import org.pgpainless.key.generation.type.KeyType;

public class KeySpec {
    private final KeyType keyType;
    private final PGPSignatureSubpacketGenerator subpacketGenerator;
    private final boolean inheritedSubPackets;

    KeySpec(@Nonnull KeyType type, @Nullable PGPSignatureSubpacketGenerator subpacketGenerator, boolean inheritedSubPackets) {
        this.keyType = type;
        this.subpacketGenerator = subpacketGenerator;
        this.inheritedSubPackets = inheritedSubPackets;
    }

    @Nonnull
    KeyType getKeyType() {
        return this.keyType;
    }

    @Nullable
    PGPSignatureSubpacketVector getSubpackets() {
        return this.subpacketGenerator != null ? this.subpacketGenerator.generate() : null;
    }

    boolean isInheritedSubPackets() {
        return this.inheritedSubPackets;
    }

    public static KeySpecBuilder getBuilder(KeyType type) {
        return new KeySpecBuilder(type);
    }
}

