/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type;

import java.security.spec.AlgorithmParameterSpec;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.ECDH;
import org.pgpainless.key.generation.type.ECDSA;
import org.pgpainless.key.generation.type.RSA;
import org.pgpainless.key.generation.type.curve.EllipticCurve;
import org.pgpainless.key.generation.type.length.RsaLength;

public interface KeyType {
    public String getName();

    public PublicKeyAlgorithm getAlgorithm();

    public AlgorithmParameterSpec getAlgorithmSpec();

    public static KeyType RSA(RsaLength length) {
        return RSA.withLength(length);
    }

    public static KeyType ECDH(EllipticCurve curve) {
        return ECDH.fromCurve(curve);
    }

    public static KeyType ECDSA(EllipticCurve curve) {
        return ECDSA.fromCurve(curve);
    }
}

