/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification.secretkeyring;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PassphraseMapKeyRingProtector;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.protection.passphrase_provider.SolitaryPassphraseProvider;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.key.util.SignatureUtils;
import org.pgpainless.util.Passphrase;

public class SecretKeyRingEditor
implements SecretKeyRingEditorInterface {
    private final HashAlgorithm defaultDigestHashAlgorithm = HashAlgorithm.SHA1;
    private PGPSecretKeyRing secretKeyRing;

    public SecretKeyRingEditor(PGPSecretKeyRing secretKeyRing) {
        if (secretKeyRing == null) {
            throw new NullPointerException("SecretKeyRing MUST NOT be null.");
        }
        this.secretKeyRing = secretKeyRing;
    }

    @Override
    public SecretKeyRingEditorInterface addUserId(String userId, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.addUserId(this.secretKeyRing.getPublicKey().getKeyID(), userId, secretKeyRingProtector);
    }

    @Override
    public SecretKeyRingEditorInterface addUserId(long keyId, String userId, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        userId = this.sanitizeUserId(userId);
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        Iterator secretKeyIterator = this.secretKeyRing.getSecretKeys();
        boolean found = false;
        while (!found && secretKeyIterator.hasNext()) {
            PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
            if (secretKey.getKeyID() == keyId) {
                found = true;
                PGPPublicKey publicKey = secretKey.getPublicKey();
                PGPPrivateKey privateKey = KeyRingUtils.unlockSecretKey(secretKey, secretKeyRingProtector);
                publicKey = SecretKeyRingEditor.addUserIdToPubKey(userId, privateKey, publicKey);
                secretKey = PGPSecretKey.replacePublicKey((PGPSecretKey)secretKey, (PGPPublicKey)publicKey);
            }
            secretKeyList.add(secretKey);
        }
        if (!found) {
            throw new NoSuchElementException("Cannot find secret key with id " + Long.toHexString(keyId));
        }
        this.secretKeyRing = new PGPSecretKeyRing(secretKeyList);
        return this;
    }

    private static PGPPublicKey addUserIdToPubKey(String userId, PGPPrivateKey privateKey, PGPPublicKey publicKey) throws PGPException {
        if (privateKey.getKeyID() != publicKey.getKeyID()) {
            throw new IllegalArgumentException("Key-ID mismatch!");
        }
        PGPSignatureGenerator signatureGenerator = SignatureUtils.getSignatureGeneratorFor(publicKey);
        signatureGenerator.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), privateKey);
        PGPSignature userIdSignature = signatureGenerator.generateCertification(userId, publicKey);
        publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (String)userId, (PGPSignature)userIdSignature);
        return publicKey;
    }

    private String sanitizeUserId(String userId) {
        userId = userId.trim();
        return userId;
    }

    @Override
    public SecretKeyRingEditorInterface deleteUserId(String userId, SecretKeyRingProtector protector) {
        PGPPublicKey publicKey = this.secretKeyRing.getPublicKey();
        return this.deleteUserId(publicKey.getKeyID(), userId, protector);
    }

    @Override
    public SecretKeyRingEditorInterface deleteUserId(long keyId, String userId, SecretKeyRingProtector secretKeyRingProtector) {
        ArrayList<PGPPublicKey> publicKeys = new ArrayList<PGPPublicKey>();
        Iterator publicKeyIterator = this.secretKeyRing.getPublicKeys();
        boolean foundKey = false;
        while (publicKeyIterator.hasNext()) {
            PGPPublicKey publicKey = (PGPPublicKey)publicKeyIterator.next();
            if (publicKey.getKeyID() == keyId) {
                foundKey = true;
                if (!SecretKeyRingEditor.hasUserId(userId, publicKey)) {
                    throw new NoSuchElementException("Key " + Long.toHexString(keyId) + " does not have a user-id attribute of value '" + userId + "'");
                }
                publicKey = PGPPublicKey.removeCertification((PGPPublicKey)publicKey, (String)userId);
            }
            publicKeys.add(publicKey);
        }
        if (!foundKey) {
            throw new NoSuchElementException("Cannot find public key with id " + Long.toHexString(keyId));
        }
        PGPPublicKeyRing publicKeyRing = new PGPPublicKeyRing(publicKeys);
        this.secretKeyRing = PGPSecretKeyRing.replacePublicKeys((PGPSecretKeyRing)this.secretKeyRing, (PGPPublicKeyRing)publicKeyRing);
        return this;
    }

    private static boolean hasUserId(String userId, PGPPublicKey publicKey) {
        boolean hasUserId = false;
        Iterator userIdIterator = publicKey.getUserIDs();
        while (userIdIterator.hasNext() && !(hasUserId = userId.equals(userIdIterator.next()))) {
        }
        return hasUserId;
    }

    @Override
    public SecretKeyRingEditorInterface addSubKey(@Nonnull KeySpec keySpec, @Nonnull Passphrase subKeyPassphrase, SecretKeyRingProtector secretKeyRingProtector) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKey secretSubKey = this.generateSubKey(keySpec, subKeyPassphrase);
        PasswordBasedSecretKeyRingProtector subKeyProtector = PasswordBasedSecretKeyRingProtector.forKey(secretSubKey, subKeyPassphrase);
        return this.addSubKey(secretSubKey, subKeyProtector, secretKeyRingProtector);
    }

    @Override
    public SecretKeyRingEditorInterface addSubKey(PGPSecretKey secretSubKey, SecretKeyRingProtector subKeyProtector, SecretKeyRingProtector keyRingProtector) throws PGPException {
        PGPPublicKey primaryKey = this.secretKeyRing.getSecretKey().getPublicKey();
        PBESecretKeyDecryptor ringDecryptor = keyRingProtector.getDecryptor(primaryKey.getKeyID());
        PBESecretKeyEncryptor subKeyEncryptor = subKeyProtector.getEncryptor(secretSubKey.getKeyID());
        PGPDigestCalculator digestCalculator = new BcPGPDigestCalculatorProvider().get(this.defaultDigestHashAlgorithm.getAlgorithmId());
        BcPGPContentSignerBuilder contentSignerBuilder = new BcPGPContentSignerBuilder(primaryKey.getAlgorithm(), HashAlgorithm.SHA256.getAlgorithmId());
        PGPPrivateKey privateSubKey = KeyRingUtils.unlockSecretKey(secretSubKey, subKeyProtector);
        PGPKeyPair subKeyPair = new PGPKeyPair(secretSubKey.getPublicKey(), privateSubKey);
        PGPKeyRingGenerator keyRingGenerator = new PGPKeyRingGenerator(this.secretKeyRing, ringDecryptor, digestCalculator, (PGPContentSignerBuilder)contentSignerBuilder, subKeyEncryptor);
        keyRingGenerator.addSubKey(subKeyPair);
        this.secretKeyRing = keyRingGenerator.generateSecretKeyRing();
        return this;
    }

    private PGPSecretKey generateSubKey(@Nonnull KeySpec keySpec, @Nonnull Passphrase subKeyPassphrase) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPDigestCalculator checksumCalculator = new BcPGPDigestCalculatorProvider().get(this.defaultDigestHashAlgorithm.getAlgorithmId());
        PBESecretKeyEncryptor subKeyEncryptor = subKeyPassphrase.isEmpty() ? null : new BcPBESecretKeyEncryptorBuilder(SymmetricKeyAlgorithm.AES_256.getAlgorithmId()).build(subKeyPassphrase.getChars());
        PGPKeyPair keyPair = KeyRingBuilder.generateKeyPair(keySpec);
        PGPSecretKey secretKey = new PGPSecretKey(keyPair.getPrivateKey(), keyPair.getPublicKey(), checksumCalculator, false, subKeyEncryptor);
        return secretKey;
    }

    @Override
    public SecretKeyRingEditorInterface deleteSubKey(OpenPgpV4Fingerprint fingerprint, SecretKeyRingProtector protector) {
        return this.deleteSubKey(fingerprint.getKeyId(), protector);
    }

    @Override
    public SecretKeyRingEditorInterface deleteSubKey(long subKeyId, SecretKeyRingProtector protector) {
        PGPSecretKeyRing newKeyRing;
        if (this.secretKeyRing.getSecretKey().getKeyID() == subKeyId) {
            throw new IllegalArgumentException("You cannot delete the primary key of this key ring.");
        }
        PGPSecretKey deleteMe = this.secretKeyRing.getSecretKey(subKeyId);
        if (deleteMe == null) {
            throw new NoSuchElementException("KeyRing does not contain a key with keyId " + Long.toHexString(subKeyId));
        }
        this.secretKeyRing = newKeyRing = PGPSecretKeyRing.removeSecretKey((PGPSecretKeyRing)this.secretKeyRing, (PGPSecretKey)deleteMe);
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface revoke(SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        return this.revokeSubKey(this.secretKeyRing.getSecretKey().getKeyID(), secretKeyRingProtector, revocationAttributes);
    }

    @Override
    public SecretKeyRingEditorInterface revokeSubKey(OpenPgpV4Fingerprint fingerprint, SecretKeyRingProtector protector, RevocationAttributes revocationAttributes) throws PGPException {
        return this.revokeSubKey(fingerprint.getKeyId(), protector, revocationAttributes);
    }

    @Override
    public SecretKeyRingEditorInterface revokeSubKey(long subKeyId, SecretKeyRingProtector protector, RevocationAttributes revocationAttributes) throws PGPException {
        PGPPublicKey revokeeSubKey = this.secretKeyRing.getPublicKey(subKeyId);
        if (revokeeSubKey == null) {
            throw new NoSuchElementException("No subkey with id " + Long.toHexString(subKeyId) + " found.");
        }
        this.secretKeyRing = this.revokeSubKey(protector, revokeeSubKey, revocationAttributes);
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface setExpirationDate(OpenPgpV4Fingerprint fingerprint, Date expiration, SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        Iterator secretKeyIterator = this.secretKeyRing.getSecretKeys();
        if (!secretKeyIterator.hasNext()) {
            throw new NoSuchElementException("No secret keys in the ring.");
        }
        PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
        PGPPublicKey publicKey = secretKey.getPublicKey();
        if (!new OpenPgpV4Fingerprint(publicKey).equals(fingerprint)) {
            throw new IllegalArgumentException("Currently it is possible to adjust expiration date for primary key only.");
        }
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        PGPPrivateKey privateKey = KeyRingUtils.unlockSecretKey(secretKey, secretKeyRingProtector);
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        PGPSignatureGenerator signatureGenerator = SignatureUtils.getSignatureGeneratorFor(primaryKey);
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        long secondsToExpire = 0L;
        if (expiration != null) {
            secondsToExpire = (expiration.getTime() - primaryKey.getPublicKey().getCreationTime().getTime()) / 1000L;
        }
        subpacketGenerator.setKeyExpirationTime(false, secondsToExpire);
        PGPSignatureSubpacketVector subPackets = subpacketGenerator.generate();
        signatureGenerator.setHashedSubpackets(subPackets);
        signatureGenerator.init(19, privateKey);
        Iterator users = publicKey.getUserIDs();
        while (users.hasNext()) {
            String user = (String)users.next();
            PGPSignature signature = signatureGenerator.generateCertification(user, primaryKey.getPublicKey());
            publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (String)user, (PGPSignature)signature);
        }
        secretKey = PGPSecretKey.replacePublicKey((PGPSecretKey)secretKey, (PGPPublicKey)publicKey);
        secretKeyList.add(secretKey);
        this.secretKeyRing = new PGPSecretKeyRing(secretKeyList);
        return this;
    }

    @Override
    public PGPSignature createRevocationCertificate(OpenPgpV4Fingerprint fingerprint, SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        PGPPublicKey revokeeSubKey = this.secretKeyRing.getPublicKey(fingerprint.getKeyId());
        if (revokeeSubKey == null) {
            throw new NoSuchElementException("No subkey with fingerprint " + fingerprint + " found.");
        }
        PGPSignature revocationCertificate = this.generateRevocation(secretKeyRingProtector, revokeeSubKey, revocationAttributes);
        return revocationCertificate;
    }

    @Override
    public PGPSignature createRevocationCertificate(long subKeyId, SecretKeyRingProtector secretKeyRingProtector, RevocationAttributes revocationAttributes) throws PGPException {
        PGPPublicKey revokeeSubKey = this.secretKeyRing.getPublicKey(subKeyId);
        if (revokeeSubKey == null) {
            throw new NoSuchElementException("No subkey with id " + Long.toHexString(subKeyId) + " found.");
        }
        PGPSignature revocationCertificate = this.generateRevocation(secretKeyRingProtector, revokeeSubKey, revocationAttributes);
        return revocationCertificate;
    }

    private PGPSecretKeyRing revokeSubKey(SecretKeyRingProtector protector, PGPPublicKey revokeeSubKey, RevocationAttributes revocationAttributes) throws PGPException {
        PGPSignature subKeyRevocation = this.generateRevocation(protector, revokeeSubKey, revocationAttributes);
        revokeeSubKey = PGPPublicKey.addCertification((PGPPublicKey)revokeeSubKey, (PGPSignature)subKeyRevocation);
        PGPPublicKeyRing publicKeyRing = KeyRingUtils.publicKeyRingFrom(this.secretKeyRing);
        publicKeyRing = PGPPublicKeyRing.insertPublicKey((PGPPublicKeyRing)publicKeyRing, (PGPPublicKey)revokeeSubKey);
        return PGPSecretKeyRing.replacePublicKeys((PGPSecretKeyRing)this.secretKeyRing, (PGPPublicKeyRing)publicKeyRing);
    }

    private PGPSignature generateRevocation(SecretKeyRingProtector protector, PGPPublicKey revokeeSubKey, RevocationAttributes revocationAttributes) throws PGPException {
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        PGPSignatureGenerator signatureGenerator = SignatureUtils.getSignatureGeneratorFor(primaryKey);
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        subpacketGenerator.setIssuerFingerprint(false, primaryKey);
        if (revocationAttributes != null) {
            subpacketGenerator.setRevocationReason(false, revocationAttributes.getReason().code(), revocationAttributes.getDescription());
        }
        PGPSignatureSubpacketVector subPackets = subpacketGenerator.generate();
        signatureGenerator.setHashedSubpackets(subPackets);
        PGPPrivateKey privateKey = primaryKey.extractPrivateKey(protector.getDecryptor(primaryKey.getKeyID()));
        SignatureType type = revokeeSubKey.isMasterKey() ? SignatureType.KEY_REVOCATION : SignatureType.SUBKEY_REVOCATION;
        signatureGenerator.init(type.getCode(), privateKey);
        PGPSignature subKeyRevocation = signatureGenerator.generateCertification(primaryKey.getPublicKey(), revokeeSubKey);
        return subKeyRevocation;
    }

    @Override
    public SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase oldPassphrase, @Nonnull KeyRingProtectionSettings oldProtectionSettings) {
        PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(oldProtectionSettings, new SolitaryPassphraseProvider(oldPassphrase));
        return new WithKeyRingEncryptionSettingsImpl(null, protector);
    }

    @Override
    public SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long keyId, @Nullable Passphrase oldPassphrase, @Nonnull KeyRingProtectionSettings oldProtectionSettings) {
        Map<Long, Passphrase> passphraseMap = Collections.singletonMap(keyId, oldPassphrase);
        PassphraseMapKeyRingProtector protector = new PassphraseMapKeyRingProtector(passphraseMap, oldProtectionSettings, null);
        return new WithKeyRingEncryptionSettingsImpl(keyId, protector);
    }

    @Override
    public PGPSecretKeyRing done() {
        return this.secretKeyRing;
    }

    private PGPSecretKeyRing changePassphrase(Long keyId, PGPSecretKeyRing secretKeys, SecretKeyRingProtector oldProtector, SecretKeyRingProtector newProtector) throws PGPException {
        if (keyId == null) {
            ArrayList<PGPSecretKey> newlyEncryptedSecretKeys = new ArrayList<PGPSecretKey>();
            Iterator secretKeyIterator = secretKeys.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
                PGPPrivateKey privateKey = KeyRingUtils.unlockSecretKey(secretKey, oldProtector);
                secretKey = this.lockPrivateKey(privateKey, secretKey.getPublicKey(), newProtector);
                newlyEncryptedSecretKeys.add(secretKey);
            }
            return new PGPSecretKeyRing(newlyEncryptedSecretKeys);
        }
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        Iterator secretKeyIterator = secretKeys.getSecretKeys();
        while (secretKeyIterator.hasNext()) {
            PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
            if (secretKey.getPublicKey().getKeyID() == keyId.longValue()) {
                PGPPrivateKey privateKey = KeyRingUtils.unlockSecretKey(secretKey, oldProtector);
                secretKey = this.lockPrivateKey(privateKey, secretKey.getPublicKey(), newProtector);
            }
            secretKeyList.add(secretKey);
        }
        return new PGPSecretKeyRing(secretKeyList);
    }

    private PGPSecretKey lockPrivateKey(PGPPrivateKey privateKey, PGPPublicKey publicKey, SecretKeyRingProtector protector) throws PGPException {
        PGPDigestCalculator checksumCalculator = new BcPGPDigestCalculatorProvider().get(this.defaultDigestHashAlgorithm.getAlgorithmId());
        PBESecretKeyEncryptor encryptor = protector.getEncryptor(publicKey.getKeyID());
        PGPSecretKey secretKey = new PGPSecretKey(privateKey, publicKey, checksumCalculator, publicKey.isMasterKey(), encryptor);
        return secretKey;
    }

    private final class WithPassphraseImpl
    implements SecretKeyRingEditorInterface.WithPassphrase {
        private final SecretKeyRingProtector oldProtector;
        private final KeyRingProtectionSettings newProtectionSettings;
        private final Long keyId;

        private WithPassphraseImpl(Long keyId, SecretKeyRingProtector oldProtector, KeyRingProtectionSettings newProtectionSettings) {
            this.keyId = keyId;
            this.oldProtector = oldProtector;
            this.newProtectionSettings = newProtectionSettings;
        }

        @Override
        public SecretKeyRingEditorInterface toNewPassphrase(Passphrase passphrase) throws PGPException {
            PasswordBasedSecretKeyRingProtector newProtector = new PasswordBasedSecretKeyRingProtector(this.newProtectionSettings, new SolitaryPassphraseProvider(passphrase));
            PGPSecretKeyRing secretKeys = SecretKeyRingEditor.this.changePassphrase(this.keyId, SecretKeyRingEditor.this.secretKeyRing, this.oldProtector, newProtector);
            SecretKeyRingEditor.this.secretKeyRing = secretKeys;
            return SecretKeyRingEditor.this;
        }

        @Override
        public SecretKeyRingEditorInterface toNoPassphrase() throws PGPException {
            UnprotectedKeysProtector newProtector = new UnprotectedKeysProtector();
            PGPSecretKeyRing secretKeys = SecretKeyRingEditor.this.changePassphrase(this.keyId, SecretKeyRingEditor.this.secretKeyRing, this.oldProtector, newProtector);
            SecretKeyRingEditor.this.secretKeyRing = secretKeys;
            return SecretKeyRingEditor.this;
        }
    }

    private final class WithKeyRingEncryptionSettingsImpl
    implements SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings {
        private final Long keyId;
        private final SecretKeyRingProtector oldProtector;

        private WithKeyRingEncryptionSettingsImpl(Long keyId, SecretKeyRingProtector oldProtector) {
            this.keyId = keyId;
            this.oldProtector = oldProtector;
        }

        @Override
        public SecretKeyRingEditorInterface.WithPassphrase withSecureDefaultSettings() {
            return this.withCustomSettings(KeyRingProtectionSettings.secureDefaultSettings());
        }

        @Override
        public SecretKeyRingEditorInterface.WithPassphrase withCustomSettings(KeyRingProtectionSettings settings) {
            return new WithPassphraseImpl(this.keyId, this.oldProtector, settings);
        }
    }
}

