/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class PasswordBasedSecretKeyRingProtector
implements SecretKeyRingProtector {
    private static final PGPDigestCalculatorProvider calculatorProvider = new BcPGPDigestCalculatorProvider();
    protected final KeyRingProtectionSettings protectionSettings;
    protected final SecretKeyPassphraseProvider passphraseProvider;

    public PasswordBasedSecretKeyRingProtector(@Nonnull KeyRingProtectionSettings settings, @Nonnull SecretKeyPassphraseProvider passphraseProvider) {
        this.protectionSettings = settings;
        this.passphraseProvider = passphraseProvider;
    }

    public static PasswordBasedSecretKeyRingProtector forKey(final PGPKeyRing keyRing, final Passphrase passphrase) {
        KeyRingProtectionSettings protectionSettings = KeyRingProtectionSettings.secureDefaultSettings();
        SecretKeyPassphraseProvider passphraseProvider = new SecretKeyPassphraseProvider(){

            @Override
            @Nullable
            public Passphrase getPassphraseFor(Long keyId) {
                if (keyRing.getPublicKey().getKeyID() == keyId.longValue()) {
                    return passphrase;
                }
                return null;
            }
        };
        return new PasswordBasedSecretKeyRingProtector(protectionSettings, passphraseProvider);
    }

    public static PasswordBasedSecretKeyRingProtector forKey(final PGPSecretKey key, final Passphrase passphrase) {
        KeyRingProtectionSettings protectionSettings = KeyRingProtectionSettings.secureDefaultSettings();
        SecretKeyPassphraseProvider passphraseProvider = new SecretKeyPassphraseProvider(){

            @Override
            @Nullable
            public Passphrase getPassphraseFor(Long keyId) {
                if (key.getKeyID() == keyId.longValue()) {
                    return passphrase;
                }
                return null;
            }
        };
        return new PasswordBasedSecretKeyRingProtector(protectionSettings, passphraseProvider);
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(Long keyId) {
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        return passphrase == null ? null : new BcPBESecretKeyDecryptorBuilder(calculatorProvider).build(passphrase.getChars());
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(Long keyId) throws PGPException {
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        return passphrase == null ? null : new BcPBESecretKeyEncryptorBuilder(this.protectionSettings.getEncryptionAlgorithm().getAlgorithmId(), calculatorProvider.get(this.protectionSettings.getHashAlgorithm().getAlgorithmId()), this.protectionSettings.getS2kCount()).build(passphrase.getChars());
    }
}

