/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class DecryptHiddenRecipientMessage {
    private static final String PLAINTEXT = "Hello WOrld";
    private static final String CHIPERHTEXT = "-----BEGIN PGP MESSAGE-----\n\nhG4DAAAAAAAAAAASAgMEUif9JYa7qZedAFs0AUUJ3cxdc7tpsREZxhzzFpgWzKbH\nYB1i7rp3PM9zO88v3GRQY6TH5tR8CJkHRTWGu03c0SBTUbrzWngh0i2uR9DJnjLk\nB8HD4fgn9VP+Qj5Igg6KJdJSAVZlFqVh0H6PCEUaSre/KlyVVqikZKTm0hnWb6XZ\n/TrefNuUR6PDNyh/oMbfAQD46UZjfRrbNUdKjOyfwtBYkkcGKTF+HilQbjk1nKud\npojSOQ==\n=nyvJ\n-----END PGP MESSAGE-----";

    @Test
    public void testDecryptionWithHiddenRecipient() throws IOException, PGPException {
        PGPSecretKeyRingCollection emilSecret = TestKeys.getEmilSecretKeyRingCollection();
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(CHIPERHTEXT.getBytes(StandardCharsets.UTF_8))).decryptWith((SecretKeyRingProtector)new UnprotectedKeysProtector(), emilSecret).doNotVerify().build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        OpenPgpMetadata metadata = decryptionStream.getResult();
    }
}

