/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class TestKeys {
    private static final KeyFingerPrintCalculator calc = new BcKeyFingerprintCalculator();
    private static PGPSecretKeyRing julietSecretKeyRing = null;
    private static PGPPublicKeyRing julietPublicKeyRing = null;
    private static PGPSecretKeyRing romeoSecretKeyRing = null;
    private static PGPPublicKeyRing romeoPublicKeyRing = null;
    private static PGPSecretKeyRing emilSecretKeyRing = null;
    private static PGPPublicKeyRing emilPublicKeyRing = null;
    private static PGPSecretKeyRing cryptieSecretKeyRing = null;
    private static PGPPublicKeyRing cryptiePublicKeyRing = null;
    private static PGPSecretKeyRingCollection julietSecretKeyRingCollection = null;
    private static PGPPublicKeyRingCollection julietPublicKeyRingCollection = null;
    private static PGPSecretKeyRingCollection romeoSecretKeyRingCollection = null;
    private static PGPPublicKeyRingCollection romeoPublicKeyRingCollection = null;
    private static PGPSecretKeyRingCollection emilSecretKeyRingCollection = null;
    private static PGPPublicKeyRingCollection emilPublicKeyRingCollection = null;
    private static PGPSecretKeyRingCollection cryptieSecretKeyRingCollection = null;
    private static PGPPublicKeyRingCollection cryptiePublicKeyRingCollection = null;
    public static final String JULIET_UID = "xmpp:juliet@capulet.lit";
    public static final long JULIET_KEY_ID = -5425419407118114754L;
    public static final String JULIET_FINGERPRINT_STRING = "1D018C772DF8C5EF86A1DCC9B4B509CB5936E03E";
    public static final OpenPgpV4Fingerprint JULIET_FINGERPRINT = new OpenPgpV4Fingerprint("1D018C772DF8C5EF86A1DCC9B4B509CB5936E03E");
    public static final String JULIET_PUB = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQENBFrxov4BCAChZwPrBxxIlwzpieR5T2pnaOZLWH0WqSON6rVjvfbJHWdDi3Th\nremHW4gg4IBSTXkVFDIeQNVcOvGNgMg3Oe/x0I6FK12jrw9prycmjFxQ7A0ix7ZG\nUkTF5jITgzJbkH100gYfXtZsfTyvgISSAT//6vvvQPZ3zCr09XvAG0CyQ1BhULsv\nmVRe4Oh5b0VK4kLdv+GiA/T+49UKZj6lne9Vdti16ZIj7teVCbicfdhpTzsjur42\nr8ptouKAuyFPw9KnGNwVlIiv5jt/Kit/LoOBenh74sitsCXq8IQ9kKp/eNt8TF4u\nD4IGpxnJfB8XCiixYHoFEajmQBVJXNYtvoPvABEBAAG0F3htcHA6anVsaWV0QGNh\ncHVsZXQubGl0iQFOBBMBCAA4FiEEHQGMdy34xe+GodzJtLUJy1k24D4FAlrxov4C\nGy8FCwkIBwIGFQoJCAsCBBYCAwECHgECF4AACgkQtLUJy1k24D6H7AgAoTjx4ezc\nA83NeOY3tMHVQTM7hKuy0wMcSzQgVgJmhLYRZS8r+FocPZua/eke49GPhe2yozvl\nByWHtotklQeJiwOKxuPKMzneVA1ZK3/9LdGvtZlHMcAkEKDhit8HIaEcsFd4Z1re\nEhF2lyvY/E+rrx9YxV0QjisSWV2dSptv6FeGSztr9e5E+Head6hEQhsugiTVRF+1\n6mG90te0WGQ9YNiJ2FJovx5kBLTTuhwUz8Oacqihd2+RDDI5p3wJoogVL31aNb4n\nc7dGo8ieJPHGlkBsOfmreSxijTodZz9MXsgcx7b//u0uQryViJoZHWbtnXOFjjNc\nGWBtS084NKWl9w==\n=ecwX\n-----END PGP PUBLIC KEY BLOCK-----";
    public static final String JULIET_SEC = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n\nlQOYBFrxov4BCAChZwPrBxxIlwzpieR5T2pnaOZLWH0WqSON6rVjvfbJHWdDi3Th\nremHW4gg4IBSTXkVFDIeQNVcOvGNgMg3Oe/x0I6FK12jrw9prycmjFxQ7A0ix7ZG\nUkTF5jITgzJbkH100gYfXtZsfTyvgISSAT//6vvvQPZ3zCr09XvAG0CyQ1BhULsv\nmVRe4Oh5b0VK4kLdv+GiA/T+49UKZj6lne9Vdti16ZIj7teVCbicfdhpTzsjur42\nr8ptouKAuyFPw9KnGNwVlIiv5jt/Kit/LoOBenh74sitsCXq8IQ9kKp/eNt8TF4u\nD4IGpxnJfB8XCiixYHoFEajmQBVJXNYtvoPvABEBAAEAB/4jMbXagW3q7DkOEZnm\n0+jVTLvu0QhRsScGEphj+++8sfMq+NVPQp9p+w0Hcjy49ZjB/mnhS+zaVCYI33yJ\nAlKubXYuVqLwBsO7HUzRrIiSwq4ol9jIo7bIWmYv+As6iRq6JvPb0k+6T2K0uDbw\nKWKduM0fwhAcVkJFsOO/o5GrbQaJc3oioFk8uFWTnO+FPBRTJ9oTlVG2M/tEatZK\ngl7I8Ukl0YYruCNUFKZ0tvO8HqulxBgUbGPBer1uOlfUD4RXdc8/PUiFKNo48XSu\nZUEAZKGbFBjuX5Z8ha7+sUMEYEt70qlbkiLQxgHKAmpyridAk3q/SB3y2VB8Ik7I\ngpExBADInzLROYuUcXqmty+znVwm6nRIB75JBAy778zgIxx1v0O3QlVnR+YI8gJM\nmQ/9pD6LyP9hktWDmJxG8tX+kSuIp3wNJc5EMeXtCCmkUW0CP1gUhAbNW3MezKa5\nII5IhE9RgIsYqSU8ZgeIh72ON8XTp8i/wGipCXvJPggSAMXukQQAzfRmtLW+JHEK\nB8ETIYh8IUjXJ6TVlmuBwZ0eXjCpqy9arJi6tacesDJwnL3sqOMQWUmqGsCGSKA5\ncLITkVsxX/htIq8GFyludjg8t4Nr+fOGfChEq8QE0PHE2CgskQMHpfHvfIdnwKve\nFg2Q8twoMw849O6PF3k/848Z65lDin8EAMDbuPWL7KU2sWeqvDEuoulS5K1gsq8X\np3Od3+f0OG8YViMjKcVlSKHVvdlK4dlsccJrJJx6VzotV47LsmvVbzDwUE//MYq7\nQwwQetZbpdQZDysSGVqHMTuAg/1pr2u5rqh4cFqCYatgZwinEI2TQMXEqnSc+mj8\nxp/LNq5BZZQuO4y0F3htcHA6anVsaWV0QGNhcHVsZXQubGl0iQFOBBMBCAA4FiEE\nHQGMdy34xe+GodzJtLUJy1k24D4FAlrxov4CGy8FCwkIBwIGFQoJCAsCBBYCAwEC\nHgECF4AACgkQtLUJy1k24D6H7AgAoTjx4ezcA83NeOY3tMHVQTM7hKuy0wMcSzQg\nVgJmhLYRZS8r+FocPZua/eke49GPhe2yozvlByWHtotklQeJiwOKxuPKMzneVA1Z\nK3/9LdGvtZlHMcAkEKDhit8HIaEcsFd4Z1reEhF2lyvY/E+rrx9YxV0QjisSWV2d\nSptv6FeGSztr9e5E+Head6hEQhsugiTVRF+16mG90te0WGQ9YNiJ2FJovx5kBLTT\nuhwUz8Oacqihd2+RDDI5p3wJoogVL31aNb4nc7dGo8ieJPHGlkBsOfmreSxijTod\nZz9MXsgcx7b//u0uQryViJoZHWbtnXOFjjNcGWBtS084NKWl9w==\n=yPPE\n-----END PGP PRIVATE KEY BLOCK-----";
    public static final String ROMEO_UID = "xmpp:romeo@montague.lit";
    public static final long ROMEO_KEY_ID = 334147643349279223L;
    public static final String ROMEO_FINGERPRINT_STRING = "35D299D08A2F7D80230B095D04A32182E05E21F7";
    public static final OpenPgpV4Fingerprint ROMEO_FINGERPRINT = new OpenPgpV4Fingerprint("35D299D08A2F7D80230B095D04A32182E05E21F7");
    public static final String ROMEO_PUB = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQENBFrxopkBCADiYg/+mEObXgxuMW6/LFKpEyaJK9pBMgutuxnYZ9PXWZmOhDIT\nUgm9X9YJ3Qh94KaHge9F4uCeFASmM1vvUTRFTEb1W5RR9ZE/sy/cdAttnZ5JloPi\nCT3HDMIJAxIXhRJkeUR9GUb51ql27bMXl6lFh865VdNSXN/B8FzRQHENxv1Bq/6Z\niQOViIETeRRgO+u6u2iZkYlHgYMaoMK7+YiNlHXanU9Atcuaz0ZCJS/XFNH89iqB\nKvnv7KCQh4FhrNMLJRzNPXV8MY05nn0zF72qeEsniB16Xde18lMro8fQehg2mLwc\nXGtCwCKI6QbZVxYQt77r3ZACiwl66soFWijVABEBAAG0F3htcHA6cm9tZW9AbW9u\ndGFndWUubGl0iQFOBBMBCAA4FiEENdKZ0IovfYAjCwldBKMhguBeIfcFAlrxopkC\nGy8FCwkIBwIGFQoJCAsCBBYCAwECHgECF4AACgkQBKMhguBeIfcj8AgAu1wubUwr\n2aQmDN3OqRM4M4yRL3oyYMkCKIjqD6KEeFsIXSSkXOuREJKEo8Mb1+ewV0SYmHCC\nK3bKKq3m71AQ7evDhKGshacPYesiDvMdHWQdQnjfaoHhyn9qIKl7H0Xv1yf/wyuG\nANy1jYgtCEuYw7D+EsqNDdn8Xh+k/9s4aMI/6mfC0yGZgG8EyLTfbZkGPoS4aZfV\nAGFbuqryg48dXtnuzAPKcdgMTTMSnmR729YlfkjCffcFaldyXoe1VMbudUO7nkO9\ng65i5EXenkbc2h0TRDQ4lDFQyModqFTwYFYxAf/RA6tuhIQEoCnpCytFMvrRKMb3\nBx5vYRDVmE3jeg==\n=2jSg\n-----END PGP PUBLIC KEY BLOCK-----";
    public static final String ROMEO_SEC = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n\nlQOYBFrxopkBCADiYg/+mEObXgxuMW6/LFKpEyaJK9pBMgutuxnYZ9PXWZmOhDIT\nUgm9X9YJ3Qh94KaHge9F4uCeFASmM1vvUTRFTEb1W5RR9ZE/sy/cdAttnZ5JloPi\nCT3HDMIJAxIXhRJkeUR9GUb51ql27bMXl6lFh865VdNSXN/B8FzRQHENxv1Bq/6Z\niQOViIETeRRgO+u6u2iZkYlHgYMaoMK7+YiNlHXanU9Atcuaz0ZCJS/XFNH89iqB\nKvnv7KCQh4FhrNMLJRzNPXV8MY05nn0zF72qeEsniB16Xde18lMro8fQehg2mLwc\nXGtCwCKI6QbZVxYQt77r3ZACiwl66soFWijVABEBAAEAB/4mu5p69/hRQ+UikWie\nYun9rZ4hSBR+pR5kaifA4/rV1Km2PZ4HujiaYyRO6beDOgWkF7IlpezCfzBQc2ce\nailkVemqHzIgV8CzQmhE8sHlzlr/wjXsXaJpRSCJxDG7PnRoJmt2b/W512WFSKQk\nvDklAVh4U1vlsqhCGWr4DmuJbJkRyDhcX01tplRwim283F7bGqRcMBmKMZHiMgVc\n0u84EYKKVizJ3YAaaVqZyHb4qdeKK2ak3fPNuGT/oGd2sxnkL+BZGjJpu3RGpTA1\ntbOvOQnJGHQtABFxE8n6H9dHPJGtgyz2+udjUhL/P/E3PDoXazZkXRq2oHZKgg0f\nAwOBBADsWncHgvz15rXPF7O6AivbGTJ5ctkgVy4U3Fu2sk9rf0fx0sryBSqtTBw1\nUvn/p9RwTsKw6fng6Nf78xpZFlUDB00YCcuWkGodxvjTAyB0dtBmkhopeKi0dmHh\nndnR6Pv0CsXu8nG7lUi+q6s3oc4h2OfDBhrqsyYY5M2gGit3dQQA9TNuinJD9XXv\nQRyauMnSJ5xRcfOu8QCxZlllCvffZjSGCPoVjUpJEe9qsVbXVj2GYCxjLCSXV0V+\nvlJfdPrl1BhZ3fmEpg0u7SyGDDOe8fe1ehk5sAeL8O0eFWlPSEaEccsjlpJ2FO0n\nP04SZdOeM6wmhDTEDzpFnjbPndQTH+ED/R1zNzr55DvxQodmrW/BvTmhGQ22rHtk\nIUfbeMaVfUvNLJA/JksrUIx3Gga9QCDZgfm1RsRhLUlHiqTQe23sPWgKOsbf5O1j\nXJZaCNZ7LloVQbkG7xFcnb/n1+JjBr4FxXjAA6cY/iRGlznjIIaasyklKm1/4LuQ\nhnH3QqTvCN3dOFS0F3htcHA6cm9tZW9AbW9udGFndWUubGl0iQFOBBMBCAA4FiEE\nNdKZ0IovfYAjCwldBKMhguBeIfcFAlrxopkCGy8FCwkIBwIGFQoJCAsCBBYCAwEC\nHgECF4AACgkQBKMhguBeIfcj8AgAu1wubUwr2aQmDN3OqRM4M4yRL3oyYMkCKIjq\nD6KEeFsIXSSkXOuREJKEo8Mb1+ewV0SYmHCCK3bKKq3m71AQ7evDhKGshacPYesi\nDvMdHWQdQnjfaoHhyn9qIKl7H0Xv1yf/wyuGANy1jYgtCEuYw7D+EsqNDdn8Xh+k\n/9s4aMI/6mfC0yGZgG8EyLTfbZkGPoS4aZfVAGFbuqryg48dXtnuzAPKcdgMTTMS\nnmR729YlfkjCffcFaldyXoe1VMbudUO7nkO9g65i5EXenkbc2h0TRDQ4lDFQyMod\nqFTwYFYxAf/RA6tuhIQEoCnpCytFMvrRKMb3Bx5vYRDVmE3jeg==\n=LZ1b\n-----END PGP PRIVATE KEY BLOCK-----";
    public static final String EMIL_UID = "<emil@email.user>";
    public static final long EMIL_KEY_ID = 6284463849526474508L;
    public static final String EMIL_FINGERPRINT_STRING = "4F665C4DC2C4660BC6425E415736E6931ACF370C";
    public static final OpenPgpV4Fingerprint EMIL_FINGERPRINT = new OpenPgpV4Fingerprint("4F665C4DC2C4660BC6425E415736E6931ACF370C");
    public static final Date EMIL_CREATION_DATE = new Date(1578852104000L);
    public static final String EMIL_PUB = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: BCPG v1.64\n\nmFIEXhtfCBMIKoZIzj0DAQcCAwTGSFMBUOSLusXS8hdNHbdK3gN8hS7jd4ky7Czl\nmSti+oVyRJUwQAFZJ1NMsg1H8flSJP1/9YbHd9FBU4bHKGKPtBE8ZW1pbEBlbWFp\nbC51c2VyPoh1BBMTCgAdBQJeG18IAhsjBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQ\nVzbmkxrPNwz8rAD/S/VCQc5NJLArgTDkgrt3Q573HiYfrIQo1uk3dwV15WIBAMiq\noDmRMb8jzOBv6FGW4P5WAubPdnAvDD7XmArD+TSeuFYEXhtfCBIIKoZIzj0DAQcC\nAwTgWDWmHJLQUQ35Qg/rINmUhkUhj1E4O5t6Y2PipbqlGfDufLmIKnX40BoJPS4G\nHW7U0QXfwSaTXa1BAaNsMUomAwEIB4h1BBgTCgAdBQJeG18IAhsMBRYCAwEABAsJ\nCAcFFQoJCAsCHgEACgkQVzbmkxrPNwxOcwEA19Fnhw7XwpQoT61Fqg54vroAwTZ3\nT5A+LOdevAtzNOUA/RWeKfOGk6D+vKYRNpMJyqsHi/vBeKwXoeN0n6HuExVF\n=a1W7\n-----END PGP PUBLIC KEY BLOCK-----";
    public static final String EMIL_SEC = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: BCPG v1.64\n\nlHcEXhtfCBMIKoZIzj0DAQcCAwTGSFMBUOSLusXS8hdNHbdK3gN8hS7jd4ky7Czl\nmSti+oVyRJUwQAFZJ1NMsg1H8flSJP1/9YbHd9FBU4bHKGKPAAD5AdecgJ92sAXP\nl4U4oW6l4KKUb8IT3J5g68Z+Q9WIq6kS5bQRPGVtaWxAZW1haWwudXNlcj6IdQQT\nEwoAHQUCXhtfCAIbIwUWAgMBAAQLCQgHBRUKCQgLAh4BAAoJEFc25pMazzcM/KwA\n/0v1QkHOTSSwK4Ew5IK7d0Oe9x4mH6yEKNbpN3cFdeViAQDIqqA5kTG/I8zgb+hR\nluD+VgLmz3ZwLww+15gKw/k0npx7BF4bXwgSCCqGSM49AwEHAgME4Fg1phyS0FEN\n+UIP6yDZlIZFIY9RODubemNj4qW6pRnw7ny5iCp1+NAaCT0uBh1u1NEF38Emk12t\nQQGjbDFKJgMBCAcAAQCMHcK/wrUR1R8HKvLUFzUB/a5zj1reOzQOsFtoLte3Mg6u\niHUEGBMKAB0FAl4bXwgCGwwFFgIDAQAECwkIBwUVCgkICwIeAQAKCRBXNuaTGs83\nDE5zAQDX0WeHDtfClChPrUWqDni+ugDBNndPkD4s5168C3M05QD9FZ4p84aToP68\nphE2kwnKqweL+8F4rBeh43Sfoe4TFUU=\n=Pqd/\n-----END PGP PRIVATE KEY BLOCK-----";
    public static final String CRYPTIE_UID = "cryptie@encrypted.key";
    public static final String CRYPTIE_PASSWORD = "password123";
    public static final long CRYPTIE_KEY_ID = -821156605394703576L;
    public static final String CRYPTIE_FINGERPRINT_STRING = "A395D3BA58CA3FA0DE8F2991F49AAA6B067BAB28";
    public static final OpenPgpV4Fingerprint CRYPTIE_FINGERPRINT = new OpenPgpV4Fingerprint("A395D3BA58CA3FA0DE8F2991F49AAA6B067BAB28");
    public static final String CRYPTIE_PUB = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: BCPG v1.64\n\nmFIEXht1HBMIKoZIzj0DAQcCAwQgSQNsoRMqlb9bm4XmXRxIyJoXhIADAQcqkrkt\nuWvGWeu5m5HLi1LfwVHZWTGff94uq/uK3O3Vg0W4EQjF8qB6tBVjcnlwdGllQGVu\nY3J5cHRlZC5rZXmIdQQTEwoAHQUCXht1HAIbIwUWAgMBAAQLCQgHBRUKCQgLAh4B\nAAoJEPSaqmsGe6soOWEBAMPW0d/DBVIs9tscIt+jXbg49kwYo57rbbEmp/X05RZS\nAQDHDMOkesBjv9zQToWGGb0FmkWbrDCzA0i10mbyNAe4d7hWBF4bdR0SCCqGSM49\nAwEHAgMENs+3TanqesZgSXn3gtz3QEqu8ZLID2+8U1Jh2KkkiasI1S+48k+CMiFb\n0CclBy6+mX0k8chzj8wCNOgM74DB0AMBCAeIdQQYEwoAHQUCXht1HQIbDAUWAgMB\nAAQLCQgHBRUKCQgLAh4BAAoJEPSaqmsGe6sovOUA/3Zb9qJM/9znjFM9hxMVL0y3\n9wKEqKkSPRj0WVr6O5ybAP9S/Q/tzQ2in19xBg06XzNyd5a1nrwR9n4kjd4VpQWh\nxQ==\n=6SyK\n-----END PGP PUBLIC KEY BLOCK-----";
    public static final String CRYPTIE_SEC = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: BCPG v1.64\n\nlKUEXht1HBMIKoZIzj0DAQcCAwQgSQNsoRMqlb9bm4XmXRxIyJoXhIADAQcqkrkt\nuWvGWeu5m5HLi1LfwVHZWTGff94uq/uK3O3Vg0W4EQjF8qB6/gkDApZ4y1XLA8XH\nYM7ke2XPiiBQfapmHmZD0OUvlsTwSwDeg7wM9caWduXp7GU5j00T0gzr04xE83bw\npjjMxa1YRaOAJcjm1W/GGXRfXA/vSAO0FWNyeXB0aWVAZW5jcnlwdGVkLmtleYh1\nBBMTCgAdBQJeG3UcAhsjBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQ9JqqawZ7qyg5\nYQEAw9bR38MFUiz22xwi36NduDj2TBijnuttsSan9fTlFlIBAMcMw6R6wGO/3NBO\nhYYZvQWaRZusMLMDSLXSZvI0B7h3nKkEXht1HRIIKoZIzj0DAQcCAwQ2z7dNqep6\nxmBJefeC3PdASq7xksgPb7xTUmHYqSSJqwjVL7jyT4IyIVvQJyUHLr6ZfSTxyHOP\nzAI06AzvgMHQAwEIB/4JAwKWeMtVywPFx2Ci0C0EtcGVxy847rppLWNcaR3FnP/9\nMGxLKDvLdGljC829gxxf5wq/5qUehPqFnQD11L00cFScvlVzs53nO34iUVsJl079\niHUEGBMKAB0FAl4bdR0CGwwFFgIDAQAECwkIBwUVCgkICwIeAQAKCRD0mqprBnur\nKLzlAP92W/aiTP/c54xTPYcTFS9Mt/cChKipEj0Y9Fla+jucmwD/Uv0P7c0Nop9f\ncQYNOl8zcneWtZ68EfZ+JI3eFaUFocU=\n=1d67\n-----END PGP PRIVATE KEY BLOCK-----";
    public static final String TEST_MESSAGE_01_PLAIN = "This message is encrypted\n";
    public static final String MSG_SIGN_CRYPT_JULIET_JULIET = "-----BEGIN PGP MESSAGE-----\n\nhQEMA7S1CctZNuA+AQf/SMX7NTOaAynogTVKE9BMWSj5fgK+7sFrCKiLYbungJEu\nRA/fYqaJNfZN3GARqsHcGaGihQDXr0thnx71+37NhV2cHVeFkeMsHmJf/74lRrHk\nQBXDv2ez0LxUwhkE15/d/NTlT/fm8Vzce6rsm7/ZvzQIaWYyDCnpHXyftJplKd+Y\nPW0PaoFRq1wlZKcNUp/1a3xxpbSpvsYkiAxpdGIwvgUIb85KpFN0EWD3aH8C65it\nIphuv8CEaKqcO0hchQr7kYclEM0qcmm1ukw8+niTV8TFqAzNZh7DF/IWaMeamgfA\nP6pAB1oy7YoWUPQgy7mczD76WzPgJjy8y0hxFd9/f9LA2gEZZ/ClAiX0gHglc4oa\nj5iKIICvtTQzKYL29mW66BUistqMavz6eqHRggoADCBzfgOwuoAQxZMyj33bmrWm\n831LMu+4sZyx6ihLvZ0YcDKMd7C7pQJ3Ucxt+DJUlTmo6KxzGdwGhq7cUcXwCuer\n3MoPIV5YQwXBMbYN9fXV+yQagquz0z7r5igE7AQ1d9SyLJoQ3IHXnsa0xcUVZrIs\nA59LdIXEeRk/Ctjqp34UdTsuUPzervPexY+kNQVSQ2VODhwM5IowzPZFGviPNJYa\nnGt27c4rsQ3sSC/WkdUxdaVY2+m7JktfnklUyVyC5wE1Nw+bO3sni6FeoP/fVSVi\nHmPy7vMj23cQcvcAnuUEd4Qua0lwVrN1MTUggfZOzcH4+9rgMn/uYRAwPH9hdLWQ\nvziQMH5qtJMyWy08m9hIxleoI3+zIGSbra15R+hdWwEaD9+Pak//0Q0thFMeNww7\nY8gK8CSbUHbUjefUIx0s+JjrDGtXG8xfl63MLBbU7yLLB4Vcx77Sxxi3yt5DTi0n\nGmPGRU4LsOYbpPFy\n=caif\n-----END PGP MESSAGE-----";

    public static PGPSecretKeyRing getJulietSecretKeyRing() throws IOException, PGPException {
        if (julietSecretKeyRing == null) {
            julietSecretKeyRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(JULIET_SEC.getBytes())), calc);
        }
        return julietSecretKeyRing;
    }

    public static PGPSecretKeyRingCollection getJulietSecretKeyRingCollection() throws IOException, PGPException {
        if (julietSecretKeyRingCollection == null) {
            julietSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(JULIET_SEC.getBytes())), calc);
        }
        return julietSecretKeyRingCollection;
    }

    public static PGPPublicKeyRing getJulietPublicKeyRing() throws IOException {
        if (julietPublicKeyRing == null) {
            julietPublicKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(JULIET_PUB.getBytes())), calc);
        }
        return julietPublicKeyRing;
    }

    public static PGPPublicKeyRingCollection getJulietPublicKeyRingCollection() throws IOException, PGPException {
        if (julietPublicKeyRingCollection == null) {
            julietPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(JULIET_PUB.getBytes())), calc);
        }
        return julietPublicKeyRingCollection;
    }

    public static PGPSecretKeyRing getRomeoSecretKeyRing() throws IOException, PGPException {
        if (romeoSecretKeyRing == null) {
            romeoSecretKeyRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(ROMEO_SEC.getBytes())), calc);
        }
        return romeoSecretKeyRing;
    }

    public static PGPSecretKeyRingCollection getRomeoSecretKeyRingCollection() throws IOException, PGPException {
        if (romeoSecretKeyRingCollection == null) {
            romeoSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(ROMEO_SEC.getBytes())), calc);
        }
        return romeoSecretKeyRingCollection;
    }

    public static PGPPublicKeyRing getRomeoPublicKeyRing() throws IOException {
        if (romeoPublicKeyRing == null) {
            romeoPublicKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(ROMEO_PUB.getBytes())), calc);
        }
        return romeoPublicKeyRing;
    }

    public static PGPPublicKeyRingCollection getRomeoPublicKeyRingCollection() throws IOException, PGPException {
        if (romeoPublicKeyRingCollection == null) {
            romeoPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(ROMEO_PUB.getBytes())), calc);
        }
        return romeoPublicKeyRingCollection;
    }

    public static PGPSecretKeyRing getEmilSecretKeyRing() throws IOException, PGPException {
        if (emilSecretKeyRing == null) {
            emilSecretKeyRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(EMIL_SEC.getBytes())), calc);
        }
        return emilSecretKeyRing;
    }

    public static PGPSecretKeyRingCollection getEmilSecretKeyRingCollection() throws IOException, PGPException {
        if (emilSecretKeyRingCollection == null) {
            emilSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(EMIL_SEC.getBytes())), calc);
        }
        return emilSecretKeyRingCollection;
    }

    public static PGPPublicKeyRing getEmilPublicKeyRing() throws IOException {
        if (emilPublicKeyRing == null) {
            emilPublicKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(EMIL_PUB.getBytes())), calc);
        }
        return emilPublicKeyRing;
    }

    public static PGPPublicKeyRingCollection getEmilPublicKeyRingCollection() throws IOException, PGPException {
        if (emilPublicKeyRingCollection == null) {
            emilPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(EMIL_PUB.getBytes())), calc);
        }
        return emilPublicKeyRingCollection;
    }

    public static PGPSecretKeyRing getCryptieSecretKeyRing() throws IOException, PGPException {
        if (cryptieSecretKeyRing == null) {
            cryptieSecretKeyRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(CRYPTIE_SEC.getBytes())), calc);
        }
        return cryptieSecretKeyRing;
    }

    public static PGPSecretKeyRingCollection getCryptieSecretKeyRingCollection() throws IOException, PGPException {
        if (cryptieSecretKeyRingCollection == null) {
            cryptieSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(CRYPTIE_SEC.getBytes())), calc);
        }
        return cryptieSecretKeyRingCollection;
    }

    public static PGPPublicKeyRing getCryptiePublicKeyRing() throws IOException {
        if (cryptiePublicKeyRing == null) {
            cryptiePublicKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(CRYPTIE_PUB.getBytes())), calc);
        }
        return cryptiePublicKeyRing;
    }

    public static PGPPublicKeyRingCollection getCryptiePublicKeyRingCollection() throws IOException, PGPException {
        if (cryptiePublicKeyRingCollection == null) {
            cryptiePublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(CRYPTIE_PUB.getBytes())), calc);
        }
        return cryptiePublicKeyRingCollection;
    }
}

