/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.util.UserId;

public class UserIdTest {
    @Test
    public void throwForNullName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserId.withName(null));
    }

    @Test
    public void throwForNullComment() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserId.withName((String)"foo").withComment(null));
    }

    @Test
    public void throwForNullEmail() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserId.withName((String)"foo").withComment("bar").withEmail(null));
    }

    @Test
    public void testFormatOnlyName() {
        Assertions.assertEquals((Object)"Juliet Capulet", (Object)UserId.withName((String)"Juliet Capulet").build().toString());
    }

    @Test
    public void testFormatNameAndComment() {
        Assertions.assertEquals((Object)"Juliet Capulet (from the play)", (Object)UserId.withName((String)"Juliet Capulet").withComment("from the play").noEmail().toString());
    }

    @Test
    public void testFormatNameCommentAndMail() {
        Assertions.assertEquals((Object)"Juliet Capulet (from the play) <juliet@capulet.lit>", (Object)UserId.withName((String)"Juliet Capulet").withComment("from the play").withEmail("juliet@capulet.lit").toString());
    }

    @Test
    public void testFormatNameAndEmail() {
        Assertions.assertEquals((Object)"Juliet Capulet <juliet@capulet.lit>", (Object)UserId.withName((String)"Juliet Capulet").noComment().withEmail("juliet@capulet.lit").toString());
    }
}

