/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.util.KeyRingUtils;

public class GenerateKeyTest {
    private static final Logger LOGGER = Logger.getLogger(GenerateKeyTest.class.getName());

    @Test
    public void generateKey() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("fresh@encrypted.key", "password123");
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ArmoredOutputStream armor = new ArmoredOutputStream((OutputStream)bytes);
        secretKeys.encode((OutputStream)armor);
        armor.close();
        String publicKey = new String(bytes.toByteArray());
        bytes = new ByteArrayOutputStream();
        armor = new ArmoredOutputStream((OutputStream)bytes);
        secretKeys.encode((OutputStream)armor);
        armor.close();
        String privateKey = new String(bytes.toByteArray());
        LOGGER.log(Level.INFO, String.format("Generated random fresh EC key ring.\nUser-ID: %s\nFingerprint: %s\nKey-ID: %s\n%s\n%s\n", secretKeys.getPublicKey().getUserIDs().next(), new OpenPgpV4Fingerprint(publicKeys), publicKeys.getPublicKey().getKeyID(), publicKey, privateKey));
    }
}

