/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.util.KeyRingUtils;

public class GenerateKeyWithAdditionalUserIdTest {
    @Test
    public void test() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().withMasterKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()).withPrimaryUserId("primary@user.id").withAdditionalUserId("additional@user.id").withAdditionalUserId("additional2@user.id").withAdditionalUserId("\ttrimThis@user.id     ").withoutPassphrase().build();
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        Iterator userIds = publicKeys.getPublicKey().getUserIDs();
        Assertions.assertEquals((Object)"primary@user.id", userIds.next());
        Assertions.assertEquals((Object)"additional@user.id", userIds.next());
        Assertions.assertEquals((Object)"additional2@user.id", userIds.next());
        Assertions.assertEquals((Object)"trimThis@user.id", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ArmoredOutputStream armor = new ArmoredOutputStream((OutputStream)byteOut);
        secretKeys.encode((OutputStream)armor);
        armor.close();
        System.out.println(byteOut.toString("UTF-8"));
    }
}

