/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.Passphrase;

public class AddUserIdTest {
    @Test
    public void addUserIdToExistingKeyRing() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("alice@wonderland.lit", "rabb1th0le");
        Iterator userIds = secretKeys.getSecretKey().getPublicKey().getUserIDs();
        Assertions.assertEquals((Object)"alice@wonderland.lit", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"rabb1th0le"));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId("cheshirecat@wonderland.lit", (SecretKeyRingProtector)protector).done();
        userIds = secretKeys.getPublicKey().getUserIDs();
        Assertions.assertEquals((Object)"alice@wonderland.lit", userIds.next());
        Assertions.assertEquals((Object)"cheshirecat@wonderland.lit", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).deleteUserId("cheshirecat@wonderland.lit", (SecretKeyRingProtector)protector).done();
        userIds = secretKeys.getPublicKey().getUserIDs();
        Assertions.assertEquals((Object)"alice@wonderland.lit", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
    }

    @Test
    public void addUserId_NoSuchElementExceptionForMissingKey() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Assertions.assertThrows(NoSuchElementException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId(0L, "cryptie@encrypted.key", (SecretKeyRingProtector)new UnprotectedKeysProtector()));
    }

    @Test
    public void deleteUserId_noSuchElementExceptionForMissingUserId() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Assertions.assertThrows(NoSuchElementException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).deleteUserId("invalid@user.id", (SecretKeyRingProtector)new UnprotectedKeysProtector()));
    }

    @Test
    public void deleteUserId_noSuchElementExceptionForMissingKey() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Assertions.assertThrows(NoSuchElementException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).deleteUserId(0L, "cryptie@encrypted.key", (SecretKeyRingProtector)new UnprotectedKeysProtector()));
    }
}

