/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class ChangeExpirationTest {
    @Test
    public void setExpirationDateAndThenUnsetIt() throws PGPException, IOException, InterruptedException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        OpenPgpV4Fingerprint fingerprint = sInfo.getFingerprint();
        Assertions.assertNull((Object)sInfo.getExpirationDate());
        Date date = new Date(1606493432000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(fingerprint, date, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNotNull((Object)sInfo.getExpirationDate());
        Assertions.assertEquals((long)date.getTime(), (long)sInfo.getExpirationDate().getTime());
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(fingerprint, null, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getExpirationDate());
    }
}

