/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class PassphraseProtectedKeyTest {
    private final PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(KeyRingProtectionSettings.secureDefaultSettings(), new SecretKeyPassphraseProvider(){

        @Nullable
        public Passphrase getPassphraseFor(Long keyId) {
            if (keyId.equals(-821156605394703576L)) {
                return new Passphrase("password123".toCharArray());
            }
            return null;
        }
    });

    @Test
    public void testReturnsNonNullDecryptorEncryptorForPassword() throws PGPException {
        Assertions.assertNotNull((Object)this.protector.getEncryptor(Long.valueOf(-821156605394703576L)));
        Assertions.assertNotNull((Object)this.protector.getDecryptor(Long.valueOf(-821156605394703576L)));
    }

    @Test
    public void testReturnsNullDecryptorEncryptorForNoPassword() throws PGPException {
        Assertions.assertNull((Object)this.protector.getEncryptor(Long.valueOf(-5425419407118114754L)));
        Assertions.assertNull((Object)this.protector.getDecryptor(Long.valueOf(-5425419407118114754L)));
    }
}

