/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.key;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHCurve;
import org.pgpainless.key.selection.key.impl.HasAllKeyFlagSelectionStrategy;
import org.pgpainless.key.selection.key.impl.HasAnyKeyFlagSelectionStrategy;

public class KeyFlagBasedSelectionStrategyTest {
    @Test
    public void testKeyFlagSelectors() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)KeyType.ECDSA((EllipticCurve)EllipticCurve._P256)).withKeyFlags(new KeyFlag[]{KeyFlag.SIGN_DATA}).withDefaultAlgorithms()).withSubKey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHCurve)XDHCurve._X25519)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()).withMasterKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.AUTHENTICATION}).withDefaultAlgorithms()).withPrimaryUserId("test@test.test").withoutPassphrase().build();
        Iterator iterator = secretKeys.iterator();
        PGPSecretKey s_primaryKey = (PGPSecretKey)iterator.next();
        PGPSecretKey s_signingKey = (PGPSecretKey)iterator.next();
        PGPSecretKey s_encryptionKey = (PGPSecretKey)iterator.next();
        HasAllKeyFlagSelectionStrategy.SecretKey s_certifyOther = new HasAllKeyFlagSelectionStrategy.SecretKey(new KeyFlag[]{KeyFlag.CERTIFY_OTHER});
        HasAllKeyFlagSelectionStrategy.SecretKey s_encryptComms = new HasAllKeyFlagSelectionStrategy.SecretKey(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS});
        HasAllKeyFlagSelectionStrategy.SecretKey s_encryptCommsEncryptStorage = new HasAllKeyFlagSelectionStrategy.SecretKey(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE});
        HasAnyKeyFlagSelectionStrategy.SecretKey s_anyEncryptCommsEncryptStorage = new HasAnyKeyFlagSelectionStrategy.SecretKey(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE});
        Assertions.assertTrue((boolean)s_certifyOther.accept(s_primaryKey));
        Assertions.assertFalse((boolean)s_certifyOther.accept(s_encryptionKey));
        Assertions.assertFalse((boolean)s_certifyOther.accept(s_signingKey));
        Assertions.assertTrue((boolean)s_encryptComms.accept(s_encryptionKey));
        Assertions.assertFalse((boolean)s_encryptComms.accept(s_primaryKey));
        Assertions.assertFalse((boolean)s_encryptComms.accept(s_signingKey));
        Assertions.assertFalse((boolean)s_encryptCommsEncryptStorage.accept(s_encryptionKey), (String)"Must not accept the key, as it only carries ENCRYPT_COMMS, but not ENCRYPT_STORAGE");
        Assertions.assertFalse((boolean)s_encryptCommsEncryptStorage.accept(s_primaryKey));
        Assertions.assertFalse((boolean)s_encryptCommsEncryptStorage.accept(s_signingKey));
        Assertions.assertTrue((boolean)s_anyEncryptCommsEncryptStorage.accept(s_encryptionKey));
        Assertions.assertFalse((boolean)s_anyEncryptCommsEncryptStorage.accept(s_primaryKey));
        Assertions.assertFalse((boolean)s_anyEncryptCommsEncryptStorage.accept(s_signingKey));
        PGPPublicKey p_primaryKey = s_primaryKey.getPublicKey();
        PGPPublicKey p_encryptionKey = s_encryptionKey.getPublicKey();
        PGPPublicKey p_signingKey = s_signingKey.getPublicKey();
        HasAllKeyFlagSelectionStrategy.PublicKey p_certifyOther = new HasAllKeyFlagSelectionStrategy.PublicKey(new KeyFlag[]{KeyFlag.CERTIFY_OTHER});
        HasAllKeyFlagSelectionStrategy.PublicKey p_encryptComms = new HasAllKeyFlagSelectionStrategy.PublicKey(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS});
        HasAllKeyFlagSelectionStrategy.PublicKey p_encryptCommsEncryptStorage = new HasAllKeyFlagSelectionStrategy.PublicKey(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE});
        HasAnyKeyFlagSelectionStrategy.PublicKey p_anyEncryptCommsEncryptStorage = new HasAnyKeyFlagSelectionStrategy.PublicKey(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE});
        Assertions.assertTrue((boolean)p_certifyOther.accept(p_primaryKey));
        Assertions.assertFalse((boolean)p_certifyOther.accept(p_encryptionKey));
        Assertions.assertFalse((boolean)p_certifyOther.accept(p_signingKey));
        Assertions.assertTrue((boolean)p_encryptComms.accept(p_encryptionKey));
        Assertions.assertFalse((boolean)p_encryptComms.accept(p_primaryKey));
        Assertions.assertFalse((boolean)p_encryptComms.accept(p_signingKey));
        Assertions.assertFalse((boolean)p_encryptCommsEncryptStorage.accept(p_encryptionKey), (String)"Must not accept the key, as it only carries ENCRYPT_COMMS, but not ENCRYPT_STORAGE");
        Assertions.assertFalse((boolean)p_encryptCommsEncryptStorage.accept(p_primaryKey));
        Assertions.assertFalse((boolean)p_encryptCommsEncryptStorage.accept(p_signingKey));
        Assertions.assertTrue((boolean)p_anyEncryptCommsEncryptStorage.accept(p_encryptionKey));
        Assertions.assertFalse((boolean)p_anyEncryptCommsEncryptStorage.accept(p_primaryKey));
        Assertions.assertFalse((boolean)p_anyEncryptCommsEncryptStorage.accept(p_signingKey));
    }
}

