/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.keyring;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.selection.keyring.impl.Email;

public class EmailKeyRingSelectionStrategyTest {
    @Test
    public void testMatchingEmailUIDAcceptedOnPubKey() throws IOException {
        String uid = "<emil@email.user>";
        PGPPublicKey key = TestKeys.getEmilPublicKeyRing().getPublicKey();
        Email.PubRingSelectionStrategy pubKeySelectionStrategy = new Email.PubRingSelectionStrategy(uid);
        Assertions.assertTrue((boolean)pubKeySelectionStrategy.accept(key));
    }

    @Test
    public void testAddressIsFormattedToMatchOnPubKey() throws IOException {
        String uid = "emil@email.user";
        PGPPublicKey key = TestKeys.getEmilPublicKeyRing().getPublicKey();
        Email.PubRingSelectionStrategy pubKeySelectionStrategy = new Email.PubRingSelectionStrategy(uid);
        Assertions.assertTrue((boolean)pubKeySelectionStrategy.accept(key));
    }

    @Test
    public void testPubKeyWithDifferentUIDIsRejected() throws IOException {
        String wrongUid = "emilia@email.user";
        PGPPublicKey key = TestKeys.getEmilPublicKeyRing().getPublicKey();
        Email.PubRingSelectionStrategy pubKeySelectionStrategy = new Email.PubRingSelectionStrategy(wrongUid);
        Assertions.assertFalse((boolean)pubKeySelectionStrategy.accept(key));
    }

    @Test
    public void testMatchingEmailUIDAcceptedOnSecKey() throws IOException, PGPException {
        String uid = "<emil@email.user>";
        PGPSecretKey key = TestKeys.getEmilSecretKeyRing().getSecretKey();
        Email.SecRingSelectionStrategy secKeySelectionStrategy = new Email.SecRingSelectionStrategy(uid);
        Assertions.assertTrue((boolean)secKeySelectionStrategy.accept(key));
    }

    @Test
    public void testAddressIsFormattedToMatchOnSecKey() throws IOException, PGPException {
        String uid = "emil@email.user";
        PGPSecretKey key = TestKeys.getEmilSecretKeyRing().getSecretKey();
        Email.SecRingSelectionStrategy secKeySelectionStrategy = new Email.SecRingSelectionStrategy(uid);
        Assertions.assertTrue((boolean)secKeySelectionStrategy.accept(key));
    }

    @Test
    public void testSecKeyWithDifferentUIDIsRejected() throws IOException, PGPException {
        String wrongUid = "emilia@email.user";
        PGPSecretKey key = TestKeys.getEmilSecretKeyRing().getSecretKey();
        Email.SecRingSelectionStrategy secKeySelectionStrategy = new Email.SecRingSelectionStrategy(wrongUid);
        Assertions.assertFalse((boolean)secKeySelectionStrategy.accept(key));
    }
}

