/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.symmetric_encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.util.Passphrase;

public class LegacySymmetricEncryptionTest {
    private static final Logger LOGGER = Logger.getLogger(LegacySymmetricEncryptionTest.class.getName());
    private static final String message = "I grew up with the understanding that the world I lived in was one where people enjoyed a sort of freedom to communicate with each other in privacy, without it being monitored, without it being measured or analyzed or sort of judged by these shadowy figures or systems, any time they mention anything that travels across public lines.\n\n- Edward Snowden -";

    @Test
    public void testSymmetricEncryptionDecryption() throws IOException, PGPException {
        byte[] plain = message.getBytes();
        String password = "choose_a_better_password_please";
        Passphrase passphrase = new Passphrase(password.toCharArray());
        byte[] enc = PGPainless.encryptWithPassword((byte[])plain, (Passphrase)passphrase, (SymmetricKeyAlgorithm)SymmetricKeyAlgorithm.AES_128);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armor = new ArmoredOutputStream((OutputStream)out);
        armor.write(enc);
        armor.flush();
        armor.close();
        LOGGER.log(Level.INFO, String.format("Use ciphertext below for manual validation with GnuPG (passphrase = '%s').\n\n%s", password, new String(out.toByteArray())));
        byte[] plain2 = PGPainless.decryptWithPassword((byte[])enc, (Passphrase)passphrase);
        Assertions.assertArrayEquals((byte[])plain, (byte[])plain2);
    }
}

