/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.symmetric_encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.util.Passphrase;

public class MultiPassphraseSymmetricEncryptionTest {
    @Test
    public void test() throws IOException, PGPException {
        String message = "Here we test if during decryption of a message that was encrypted with two passphrases, the decryptor finds the session key encrypted for the right passphrase.";
        ByteArrayInputStream plaintextIn = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).forPassphrases(new Passphrase[]{Passphrase.fromPassword((String)"p1"), Passphrase.fromPassword((String)"p2")}).usingSecureAlgorithms().doNotSign().noArmor();
        Streams.pipeAll((InputStream)plaintextIn, (OutputStream)encryptor);
        encryptor.close();
        byte[] ciphertext = ciphertextOut.toByteArray();
        for (Passphrase passphrase : new Passphrase[]{Passphrase.fromPassword((String)"p2"), Passphrase.fromPassword((String)"p1")}) {
            DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(ciphertext)).decryptWith(passphrase).doNotVerify().build();
            ByteArrayOutputStream plaintextOut = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)decryptor, (OutputStream)plaintextOut);
            decryptor.close();
        }
    }
}

