/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.symmetric_encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.key.protection.passphrase_provider.SolitaryPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class SymmetricEncryptionTest {
    @Test
    public void test() throws IOException, PGPException {
        byte[] plaintext = "This is a secret message".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream plaintextIn = new ByteArrayInputStream(plaintext);
        PGPPublicKeyRing encryptionKey = TestKeys.getCryptiePublicKeyRing();
        Passphrase encryptionPassphrase = Passphrase.fromPassword((String)"greenBeans");
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).forPassphrases(new Passphrase[]{encryptionPassphrase}).and().toRecipients(new PGPPublicKeyRing[]{encryptionKey}).usingSecureAlgorithms().doNotSign().noArmor();
        Streams.pipeAll((InputStream)plaintextIn, (OutputStream)encryptor);
        encryptor.close();
        byte[] ciphertext = ciphertextOut.toByteArray();
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(ciphertext)).decryptWith(encryptionPassphrase).doNotVerify().build();
        ByteArrayOutputStream decrypted = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)decrypted);
        decryptor.close();
        Assertions.assertArrayEquals((byte[])plaintext, (byte[])decrypted.toByteArray());
        PGPSecretKeyRingCollection decryptionKeys = TestKeys.getCryptieSecretKeyRingCollection();
        PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(KeyRingProtectionSettings.secureDefaultSettings(), (SecretKeyPassphraseProvider)new SolitaryPassphraseProvider(Passphrase.fromPassword((String)"password123")));
        decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(ciphertext)).decryptWith((SecretKeyRingProtector)protector, decryptionKeys).doNotVerify().build();
        decrypted = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)decrypted);
        decryptor.close();
        Assertions.assertArrayEquals((byte[])plaintext, (byte[])decrypted.toByteArray());
    }
}

