/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum SignatureType {
    BINARY_DOCUMENT(0),
    CANONICAL_TEXT_DOCUMENT(1),
    STANDALONE(2),
    GENERIC_CERTIFICATION(16),
    NO_CERTIFICATION(17),
    CASUAL_CERTIFICATION(18),
    POSITIVE_CERTIFICATION(19),
    SUBKEY_BINDING(24),
    PRIMARYKEY_BINDING(25),
    DIRECT_KEY(31),
    KEY_REVOCATION(32),
    SUBKEY_REVOCATION(40),
    CERTIFICATION_REVOCATION(48),
    TIMESTAMP(64),
    THIRD_PARTY_CONFIRMATION(80);

    private static final Map<Integer, SignatureType> map;
    private final int code;

    public static SignatureType valueOf(int code) {
        SignatureType type = map.get(code);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Signature type 0x" + Integer.toHexString(code) + " appears to be invalid.");
    }

    private SignatureType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    static {
        map = new ConcurrentHashMap<Integer, SignatureType>();
        for (SignatureType sigType : SignatureType.values()) {
            map.put(sigType.getCode(), sigType);
        }
    }
}

