/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.implementation;

import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.BcImplementationFactory;
import org.pgpainless.util.Passphrase;

public abstract class ImplementationFactory {
    private static ImplementationFactory FACTORY_IMPLEMENTATION = new BcImplementationFactory();

    public static void setFactoryImplementation(ImplementationFactory implementation) {
        FACTORY_IMPLEMENTATION = implementation;
    }

    public static ImplementationFactory getInstance() {
        return FACTORY_IMPLEMENTATION;
    }

    public PBESecretKeyEncryptor getPBESecretKeyEncryptor(SymmetricKeyAlgorithm symmetricKeyAlgorithm, Passphrase passphrase) throws PGPException {
        return this.getPBESecretKeyEncryptor(symmetricKeyAlgorithm, this.getPGPDigestCalculator(HashAlgorithm.SHA1), passphrase);
    }

    public PBESecretKeyEncryptor getPBESecretKeyEncryptor(PGPSecretKey secretKey, Passphrase passphrase) throws PGPException {
        return FACTORY_IMPLEMENTATION.getPBESecretKeyEncryptor(secretKey, passphrase);
    }

    public PBESecretKeyEncryptor getPBESecretKeyEncryptor(SymmetricKeyAlgorithm symmetricKeyAlgorithm, PGPDigestCalculator digestCalculator, Passphrase passphrase) {
        return FACTORY_IMPLEMENTATION.getPBESecretKeyEncryptor(symmetricKeyAlgorithm, digestCalculator, passphrase);
    }

    public PBESecretKeyDecryptor getPBESecretKeyDecryptor(Passphrase passphrase) throws PGPException {
        return FACTORY_IMPLEMENTATION.getPBESecretKeyDecryptor(passphrase);
    }

    public PGPDigestCalculator getPGPDigestCalculator(HashAlgorithm algorithm) throws PGPException {
        return this.getPGPDigestCalculator(algorithm.getAlgorithmId());
    }

    public PGPDigestCalculator getPGPDigestCalculator(int algorithm) throws PGPException {
        return this.getPGPDigestCalculatorProvider().get(algorithm);
    }

    public PGPDigestCalculatorProvider getPGPDigestCalculatorProvider() throws PGPException {
        return FACTORY_IMPLEMENTATION.getPGPDigestCalculatorProvider();
    }

    public PGPContentVerifierBuilderProvider getPGPContentVerifierBuilderProvider() {
        return FACTORY_IMPLEMENTATION.getPGPContentVerifierBuilderProvider();
    }

    public PGPContentSignerBuilder getPGPContentSignerBuilder(PublicKeyAlgorithm keyAlgorithm, HashAlgorithm hashAlgorithm) {
        return this.getPGPContentSignerBuilder(keyAlgorithm.getAlgorithmId(), hashAlgorithm.getAlgorithmId());
    }

    public PGPContentSignerBuilder getPGPContentSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        return FACTORY_IMPLEMENTATION.getPGPContentSignerBuilder(keyAlgorithm, hashAlgorithm);
    }

    public KeyFingerPrintCalculator getKeyFingerprintCalculator() {
        return FACTORY_IMPLEMENTATION.getKeyFingerprintCalculator();
    }

    public PBEDataDecryptorFactory getPBEDataDecryptorFactory(Passphrase passphrase) throws PGPException {
        return FACTORY_IMPLEMENTATION.getPBEDataDecryptorFactory(passphrase);
    }

    public PublicKeyDataDecryptorFactory getPublicKeyDataDecryptorFactory(PGPPrivateKey privateKey) {
        return FACTORY_IMPLEMENTATION.getPublicKeyDataDecryptorFactory(privateKey);
    }

    public PublicKeyKeyEncryptionMethodGenerator getPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey key) {
        return FACTORY_IMPLEMENTATION.getPublicKeyKeyEncryptionMethodGenerator(key);
    }

    public PBEKeyEncryptionMethodGenerator getPBEKeyEncryptionMethodGenerator(Passphrase passphrase) {
        return FACTORY_IMPLEMENTATION.getPBEKeyEncryptionMethodGenerator(passphrase);
    }

    public PGPDataEncryptorBuilder getPGPDataEncryptorBuilder(SymmetricKeyAlgorithm symmetricKeyAlgorithm) {
        return this.getPGPDataEncryptorBuilder(symmetricKeyAlgorithm.getAlgorithmId());
    }

    public PGPDataEncryptorBuilder getPGPDataEncryptorBuilder(int symmetricKeyAlgorithm) {
        return FACTORY_IMPLEMENTATION.getPGPDataEncryptorBuilder(symmetricKeyAlgorithm);
    }

    public PGPKeyPair getPGPKeyPair(PublicKeyAlgorithm algorithm, KeyPair keyPair, Date creationDate) throws PGPException {
        return FACTORY_IMPLEMENTATION.getPGPKeyPair(algorithm, keyPair, creationDate);
    }

    public PGPKeyPair getPGPKeyPair(PublicKeyAlgorithm algorithm, AsymmetricCipherKeyPair keyPair, Date creationDate) throws PGPException, NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        return FACTORY_IMPLEMENTATION.getPGPKeyPair(algorithm, keyPair, creationDate);
    }

    public PBESecretKeyEncryptor getPBESecretKeyEncryptor(SymmetricKeyAlgorithm encryptionAlgorithm, HashAlgorithm hashAlgorithm, int s2kCount, Passphrase passphrase) throws PGPException {
        return FACTORY_IMPLEMENTATION.getPBESecretKeyEncryptor(encryptionAlgorithm, hashAlgorithm, s2kCount, passphrase);
    }
}

