/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilderInterface;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.util.UserId;
import org.pgpainless.provider.ProviderFactory;
import org.pgpainless.util.Passphrase;

public class KeyRingBuilder
implements KeyRingBuilderInterface {
    private final Charset UTF8 = Charset.forName("UTF-8");
    private List<KeySpec> keySpecs = new ArrayList<KeySpec>();
    private String userId;
    private Set<String> additionalUserIds = new LinkedHashSet<String>();
    private Passphrase passphrase;

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull UserId userId, @Nonnull RsaLength length) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId.toString(), length);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull String userId, @Nonnull RsaLength length) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId, length, null);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull UserId userId, @Nonnull RsaLength rsaLength, String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId.toString(), rsaLength, password);
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nonnull String userId, @Nonnull RsaLength length, String password) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase builder = this.withMasterKey(KeySpec.getBuilder(KeyType.RSA(length)).withKeyFlags(KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS).withDefaultAlgorithms()).withPrimaryUserId(userId);
        if (password == null) {
            return builder.withoutPassphrase().build();
        }
        return builder.withPassphrase(new Passphrase(password.toCharArray())).build();
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull UserId userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId.toString());
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull String userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId, null);
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull UserId userId, String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId.toString(), password);
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nonnull String userId, String password) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase builder = this.withSubKey(KeySpec.getBuilder(KeyType.ECDH(EllipticCurve._P256)).withKeyFlags(KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS).withDefaultAlgorithms()).withMasterKey(KeySpec.getBuilder(KeyType.ECDSA(EllipticCurve._P256)).withKeyFlags(KeyFlag.AUTHENTICATION, KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA).withDefaultAlgorithms()).withPrimaryUserId(userId);
        if (password == null) {
            return builder.withoutPassphrase().build();
        }
        return builder.withPassphrase(new Passphrase(password.toCharArray())).build();
    }

    @Override
    public KeyRingBuilderInterface withSubKey(@Nonnull KeySpec type) {
        this.keySpecs.add(type);
        return this;
    }

    @Override
    public KeyRingBuilderInterface.WithPrimaryUserId withMasterKey(@Nonnull KeySpec spec) {
        this.verifyMasterKeyCanCertify(spec);
        this.keySpecs.add(0, spec);
        return new WithPrimaryUserIdImpl();
    }

    private void verifyMasterKeyCanCertify(KeySpec spec) {
        if (!this.hasCertifyOthersFlag(spec)) {
            throw new IllegalArgumentException("Certification Key MUST have KeyFlag CERTIFY_OTHER");
        }
        if (!this.keyIsCertificationCapable(spec)) {
            throw new IllegalArgumentException("Key algorithm " + spec.getKeyType().getName() + " is not capable of creating certifications.");
        }
    }

    private boolean hasCertifyOthersFlag(KeySpec keySpec) {
        int flags = keySpec.getSubpackets().getKeyFlags();
        return KeyFlag.hasKeyFlag(flags, KeyFlag.CERTIFY_OTHER);
    }

    private boolean keyIsCertificationCapable(KeySpec keySpec) {
        return keySpec.getKeyType().canCertify();
    }

    public static PGPKeyPair generateKeyPair(KeySpec spec) throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
        KeyType type = spec.getKeyType();
        KeyPairGenerator certKeyGenerator = KeyPairGenerator.getInstance(type.getName(), ProviderFactory.getProvider());
        certKeyGenerator.initialize(type.getAlgorithmSpec());
        KeyPair keyPair = certKeyGenerator.generateKeyPair();
        PGPKeyPair pgpKeyPair = ImplementationFactory.getInstance().getPGPKeyPair(type.getAlgorithm(), keyPair, new Date());
        return pgpKeyPair;
    }

    class WithAdditionalUserIdOrPassphraseImpl
    implements KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase {
        WithAdditionalUserIdOrPassphraseImpl() {
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase withAdditionalUserId(@Nonnull String userId) {
            String trimmed = userId.trim();
            if (KeyRingBuilder.this.userId.equals(trimmed)) {
                throw new IllegalArgumentException("Additional user-id MUST NOT be equal to primary user-id.");
            }
            KeyRingBuilder.this.additionalUserIds.add(trimmed);
            return this;
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase withAdditionalUserId(@Nonnull byte[] userId) {
            return this.withAdditionalUserId(new String(userId, KeyRingBuilder.this.UTF8));
        }

        @Override
        public KeyRingBuilderInterface.Build withPassphrase(@Nonnull Passphrase passphrase) {
            KeyRingBuilder.this.passphrase = passphrase;
            return new BuildImpl();
        }

        @Override
        public KeyRingBuilderInterface.Build withoutPassphrase() {
            KeyRingBuilder.this.passphrase = null;
            return new BuildImpl();
        }

        class BuildImpl
        implements KeyRingBuilderInterface.Build {
            private PGPSignatureGenerator signatureGenerator;
            private PGPDigestCalculator digestCalculator;
            private PBESecretKeyEncryptor secretKeyEncryptor;

            BuildImpl() {
            }

            @Override
            public PGPSecretKeyRing build() throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
                this.digestCalculator = this.buildDigestCalculator();
                this.secretKeyEncryptor = this.buildSecretKeyEncryptor();
                PBESecretKeyDecryptor secretKeyDecryptor = this.buildSecretKeyDecryptor();
                if (KeyRingBuilder.this.passphrase != null) {
                    KeyRingBuilder.this.passphrase.clear();
                }
                KeySpec certKeySpec = (KeySpec)KeyRingBuilder.this.keySpecs.remove(0);
                PGPKeyPair certKey = KeyRingBuilder.generateKeyPair(certKeySpec);
                PGPContentSignerBuilder signer = this.buildContentSigner(certKey);
                this.signatureGenerator = new PGPSignatureGenerator(signer);
                PGPSignatureSubpacketVector hashedSubPackets = certKeySpec.getSubpackets();
                PGPKeyRingGenerator ringGenerator = this.buildRingGenerator(certKey, signer, hashedSubPackets);
                this.addSubKeys(ringGenerator);
                PGPSecretKeyRing secretKeyRing = ringGenerator.generateSecretKeyRing();
                Iterator secretKeys = secretKeyRing.getSecretKeys();
                PGPPublicKey primaryPubKey = ((PGPSecretKey)secretKeys.next()).getPublicKey();
                PGPPrivateKey privateKey = secretKeyRing.getSecretKey().extractPrivateKey(secretKeyDecryptor);
                for (String additionalUserId : KeyRingBuilder.this.additionalUserIds) {
                    this.signatureGenerator.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), privateKey);
                    PGPSignature additionalUserIdSignature = this.signatureGenerator.generateCertification(additionalUserId, primaryPubKey);
                    primaryPubKey = PGPPublicKey.addCertification((PGPPublicKey)primaryPubKey, (String)additionalUserId, (PGPSignature)additionalUserIdSignature);
                }
                PGPSecretKey primarySecKey = new PGPSecretKey(privateKey, primaryPubKey, this.digestCalculator, true, this.secretKeyEncryptor);
                ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
                secretKeyList.add(primarySecKey);
                while (secretKeys.hasNext()) {
                    secretKeyList.add((PGPSecretKey)secretKeys.next());
                }
                secretKeyRing = new PGPSecretKeyRing(secretKeyList);
                return secretKeyRing;
            }

            private PGPKeyRingGenerator buildRingGenerator(PGPKeyPair certKey, PGPContentSignerBuilder signer, PGPSignatureSubpacketVector hashedSubPackets) throws PGPException {
                return new PGPKeyRingGenerator(SignatureType.POSITIVE_CERTIFICATION.getCode(), certKey, KeyRingBuilder.this.userId, this.digestCalculator, hashedSubPackets, null, signer, this.secretKeyEncryptor);
            }

            private void addSubKeys(PGPKeyRingGenerator ringGenerator) throws NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
                for (KeySpec subKeySpec : KeyRingBuilder.this.keySpecs) {
                    PGPKeyPair subKey = KeyRingBuilder.generateKeyPair(subKeySpec);
                    if (subKeySpec.isInheritedSubPackets()) {
                        ringGenerator.addSubKey(subKey);
                        continue;
                    }
                    ringGenerator.addSubKey(subKey, subKeySpec.getSubpackets(), null);
                }
            }

            private PGPContentSignerBuilder buildContentSigner(PGPKeyPair certKey) {
                return ImplementationFactory.getInstance().getPGPContentSignerBuilder(certKey.getPublicKey().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId());
            }

            private PBESecretKeyEncryptor buildSecretKeyEncryptor() {
                PBESecretKeyEncryptor encryptor = KeyRingBuilder.this.passphrase == null || KeyRingBuilder.this.passphrase.isEmpty() ? null : ImplementationFactory.getInstance().getPBESecretKeyEncryptor(SymmetricKeyAlgorithm.AES_256, this.digestCalculator, KeyRingBuilder.this.passphrase);
                return encryptor;
            }

            private PBESecretKeyDecryptor buildSecretKeyDecryptor() throws PGPException {
                PBESecretKeyDecryptor decryptor = KeyRingBuilder.this.passphrase == null || KeyRingBuilder.this.passphrase.isEmpty() ? null : ImplementationFactory.getInstance().getPBESecretKeyDecryptor(KeyRingBuilder.this.passphrase);
                return decryptor;
            }

            private PGPDigestCalculator buildDigestCalculator() throws PGPException {
                return ImplementationFactory.getInstance().getPGPDigestCalculator(HashAlgorithm.SHA1);
            }
        }
    }

    class WithPrimaryUserIdImpl
    implements KeyRingBuilderInterface.WithPrimaryUserId {
        WithPrimaryUserIdImpl() {
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase withPrimaryUserId(@Nonnull String userId) {
            KeyRingBuilder.this.userId = userId.trim();
            return new WithAdditionalUserIdOrPassphraseImpl();
        }

        @Override
        public KeyRingBuilderInterface.WithAdditionalUserIdOrPassphrase withPrimaryUserId(@Nonnull byte[] userId) {
            return this.withPrimaryUserId(new String(userId, KeyRingBuilder.this.UTF8));
        }
    }
}

